<html>
<head>
    <title>Price List</title>
</head>
<body>
    <div class="panel">
        <div class="">
            <?php $this->renderPartial('//common/header'); ?>
        </div>

        <div class="row">
            <div class="col-4"><br></div>
            <div class="col-4">
                <div class="h3" style="margin:0; text-align:center; font-size:16px;">
                    <?php echo strtoupper("Price List"); ?>
                </div>
            </div>
            <div class="col-4" style="color:#101010;">
        <table class="table table-bordered" style="width:100%; margin-bottom:0;">
            <tbody>
                <?php if ($product_id != '') { 
                    $product_model = Store::model()->findByPK($product_id);
                    $group_model   = SalesPriceGroupName::model()->findByPk($pricing_group_id);
                ?>
                    <tr>
                        <td style="width:40%; font-weight:bold;">Part No :</td>
                        <td style="width:60%;"><?php echo $product_model->part_number; ?></td>
                    </tr>
                    <tr>
                        <td style="width:40%; font-weight:bold;">Pricing Group :</td>
                        <td style="width:60%;"><?php echo !empty($group_model) ? $group_model->pricing_group_name : '-'; ?></td>
                    </tr>
                <?php } ?>
            </tbody>
                </table>
            </div>
        </div>

        <?php
        
        $condition = '1=1';
        if ($brand != '') {
            $condition .= ' AND S.brand_class_id ="' . $brand . '"';
        }
        if ($product_id != '') {
            $condition .= ' AND S.id = "' . $product_id . '"';
        }
        if($pricing_group_id != '') {        
            $condition .= ' AND SPG.pricing_group_id = "'.$pricing_group_id.'"';
        }

        $sql = "SELECT S.id,
                       S.part_number,
                       S.description,
                       SPG.sales_price,
                       G.pricing_group_name
                FROM {{sales_price_group}} SPG
                INNER JOIN {{store}} S ON S.id = SPG.product_id
                INNER JOIN {{sales_price_group_name}} G ON G.id = SPG.pricing_group_id
                WHERE $condition
                ORDER BY SPG.id ASC";

        $model_group = Yii::app()->db->createCommand($sql)->queryAll();
        // echo $condition;
        ?>

        <div class="panel-body">
            <div class="table-responsive">
                <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Part no</th>
                            <th>Description</th>
                            <th>Sales Price</th>
                            <th>Pricing Group Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sno = 1;
                        if (!empty($model_group)) {
                            foreach ($model_group as $row) {
                                ?>
                                <tr>
                                    <td><?php echo $sno++; ?></td>
                                    <td><?php echo $row['part_number']; ?></td>
                                    <td><?php echo $row['description']; ?></td>
                                    <td style="text-align:right;"><?php echo number_format((float) $row['sales_price'], 2, '.', ''); ?></td>
                                    <td><?php echo $row['pricing_group_name']; ?></td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="5" style="text-align:center;">No data found</td>
                            </tr>
                            <?php
                        }
                        ?>
                    </tbody>
                </table>
                <br>
            </div>
        </div>
    </div>

    <?php $this->renderPartial("//common/footer"); ?>
</body>
</html>
