        <div id="div_master_report_orderlist">
		<?php

            $fin_month = Yii::app()->user->fin_year; 
            
            $year = date('Y');
            $year_next = $year + 1;
            if($fin_month == 1){
                $from_date = $year.'-01-01';
                $end_date = $year.'-12-31';
            }else{
                $from_date = $year.'-04-01';
                $end_date = $year_next.'-03-31';
            }
            $startDate = date("d-m-Y", strtotime($from_date));
            
            $endDate = date("d-m-Y");

			?>

                    <ul class="clearfix form-ul material" id="orderlist-form-hide"> 
                        <li class="col-sm-3">
                            <div class="material">    
                                <?php echo CHtml::textField('vendor_name','',array('class' => 'tooltipster', 'placeholder' => 'Please choose a supplier','data-label'=>'Supplier','onKeyup' => 'js:autoCompleteVendor(this.id,"order");')); ?>
                                <?php echo CHtml::hiddenField('ord_vendor_id'); ?>
                            </div>
                        </li>
                        <li class="col-sm-2">
                            <div class="material">    
                                <?php echo CHtml::textField('order_from_date', $startDate,array('class' => 'datepicker','data-label'=>'Order Date From'));?>
                            </div>
                        </li>
                         <li class="col-sm-2">
                            <div class="material">    
                                <?php echo CHtml::textField('order_to_date', $endDate,array('class' => 'datepicker','data-label'=>'Order Date To'));?>
                            </div>
                        </li>                        
                         <li class="col-sm-2">
                            <div class="material">    
                                <?php echo CHtml::dropDownList('completed', '',array('P'=>'MR(P)','C'=>'Short Closure'), array('class' => 'tooltipster','data-label'=>'Status','empty'=>'All'));?>
                            </div>
                        </li>
                        
                    </ul>
        </div>
        <div class='btn-wrap text-center'>
            <button type="button" class="btn btn-theme" onclick="loadMasterReport();return false;" title="HTML"><i class="fa fa-file-text"></i> &nbsp;HTML</button>
            <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_order_report_download"]))) { ?>
            <!-- Pdf & Excel btns movedd from htmlpage to filter page ---- Ambika -->
            <a title="Export Pdf" class="btn btn-theme" onclick="purchaseOrderListPDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
            <a title="Export Excel" class="btn btn-theme" onclick="excelPurchaseOrderList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>
        <?php } ?>
       </div><?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteVendor", "function autoCompleteVendor(field_id,frm)

		{
//                alert(frm);
		var url = '" . Yii::app()->createUrl('vendor/Getvendor') . "'+'&frm='+frm;

		$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

				var crm_user_id=ui.item.value; 	
                                 $('#ord_vendor_id').val(crm_user_id)
             

			}

			})



		}", CClientScript::POS_HEAD); 

    // ---- purchaseOrderListPDF() & excelPurchaseOrderList() moved from html page to filter page --- Ambika --
    $cs->registerScript("purchaseOrderListPDF", "function purchaseOrderListPDF(){
  

                var order_from_date = $('#order_from_date').val();
                var order_to_date = $('#order_to_date').val();            
                var vendor_id = $('#ord_vendor_id').val();
                var po_status = $('#completed').val();

        window.open($('#liveSite').val()+'index.php?r=reports/PrintPurchaseOrderReportPDF&order_from_date='+order_from_date+'&order_to_date='+order_to_date+'&vendor_id='+vendor_id+'&completed='+po_status, '_blank');

    }", CClientScript::POS_HEAD);

    $cs->registerScript("excelPurchaseOrderList", "function excelPurchaseOrderList(){
      var url= '" . Yii::app()->createUrl('reports/PrintPurchaseOrderExcel') . "';

                var order_from_date = $('#order_from_date').val();
                var order_to_date = $('#order_to_date').val();            
                var vendor_id = $('#ord_vendor_id').val();
                var po_status = $('#completed').val();

        window.open($('#liveSite').val()+'index.php?r=reports/PrintPurchaseOrderExcel&order_from_date='+order_from_date+'&order_to_date='+order_to_date+'&vendor_id='+vendor_id+'&po_status='+po_status, '_blank');

    }", CClientScript::POS_HEAD);