    <div id="div_master_report_customerlist">
        <?php
            $fin_month = Yii::app()->user->fin_year; 
            $year = date('Y');
            $year_next = $year + 1;
            if($fin_month == 1){
                $from_date = $year.'-01-01';
                $end_date = $year.'-12-31';
            }else{
                $from_date = $year.'-04-01';
                $end_date = $year_next.'-03-31';
            }
            $startDate = date("d-m-Y", strtotime($from_date));		 
            $endDate = date("d-m-Y", strtotime($end_date));
	?>
                    <ul class="clearfix form-ul material" id="customerlist-form-hide"> 
                        <li class="col-sm-4">
                            <div class="material">    
                            <?php echo CHtml::textField('ordtodel_customer_name','',array('class' => 'tooltipster', 'title' => 'Please choose a customer','placeholder' => 'Please choose a customer','data-label'=>'Customer','onKeyup' => 'js:autoCompleteCustomer(this.id,"ordtodel");')); ?>
                            <?php echo CHtml::hiddenField('ordtodel_customer_id'); ?>
                            
                            </div>
                        </li>
                        <li class="col-sm-2">
                            <div class="material">    
                                <?php echo CHtml::dropDownList('ordtodel_country', '',MasCountry::getCountry(), array('class' => 'tooltipster','data-label'=>'Country','data-search'=>true,'empty'=>'Select'));?>
                            </div>
                        </li>
                        
                        <li class="col-sm-3">
                            <div class="material">    
                                <?php echo CHtml::textField('ordtodel_from_date', $startDate,array('class' => 'datepicker','data-label'=>'From Date '));?>
                            </div>                            
                        </li>
                        <li class="col-sm-3">
                            <div class="material">    
                                <?php echo CHtml::textField('ordtodel_to_date', $endDate,array('class' => 'datepicker','data-label'=>'To Date '));?>
                            </div>                            
                        </li>
                        <li class="col-sm-3">
                            <div class="material">    
                                <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_view_all"])){
                                echo CHtml::dropDownList('ordtodel_leadowner_id', '',User::getLeadOwners(), array('class' => 'tooltipster','data-label'=>'Lead Owner','empty'=>'Select'));
                                }else{
                                    
                                echo CHtml::dropDownList('ordtodel_leadowner_id', '',User::getLeadOwners(Yii::app()->user->id), array('class' => 'tooltipster','data-label'=>'Lead Owner'));
                                }
?>
                            </div>
                        </li>
                        <li class="col-sm-3">
                            <div class="material">    
                                <?php echo CHtml::dropDownList('ordtodel_type', '', array('1'=>'Summary','2'=>'Detailed Report'), array('class' => 'tooltipster','data-label'=>'Choose Type of Report'));?>
                            </div>
                        </li>
                        
                    </ul>
        </div>
        <div class='btn-wrap text-center'>
            <button type="button" class="btn btn-theme" onclick="loadMasterReport();return false;" title="HTML"><i class="fa fa-file-text"></i> &nbsp;HTML</button>
            <button type="button" class="btn btn-theme" onclick="printOrdersToBeDeliveredPDF();" title="Print Lead List"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>
            <button type="button" class="btn btn-theme" onclick="loadExcel();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>
        </div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm)

		{
                 $('#ordtodel_customer_id').val('');
		var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "'+'&frm='+frm;

		$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

			    var customer_id=ui.item.value; 	
                $('#ordtodel_customer_id').val(customer_id);
             

			}

			})



		}", CClientScript::POS_HEAD); 
    
$cs->registerScript("loadExcel", "function loadExcel() {
  var customer_id   = $('#ordtodel_customer_id').val();
  var country       = $('#ordtodel_country').val();
  var leadowner_id  = $('#ordtodel_leadowner_id').val();
  var from_date     = $('#ordtodel_from_date').val();
  var to_date       = $('#ordtodel_to_date').val();
  var type          = $('#ordtodel_type').val();
  var parms         = 'reports/PrintOrdersToBeDeliveredExecel&customer_id=' + customer_id + '&country=' + country;
  parms             = parms + '&leadowner_id=' + leadowner_id + '&from_date=' + from_date + '&to_date=' + to_date + '&type=' + type;
   
  window.open($('#liveSite').val() + 'index.php?r=' + parms, '_blank');
} ", CClientScript::POS_HEAD);

$cs->registerScript("printOrdersToBeDeliveredPDF", "function printOrdersToBeDeliveredPDF() {
  var customer_id   = $('#ordtodel_customer_id').val();
  var country       = $('#ordtodel_country').val();
  var leadowner_id  = $('#ordtodel_leadowner_id').val();
  var from_date     = $('#ordtodel_from_date').val();
  var to_date       = $('#ordtodel_to_date').val();
  var type          = $('#ordtodel_type').val();
  var parms         = 'reports/PrintOrdersToBeDeliveredPDF&customer_id=' + customer_id + '&country=' + country;
  parms             = parms + '&leadowner_id=' + leadowner_id + '&from_date=' + from_date + '&to_date=' + to_date + '&type=' + type;
   
  window.open($('#liveSite').val() + 'index.php?r=' + parms, '_blank');
} ", CClientScript::POS_HEAD);