<div id="div_master_report_leadlist">
    <?php
    $fin_month = Yii::app()->user->fin_year;

    $from_date = date('Y') . '-01-01';
    $end_date = date('Y') . "-" . date('m') . "-" . date('d');
    $startDate = date("d-m-Y", strtotime($from_date));

    $endDate = date("d-m-Y", strtotime($end_date));
    ?>
    <ul class="clearfix form-ul material" id="leadlist-form-hide">

        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::textField('receipt_from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'Start Date')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::textField('receipt_to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'End Date')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::dropDownList('customer_id', 'customer_id', Customer::getCustomers(), array('class' => 'tooltipster', 'data-label' => 'Customer', 'data-search' => 'true', 'empty' => 'Select', 'onchange' => 'getCustomerShippingDetails(this.value);')); ?>
                <?php /* echo CHtml::hiddenField('qtn_customer_id'); */ ?>

            </div>
        </li>


        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('goodreceipt_id', '', array('class' => 'tooltipster', 'data-label' => 'Receipt#')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["show_warehouse_all"])) {
                    echo CHtml::dropDownList('warehouse_id', '', MasInventoryWarehouse::getWarehouse(), array('class' => 'tooltipster', 'data-label' => 'Branch', 'data-search' => 'true', 'empty' => 'Select'));
                } else {

                    echo CHtml::dropDownList('warehouse_id',  '', MasInventoryWarehouse::getUserWarehousees(), array('class' => 'tooltipster', 'data-label' => 'Branch', 'data-search' => 'true'));
                }
                ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php 
                   

                echo CHtml::dropDownList('type_id', '', array("1" => "Main List", "2" => "Item wise List", "3" => "Item wise Detailed Report"), array('class' => 'tooltipster', 'data-label' => 'Type','onChange'=>"outputValue(this)")); ?>
                <?php /* echo CHtml::hiddenField('qtn_customer_id'); */ ?>

            </div>
        </li>

        <li class="col-sm-3" id="sortbutton" style="display: none">

            <div class="material">
                <?php echo CHtml::dropDownList('sort_id', '', array("receipt_id" => "Receipt #", "receipt_date" => "Receipt Date", "product" => "Product"), array('class' => 'tooltipstersort_button', 'data-label' => 'Sort By')); ?>

            </div>
        </li>

    </ul>
</div>
<div class='btn-wrap text-center'>
    <input type="button" value="Load" onclick="loadMasterReport();return false;" class='plan-save-btn btn btn-theme'>
</div>

<script>
  function outputValue(type){
       $("#sortbutton").hide();
      if(type.value == '3'){
            $("#sortbutton").show();
      }
}
</script>


<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getCustomerShippingDetails", "
    function getCustomerShippingDetails(customer_id){ 
                jQuery.ajax({ 
                    'data' :{'customer_id':customer_id}, 
                    'dataType' : 'json', 
                    'type':'post', 
                    'url': '" . Yii::app()->createUrl('reports/GetCustomerShippingDetails') . "',
                    'success': function(data) { 
                        $('#div_shipping_details').html(data.shipping); 
                        //$('#Order_exchange_rate').addClass('filled'); 
                    } 
                });
                
    }", CClientScript::POS_HEAD);
