<?php
$condition = "1=1";

if ($vehicle_id > 0) {
    $condition .= " AND t.vehicle_id=".(int)$vehicle_id;
}
if ($employee_id > 0) {
    $condition .= " AND t.employee_id=".(int)$employee_id;
}
if (!empty($from_date)) {
    $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
    $condition .= " AND DATE(from_date) >= '" . $from_date . "'";
}
if (!empty($to_date)) {
    $to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
    $condition .= " AND DATE(to_date) <= '" . $to_date . "'";
}

$modelVehicleAllotment = VehicleAllotment::model()
    ->with('vehicle','employee')
    ->findAll(array(
        'condition' => $condition,
        'order' => 't.from_date ASC'
    ));
    //  echo $condition;
?>

<html>
<head>
    <title>Vehicle Allotment Report</title>
    <style>
            table, th, td {
                border: 1px solid black;
                border-collapse: collapse;
            }
             td {
                padding: 5px;
                text-align: left;
            }
            th {
            text-align: center;
        }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        </style>
</head>
<body>
    <table style="width:100%">
        <thead>
            <tr>
                <th colspan="5">Vehicle Allotment Report</th>
            </tr>
            <?php if ($from_date != '') { ?>
            <tr>
                <td colspan="2"><b>From :</b></td>
                <td colspan="3"><?php echo date("d/m/Y", strtotime($from_date)); ?></td>
            </tr>
            <?php } ?>
            <?php if ($to_date != '') { ?>
            <tr>
                <td colspan="2"><b>To :</b></td>
                <td colspan="3"><?php echo date("d/m/Y", strtotime($to_date)); ?></td>
            </tr>
            <?php } ?>
            <?php if ($vehicle_id) {
                $vehicle = MasVehicle::model()->findByPk($vehicle_id);
                if ($vehicle) { ?>
                <tr>
                    <td colspan="2"><b>Vehicle :</b></td>
                    <td colspan="3"><?php echo $vehicle->vehicle_make . ' ' . $vehicle->vehicle_model; ?></td>
                </tr>
            <?php } } ?>
            <?php if ($employee_id) {
                $emp = Employee::model()->findByPk($employee_id);
                if ($emp) { ?>
                <tr>
                    <td colspan="2"><b>Employee :</b></td>
                    <td colspan="3"><?php echo $emp->employeefullname; ?></td>
                </tr>
            <?php } } ?>
        </thead>

        <thead>
            <tr>
                <th style="width:5%;">No</th>
                <th style="width:20%;">Employee</th>
                <th style="width:25%;">Vehicle</th>
                <th style="width:25%;">From Date</th>
                <th style="width:25%;">To Date</th>
            </tr>
        </thead>

        <tbody>
            <?php
            $count = 1;
            if (!empty($modelVehicleAllotment)) {
                foreach ($modelVehicleAllotment as $eachItem) { ?>
                    <tr>
                        <td><?php echo $count++; ?></td>
                        <td><?php echo $eachItem->employee ? CHtml::encode($eachItem->employee->employeefullname) : '--'; ?></td>
                        <td><?php echo $eachItem->vehicle ? $eachItem->vehicle->vehicle_make . ' ' . $eachItem->vehicle->vehicle_model : '--'; ?></td>
                        <td><?php echo ($eachItem['from_date']!="0000-00-00 00:00:00") ? date('d/m/Y h:i A', strtotime($eachItem['from_date'])) : ""; ?></td>
                        <td><?php echo ($eachItem['to_date']!="0000-00-00 00:00:00") ? date('d/m/Y h:i A', strtotime($eachItem['to_date'])) : ""; ?></td>
                    </tr>
            <?php }
            } else { ?>
                <tr>
                    <td colspan="5" class="text-center"><b>No Allotment Records Found</b></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</body>
</html>
