
<html>
<head>
    <title>Lead List</title>
    <style>
        table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
        }
        th, td {
            padding: 5px;
        }
    </style>
</head>

<body>

<table style="width:100%">
    <thead>
        <tr>
            <th colspan="13" style="text-align:center;">
                <?php
                    $modelCompany = MasCompany::model()->find();
                    echo $modelCompany->company_name;
                ?>
            </th>
        </tr>


        <tr>
            <th colspan="13" style="text-align:center;">LEAD LIST</th>
        </tr>

        <tr></tr>

        <?php if($enq_from_date !=''){ ?>
        <tr>
            <td colspan="2"><b>From Date</b></td>
            <td colspan="2"><?php echo date('Y-m-d', strtotime($enq_from_date)); ?></td>
        </tr>
        <?php } ?>

        <?php if($enq_to_date !=''){ ?>
        <tr>
            <td colspan="2"><b>To Date</b></td>
            <td colspan="2"><?php echo date('Y-m-d', strtotime($enq_to_date)); ?></td>
        </tr>
        <?php } ?>

        <?php if($closing_from_date !=''){ ?>
        <tr>
            <td colspan="2"><b>Closing From</b></td>
            <td colspan="2"><?php echo date('Y-m-d', strtotime($closing_from_date)); ?></td>
        </tr>
        <?php } ?>

        <?php if($closing_to_date !=''){ ?>
        <tr>
            <td colspan="2"><b>Closing To</b></td>
            <td colspan="2"><?php echo date('Y-m-d', strtotime($closing_to_date)); ?></td>
        </tr>
        <?php } ?>

        <?php if($sales_group_id !=''){ ?>
        <tr>
            <td colspan="2"><b>Sales Group</b></td>
            <td colspan="2">
                <?php $s = MasSalesGroup::model()->findByPK($sales_group_id);
                      echo $s->group_name;?>
            </td>
        </tr>
        <?php } ?>

        <?php if($customer_id !=''){ ?>
        <tr>
            <td colspan="2"><b>Customer</b></td>
            <td colspan="2">
                <?php echo Customer::model()->findByPk($customer_id)->customer_name; ?>
            </td>
        </tr>
        <?php } ?>

        <?php if($leadowner_id !=''){ ?>
        <tr>
            <td colspan="2"><b>Lead Owner</b></td>
            <td colspan="2">
                <?php 
                    $l = User::model()->findByPK($leadowner_id);
                    echo $l->first_name." ".$l->last_name;
                ?>
            </td>
        </tr>
        <?php } ?>

        <?php if($status !=''){ ?>
        <tr>
            <td colspan="2"><b>Status</b></td>
            <td colspan="2">
                <?php 
                    $status_name='';
                    if($status =='O') $status_name='Open';
                    if($status =='N') $status_name='Not reachable';
                    if($status =='F') $status_name='FollowUp Calls';
                    if($status =='S') $status_name='Send Profile';
                    if($status =='M') $status_name='Meet in Person';
                    if($status =='C') $status_name='Closed';
                    if($status =='OT') $status_name='Others';
                    if($status =='L') $status_name='Lost';
                    echo $status_name;
                ?>
            </td>
        </tr>
        <?php } ?>

        <?php if($source_of_lead !=''){ ?>
        <tr>
            <td colspan="2"><b>Source of Lead</b></td>
            <td colspan="2"><?php echo MasSourceOfLead::getSourceOfLeadName($source_of_lead); ?></td>
        </tr>
        <?php } ?>

        <?php if($lead_type !=''){ ?>
        <tr>
            <td colspan="2"><b>Type</b></td>
            <td colspan="2"><?php echo ($lead_type=='sale')?'Sales':'Service'; ?></td>
        </tr>
        <?php } ?>

    </thead>

    <tr></tr>

    <thead>
        <tr>
            <th>No</th>
            <th>Lead #</th>
            <th>File #</th>
            <th>Customer Name</th>
            <th>Lead Owner</th>
            <th>Enquiry Date</th>
            <th>Closing Date</th>
            <th>Sales Group</th>
            <th>Status</th>
            <th>Source of Lead</th>
            <!-- <th>Currency</th>
            <th>Value</th>
            <th>Value (BC)</th> -->
        </tr>
    </thead>

    <tbody>
        <?php
        $condition = '1=1'; 

        if ($enq_from_date != '') {
        $enq_from_date = str_replace('/', '-', $enq_from_date);
        $enq_from_date = date('Y-m-d', strtotime($enq_from_date));
        $condition .= ' AND t.enq_date >="' . $enq_from_date . '"';
        }
        if($enq_to_date != ''){
        $enq_to_date = str_replace('/', '-', $enq_to_date);
        $enq_to_date = date('Y-m-d',strtotime($enq_to_date));
        $condition .= ' AND t.enq_date <="'.$enq_to_date.'"';
        }
        if($closing_from_date != ''){
            $closing_from_date = date('Y-m-d', strtotime($closing_from_date));
            $condition .= ' AND closing_date >="' . $closing_from_date.'"';
        }
        if($closing_to_date != ''){
            $closing_to_date = date('Y-m-d', strtotime($closing_to_date));
            $condition .= ' AND closing_date <="' . $closing_to_date.'"';
        }
        if($customer_id != ''){
            $condition .= ' AND customer_id ="' . $customer_id.'"';
        }
        if($sales_group_id != ''){
            $condition .= ' AND sales_group_id ="' . $sales_group_id.'"';
        }
        if($leadowner_id != ''){
            $condition .= ' AND lead_owner_id ="' . $leadowner_id.'"';
        }
        if($status != ''){
            $condition .= ' AND status ="' . $status.'"';
        }
        if($source_of_lead != ''){
            $condition .= ' AND source_of_lead ="' . $source_of_lead.'"';
        }
        if($lead_type != ''){
            $condition .= ' AND lead_type ="' . $lead_type.'"';
        }

        $total = 0;
        $total_value = 0;

        $model_lead = Lead::model()->with('leadowner')->findAll(array('condition'=>$condition));

        foreach ($model_lead as $i => $model) {
            $model_currency = MasCurrency::model()->findByPk($model->currency);
            $total_bc = $model->value * $model_currency->exchange_rate;
            $total += $total_bc;
            $total_value += $model->value;
        ?>
        <tr>
            <td><?php echo $i+1;?></td>
            <td><?php echo $model->id; ?></td>
            <td><?php echo $model->file_id; ?></td>
            <td><?php echo $model->customer->customer_name;?></td>
            <td><?php echo $model->leadowner->first_name." ".$model->leadowner->last_name;?></td>

            <td><?php echo ($model->enq_date!='0000-00-00')?date("d/m/Y", strtotime($model->enq_date)):""; ?></td>
            <td><?php echo ($model->closing_date!='0000-00-00')?date("d/m/Y", strtotime($model->closing_date)):""; ?></td>

            <td><?php echo $model->salesgroup->group_name;?></td>

            <td>
                <?php
                if($model->status == 'O') echo "Open";
                if($model->status == 'N') echo "Not reachable";
                if($model->status == 'F') echo "FollowUp Calls";
                if($model->status == 'S') echo "Send Profile";
                if($model->status == 'M') echo "Meet in Person";
                if($model->status == 'C') echo "Closed";
                if($model->status == 'OT') echo "Others";
                if($model->status == 'L') echo "Lost";
                ?>
            </td>

            <td><?php echo $model->sourceoflead->source_of_lead;?></td>

        </tr>
        <?php } ?>

    </tbody>
</table>

</body>
</html>
