<?php
$cs = Yii::app()->getClientScript();
$goods_receipt_date = date("d/m/Y");
$con = "";
if ($model->id > 0) {
    $goods_receipt_date = date("d/m/Y", strtotime($model->goods_receipt_date));
    $con = "'readonly'";
}
$crm_login_company_id = Yii::app()->user->master_user_company_id;
$privillage_modal = new MasCompanySettings();
$privillage_condition = 'crm_company_id=' . $crm_login_company_id;

?>

<ul class="clearfix form-ul material">
    <?php echo $form->hiddenField($model, 'id'); ?>
    <?php echo $form->hiddenField($model, 'customer_id'); ?>
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'goods_receipt_date', array('class' => 'datepicker', 'value' => $goods_receipt_date, 'data-label' => 'Goods Receipt Date <span style="color:red;">*<span> ')); ?>
    </li>
    <li class="col-sm-2">
        <?php

        if ($frm == 'PRO') {

            $model->receipt_type = 'PR';

            $modelMasInventoryStockAdjustmentType = new MasInventoryStockAdjustmentType;

            echo $form->dropDownList($model, 'receipt_type', $modelMasInventoryStockAdjustmentType->getInventoryStockAdjustmentType_code_issue(), array('data-label' => 'Receipt Type', 'disabled' => true));

            echo $form->hiddenField($model, 'receipt_type');

        } else {

            $modelMasInventoryStockAdjustmentType = new MasInventoryStockAdjustmentType;

            echo $form->dropDownList($model, 'receipt_type', $modelMasInventoryStockAdjustmentType->getInventoryStockAdjustmentType_code_issue(), array('data-label' => 'Receipt Type'));

        }

        ?>

    </li>
    <li class="col-sm-2" id="customer_div">
        <?php echo $form->textField($model, 'customer_name', array('class' => 'tooltipster', 'value' => $model->customer->customer_name, 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"issue");')); ?>
        <?php echo $form->error($model, 'customer_name'); ?>

    </li>
    <?php if ($frm == 'PR') {
        ?>
        <li class="col-sm-2">
            <?php
            echo $form->textField($model, 'reference_id', array('class' => 'tooltipster', 'data-label' => 'PO#  ', 'onKeyup' => 'js:autoCompleteOrderId(this.id,"gi");'));
            ?>
        </li>
        <li class="col-sm-2">
            <?php echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'data-label' => 'Reference ')); ?>
        </li>
        <?php
    } else {
        ?>
        <li class="col-sm-2" id="ref_ids">
            <?php
            echo $form->textField($model, 'reference_id', array('class' => 'tooltipster', 'data-label' => 'Prd. Ord#', 'onKeyup' => 'js:autoCompleteOrderId(this.id,"gi");'));
            ?>
        </li>
        <li class="col-sm-2">
            <?php
            echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'data-label' => 'Reference  '));
            // echo $form->hiddenField($model, 'reference_id');
            ?>
        </li>
        <?php
    }
    ?>

    <?php if ((int) Yii::app()->user->haveLevelPermissionOn['master_level_permission_warehouses'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
        <li class="col-sm-2">
            <?php
            if (empty($model->warehouse_id)) {
                $model->warehouse_id = MasInventoryWarehouse::base_warehouse_id();
            }
            ?>
            <?php echo $form->dropDownList($model, 'warehouse_id', MasInventoryWarehouse::getWarehouses(), array('data-label' => 'Warehouse <span style="color:red;">*<span>', 'empty' => '-Select-')); ?>
        </li>
    <?php } else {
        $model->warehouse_id = MasInventoryWarehouse::base_warehouse_id();
        echo $form->hiddenField($model, 'warehouse_id');
    }
    ?>



    <?php if (isset(Yii::app()->user->fm_module) && Yii::app()->user->fm_module == 'Y') { ?>

        <li class="col-sm-2">
            <?php
            $modelTicketHeader = new TicketHeader();
            echo $form->dropDownList($model, 'ticket_id', $modelTicketHeader->GetJoblist(), array('class' => '', 'prompt' => '--Select--', 'title' => 'Select Job', 'data-label' => 'Job Order No')); ?>
        </li>
    <?php } ?>


    <?php if (isset(Yii::app()->user->project_module) && Yii::app()->user->project_module == 'Y') { ?>
        <li class="col-sm-2">
            <?php

            $modelProject = new WsProject;
            echo $form->dropDownList($model, 'project_id', array(), array('class' => '', 'data-label' => 'Project ', 'empty' => '-Select-'));

            ?>
        </li>
    <?php } ?>



</ul>
<?php
$cs = Yii::app()->getClientScript();



$cs->registerScript("autoCompleteOrderId", "function autoCompleteOrderId(field_id,frm)

    {

        var url = '" . Yii::app()->createUrl('assembly/production/GetProductionOrders') . "'+'&frm='+frm;

        $('#'+field_id).autocomplete({



            minLength   : 1,



            source      : function (request, response) { autoCompleteSource(request, response,url) },

            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

            select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

                var order_id=ui.item.value; 	

                $('#InventoryGoodsReceipt_reference').addClass('filled');
                        
                $('#InventoryGoodsReceipt_customer_name').addClass('filled');

                $('#InventoryGoodsReceipt_reference_id').val(order_id);
                
                var warehouse_id = $('#InventoryGoodsIssue_warehouse_id').val();

                jQuery.ajax({

                    'type': 'POST',

                    'dataType': 'json',

                    'url': '" . Yii::app()->createUrl('assembly/production/GetPODetailsForGoodsReceipt') . "',

                    'data': {'order_id': order_id,'warehouse_id':warehouse_id},

                    'cache': false,

                    'beforeSend': function() {

                        

                    },

                    'success': function(data) {


                        $('#InventoryGoodsReceipt_customer_id').val(data.customer_id);
                        $('#InventoryGoodsReceipt_customer_name').val(data.customer_name);
                        
                        


                        $('#InventoryGoodsReceipt_reference').val(data.reference);


                        if(data.model_items!='')

                        $('#tbody_goods_receipt_item').html(data.model_items);

                        //calculateValues($('#tbl_gr_item'));

                    },

                }); 

                

            }

        })

    }", CClientScript::POS_HEAD);
?>
<script>

    $(document).ready(function () {

        // When Issue Type changes
        $('#InventoryGoodsReceipt_receipt_type').change(function () {

            let issueType = $(this).val();

            if (issueType === 'PR') {

                $.ajax({
                    url: '<?php echo Yii::app()->createUrl("receipts/listPOCustomers"); ?>',
                    type: 'POST',
                    dataType: 'json',
                    success: function (res) {

                        // Replace input with dropdown
                        $('#customer_div').html(res.customerDropDown);

                        // Bind change event AFTER element exists
                        $(document).on('change', '#InventoryGoodsReceipt_customer_id', function () {
                            let customerId = $(this).val();
                            loadPRList(customerId);
                        });
                    }
                });

            } else {

                // Restore original autocomplete customer input
                $('#customer_div').html(
                    '<div class="material-input input">' +
                    '<input class="tooltipster material-done ui-autocomplete-input filled" ' +
                    'data-label="Customer" ' +
                    'onkeyup="js:autoCompleteCustomer(this.id, \'issue\');" ' +
                    'onselect="selectPO()" ' +
                    'name="InventoryGoodsReceipt[customer_name]" ' +
                    'id="InventoryGoodsReceipt_customer_name" ' +
                    'type="text" autocomplete="off">' +
                    '<span class="material-bar"></span>' +
                    '<label for="InventoryGoodsReceipt_customer_name">Customer</label>' +
                    '</div>'
                );

                // Reset PR dropdown
                $('#ref_ids').html(
                    '<div class="material-input input">' +
                    '<input class="tooltipster material-done" ' +
                    'data-label="Reference &lt;span style=&quot;color:red;&quot;&gt;*&lt;span&gt; " ' +
                    'name="InventoryGoodsReceipt[reference]" ' +
                    'id="InventoryGoodsReceipt_reference_id" ' +
                    'type="text" maxlength="255">' +
                    '<span class="material-bar"></span>' +
                    '<label for="InventoryGoodsReceipt_reference_id">' +
                    'Prd. Ord# <span style="color:red;">*<span> </span>' +
                    '</label>' +
                    '</div>'
                );

                let emptyRow = `
                    <tr>
                        <td>1</td>

                        <!-- PRODUCT NAME + HIDDEN PRODUCT ID + ITEM ID -->
                        <td>
                            <input type="text" name="InventoryGoodsReceiptItem[0][product_name]" class="go" readonly>
                            <input type="hidden" name="InventoryGoodsReceiptItem[0][product_id]" value="">
                            <input type="hidden" name="InventoryGoodsReceiptItem[0][id]" value="">
                        </td>

                        <!-- DESCRIPTION -->
                        <td>
                            <textarea name="InventoryGoodsReceiptItem[0][description]" class="go" readonly></textarea>
                        </td>

                        <!-- FREE QTY -->
                        <td>
                            <input type="text" name="InventoryGoodsReceiptItem[0][free_qty]" class="go text-right" readonly>
                        </td>

                        <!-- PICKED QTY -->
                        <td>
                            <input type="text" name="InventoryGoodsReceiptItem[0][picked_qty]" 
                                class="go text-right qty" onkeypress="return isNumberKey(event)">
                        </td>

                        <!-- UNIT DROPDOWN -->
                        <td>
                            <select name="InventoryGoodsReceiptItem[0][unit]" class="go">
                                <option value="">Select</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" name="InventoryGoodsReceiptItem[0][rate]" 
                                class="go text-right qty" onkeypress="return isNumberKey(event)">
                        </td>
                        <!-- REMOVE BUTTON -->
                        <td class="text-center">
                            <a class="btn btn-sm btn-danger" href="javascript:void(0);" 
                            onclick="removeTableRow($('#details_table'), this, this.id)">
                                <i class="fa fa-times"></i>
                            </a>
                        </td>
                    </tr>`;


                // Replace old rows with empty row
                $('#tbody_goods_receipt_item').empty().append(emptyRow);

            }
        });

    });

    // Load PR numbers for selected customer
    function loadPRList(customerId) {

        if (!customerId) {
            $('#InventoryGoodsReceipt_reference_id')
                .html("<option value=''>Select Reference</option>");
            return;
        }

        $.ajax({
            url: '<?php echo Yii::app()->createUrl("receipts/getPurchaseOrderIds"); ?>',
            type: 'POST',
            data: { customer_id: customerId },
            dataType: 'json',
            success: function (res) {
                $('#ref_ids').html(res.drop);
            }
        });
    }
    $(document).on('change', '#InventoryGoodsReceipt_reference_id', function () {
        console.log('hii'); // test
        var issue_type = $('#InventoryGoodsReceipt_receipt_type').val();
        var productionOrderId = $(this).val();
        if (productionOrderId && issue_type == 'PR') {
            loadProductionOrderItems(productionOrderId);
        } 
    });

    function loadProductionOrderItems(productionOrderId, frm) {
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("receipts/getProductionOrderItems"); ?>',
            type: 'POST',
            data: { production_order_id: productionOrderId, frm: frm },
            dataType: 'json',
            success: function (res) {
                if (res.status == 'success') {
                    $('#div_receipt_table').html(res.tbl);
                } else {
                    $('#tbody_goods_receipt_item').html('<tr><td colspan="9" class="text-center">No items found</td></tr>');
                }
            }
        });
    }


</script>