<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerCssFile($baseUrl . '/css/jquery.contextMenu.min.css');
$cs->registerScriptFile($baseUrl . '/js/jquery.contextMenu.min.js', CClientScript::POS_END);
$cs->registerScriptFile($baseUrl . '/js/jquery.ui.position.min.js', CClientScript::POS_END);
?>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        Delivery Tracker
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_order_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Purchase Order</th>
                        <th>Vendor</th>
                        <th>Item</th>
                        <th>Description</th>
                        <th>Qty</th>
                        <th>Unit</th>
                        <th>Delivery Date</th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="color-indicator">
            <span style="display:inline-block;width:30px;height:30px;background:rgb(252, 212, 212); box-shadow: 0px 2px 10px 2px #b7b5b5"></span>
            <span class="verti">Overdue</span>
        </div>
    </div>
</section>
<script>
$(document).ready(function() {
    var table = $("#tbl_order_details").DataTable({
        scrollY: "645px",
        pageLength: 50,
        ajax: {
            url: "<?php echo Yii::app()->createUrl('Purchasingorder/GetDeliveryList'); ?>",
            type: "POST",
            cache: false
        },
        aaSorting: [[0, "desc"]],
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        rowCallback: function(row, data) {
            if (data[9] == 1) {
                $("td", row).css("background-color", "rgb(252, 212, 212)");
            }
        }
    });

    $.contextMenu({
        selector: "#tbl_order_details tbody tr",
        callback: function(key, options) {
            var data = table.row(this).data();
            var id = data[10];
            var orderId = data[1];
            var stockItem = data[3];
            var fileId = data[11];
            var convertStatus = data[12];

            if (key === "edit") {
                loadPopupModal(
                    "purchasingorder/editdeliverytracker&id=" + id,
                    "Edit Delivery Tracker - " + orderId + "/" + stockItem,
                    "lg"
                );
            } else if (key === "convert" && convertStatus === "Y") {
                loadPopupModal(
                    "materialreceipt/create&order_id=" + orderId + "&file_id=" + fileId,
                    "Convert to Material Receipt - " + fileId,
                    "xl"
                );
            }
        },
        items: {
            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["pur_deliverytrack_edit"])) { ?>
            "edit": { name: "Edit", icon: "edit" },
            <?php } ?>
            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["pur_deliverytrack_convert"])) { ?>
            "convert": { name: "Convert to Material Receipt", icon: "retweet" }
            <?php } ?>

        }
    });
});
</script>

