<?php $cs = Yii::app()->getClientScript(); ?>
<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'lc_inv_form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));
    ?>
    <!--  <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#invoice_tab1" data-toggle="tab">General</a></li>
  </ul>-->

    <div class="tab-content">
        <?php echo $form->hiddenField($model, 'id'); ?>

        <div id="land-table">
            <?php
            if ($id > 0) {
                $condition = 'service_invoice_id=' . $id;
                $modelLandingCost = LandingCost::model()->findAll(array('condition' => $condition, 'order' => 'parent_invoice_id'));

                $total = 0;
                $pre = 0;
                $tot = 0;
                $percent = 0;
                $tot_val = 0;

                if (!empty($modelLandingCost)) {
            ?>
                    <table class="table table-fixed table-bordered table-primary dataTable">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th style="text-align:right">Qty</th>
                                <th style="text-align:right">Rate</th>
                                <th style="text-align:right">Amount</th>
                                <th>Currency</th>
                                <th style="text-align:right">Ex. Rate</th>
                                <th style="text-align:right">Percent(%)</th>
                                <th style="text-align:right">Value(<?php echo  MasCurrency::base_currency_code(); ?>/Item)</th>
                                <th style="text-align:right">Amount(<?php echo  MasCurrency::base_currency_code(); ?>)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($modelLandingCost as $eachModel) {
                                // If the parent_invoice_id changes, print the new invoice header
                                if ($pre != $eachModel->parent_invoice_id) {
                            ?>
                                    <tr style="background-color:#dcffd8;">

                                        <td>Purchase Invoice No: <?php echo $eachModel->purchase_invoice->id; ?></td>
                                        <td>Vendor: <?php echo $eachModel->purchase_invoice->vendor_details->vendor_name; ?></td>
                                        <td></td>
                                        <td>Grand Total: <?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->purchase_invoice->grand_total, ""); ?></td>
                                        <td>Currency: <?php echo $eachModel->purchase_invoice->currencyname->currency_code; ?></td>
                                        <td>Ex. Rate: <?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->purchase_invoice->exchange_rate, ""); ?></td>
                                        <td></td>
                                        <td></td>
                                        <td>Grand Total (<?php echo  MasCurrency::base_currency_code(); ?>): <?php echo Yii::app()->numberFormatter->formatCurrency(($eachModel->purchase_invoice->grand_total * $eachModel->purchase_invoice->exchange_rate), ""); ?></td>

                                    </tr>
                                <?php
                                    $tot += ($eachModel->purchase_invoice->grand_total * $eachModel->purchase_invoice->exchange_rate);
                                }
                                ?>
                                <tr>
                                    <td><?php echo $eachModel->product->part_number; ?></td>
                                    <td style="text-align:right"><?php echo $eachModel->quantity; ?></td>
                                    <td style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->rate, ""); ?></td>
                                    <td style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->amount, ""); ?></td>
                                    <td><?php echo $eachModel->currencyname->currency_code; ?></td>
                                    <td style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->exchange_rate, ""); ?></td>
                                    <td style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->service_amount_percentage, ""); ?>%</td>
                                    <td style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($eachModel->service_invoice_value, ""); ?></td>
                                    <td style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency(($eachModel->quantity * $eachModel->service_invoice_value), ""); ?></td>
                                </tr>
                            <?php
                                $pre = $eachModel->parent_invoice_id;
                                $percent += $eachModel->service_amount_percentage;
                                $tot_val += $eachModel->quantity * $eachModel->service_invoice_value;
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th style="text-align:right" colspan="6">Total (<?php echo  MasCurrency::base_currency_code(); ?>)</th>
                                <th style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($percent, ""); ?>%</th>
                                <th></th>
                                <th style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($tot_val, ""); ?></th>
                            </tr>
                            <tr>
                                <th style="text-align:right" colspan="8">Total Invoice Amount (<?php echo  MasCurrency::base_currency_code(); ?>)</th>
                                <th style="text-align:right"><?php echo Yii::app()->numberFormatter->formatCurrency($tot, ""); ?></th>
                            </tr>
                        </tfoot>
                    </table>
            <?php
                }
            }
            ?>
        </div>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="pur_inv_close" data-dismiss="modal">Close</button>
        <?php

        $url = Yii::app()->createUrl('purchaseinvoice/CalculateLcPurchaseInvoice');

        echo CHtml::ajaxSubmitButton('Calculate LC', $url, array(

            'dataType' => 'json',

            'type' => 'post',

            'success' => 'function(data) {
                                 $("#loader").hide();
                                    if(data.status=="success"){
                                        $("#pur_inv_close").click();
                                        t8.success("Calculate LC!","success");
                                        reloadTable("#tble_invoice");
                                      //  location.href="index.php?r=purchaseinvoice/index";

                                    } else {
                                      $("#loader").hide();
                                         $.each(data, function(key, val) {
                                            $("#lc_inv_form .lc-inv-save-btn").prop("disabled", false);
                                            $("#lc_inv_form .lc-inv-save-btn").addClass("btn-theme").removeClass("btn_loading");
                                                $("#lc_inv_form #"+key+"_em_").text(val).show();
                                                t8.error(""+val+"");
                                            });
                                      }
                                    }',

            'beforeSend' => 'function(){
                                $(".toast8-error").hide();
                                $("#loader").show();
                                $("#lc_inv_form .lc-inv-save-btn").prop("disabled", true);
                                $("#lc_inv_form .lc-inv-save-btn").addClass("btn_loading").removeClass("btn-theme");

                                }',

        ), array('id' => 'save_convert' . rand(), 'class' => 'lc-inv-save-btn btn btn-theme'));

        // }
        ?>

    </div>
    <?php $this->endWidget(); ?>

</div>