<!DOCTYPE html>
<html>
    <head>
         <title>Returned Oil</title>
        <style>
            .table_box {
                border-collapse:separate!important;
                margin-top: 10px;
                padding: 10px;
                font-size:16px!important;
                border: 1px solid #0066ff;
                border-radius:6px;
            }
        </style>
    </head>
    <body >
        <div class="">
            <?php $this->renderPartial("//common/header"); ?>
            <div class="col-4">
                <?php
                $model = InventoryDirectTransfer::model()->findByPk($id);
                $erpsettings = MasCompany::getCurrentUserERPSetting();
                if ($erpsettings == 'E') {
                    $warehouseArray = MasInventoryWarehouse::getWarehouses();
                }
                if ($erpsettings == 'C') {
                    $warehouseArray = MasInventoryWarehouse::getWarehousesCRM();
                }                
                $customer_name = '';
                if ($model->customer_id > 0) {
                    $customer_name = $model->customer->customer_name;
                }
                $outlets = CustomerOutletLocation::getShippingLocation($model->customer_id);
                $leadOwners = User::getUser(); ?>
                <div class="input-block"><b><?php echo $model->id;?></b></div>
                
                 <b><?php echo strtoupper($customer_name); ?></b>
                 
                <!--<small>Customer : <?php //echo $customer_name;?> </small><br>-->
                <!--<small>Outlet : <?php //echo $outlets[$model->outlet_id];?> </small><br>-->
                <!--<small>To Warehouse : <?php //echo $warehouseArray[$model->from_warehouse_id];?> </small><br>-->
            </div>
            <div class="col-4">
                <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 14px;"><?php if ($model->isApproved == 'Y') { echo "RETURNED OIL LIST"; } else { echo "NON RECEIVED OIL LIST"; } ?></div>
            </div>
            <div class="col-4" style="color:#101010;">
                <table class="table" style="width:100%" style="font-size:10px;">
                    <tr>
                        <td>Returned Date Time</td>
                        <td><?php echo date('d/m/Y h:i a',STRTOTIME($model->created_date_time));?></td>
                    </tr>
                    <tr>
                        <td>Returned By</td>
                        <td><?php echo $leadOwners[$model->lead_owner_id];?></td>
                    </tr>
                    <?php if ($model->isApproved == 'Y') { ?>
                        <tr>
                            <td>Received Date Time</td>
                            <td><?php echo date('d/m/Y h:i a',STRTOTIME($model->approved_date_time));?></td>
                        </tr>
                        <tr>
                            <td>Received By</td>
                            <td><?php echo $model->approver->first_name.' '.$model->approver->last_name;?></td>
                        </tr>
                    <?php } ?>
                     <tr>
                            <td>Outlet</td>
                            <td><?php echo $outlets[$model->outlet_id];?></td>
                        </tr>
                         <tr>
                            <td>To Warehouse</td>
                            <td><?php echo $warehouseArray[$model->from_warehouse_id];?></td>
                        </tr>
                </table>
            </div>
        </div><br>
        <div class="col-md-12">
            <table id="" class="table" style="font-size:10px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Item</th>
                        <th>Item Description</th>
                        <th>Transfer Qty</th>
                        <?php if ($model->isApproved == 'Y') { ?>
                            <th>Balance Qty</th>
                            <th>Used Qty</th>
                        <?php } ?>
                        <th>Unit</th>
                    </tr>
                </thead>    
                <tbody>
                    <?php 
                    $m=1;
                    $condition .= '1=1';
                    $condition .= ' AND t.direct_transfer_id ="' . $id.'"';
                    $total=0;
                    $model_items = InventoryDirectTransferItem::model()->findAll(array('condition'=>$condition));
                    foreach ( $model_items as $i =>  $model_items) {
                        $returnedQty = $usedQty = 0;
                        if ($model_items->stock_ledger_id && $model->status == 'C') {
                            $model_items->balance_qty = (float) StockLedger::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'master_stock_ledger_id="' . $model_items->stock_ledger_id . '" AND transaction_type="IN"'))->quantity;
                        }
                        $units = UnitOfMeasurement::getUnits($model_items->item_id); ?>
                        <tr>
                            <td><?php echo $m++;?></td>
                            <td><?php echo $model_items->item_name; ?></td>
                            <td><?php echo $model_items->item_description; ?></td>
                            <td style="text-align: right;"><?php echo number_format(round((float)$model_items->transfer_qty,3),3,'.',''); ?></td>
                            <?php if ($model->isApproved == 'Y') { ?>
                                <td style="text-align: right;"><?php echo round($model_items->balance_qty,3); ?></td>
                                <td style="text-align: right;"><?php echo (float) round(((float) $model_items->transfer_qty - (float) $model_items->balance_qty),3); ?></td>
                            <?php } ?>
                            <td><?php echo $units[$model_items->unit]; ?></td>
                        </tr>                
                        <?php
                    } ?>
                </tbody>
            </table>
        </div><br><br><br><br><br>
        <?php if ($model->isApproved == 'Y') { ?>
            <div class="col-4" style="color:#101010;">
                <?php /*<small>Approved Date Time : <?php echo date('d/m/Y h:i a',STRTOTIME($model->approved_date_time));?> </small><br>*/?>&nbsp;
            </div>
            <div class="col-4" style="color:#101010;">&nbsp;</div>
            <div class="col-4" style="color:#101010;">
                <small>Approved By  : <?php echo $model->approver->first_name.' '.$model->approver->last_name;?> </small><br>
            </div>
        <?php } ?>
        <?php /*<htmlpagefooter name="myfooter">
            <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
                <?php
                date_default_timezone_set("Asia/Dubai");
                echo date('d/m/Y')." ".date("h:i:sa"); ?>
            </div>
            <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
                <div style="text-align:center;width:100%">
                    <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                    <?= Yii::app()->user->footer_line_2 ?>
                </div>
                <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
            </div>
        </htmlpagefooter>*/ ?>
        <?php $this->renderPartial("//common/footer",array('company_id'=>$company_id));?>

    </body>
</html>