<!DOCTYPE html>
<html>
    <head>
         <title>Returned Machine</title>
        <style>
            .table_box {
                border-collapse:separate!important;
                margin-top: 10px;
                padding: 10px;
                font-size:16px!important;
                border: 1px solid #0066ff;
                border-radius:6px;
            }
        </style>
    </head>
    <body >
        <div class="">
            <?php $this->renderPartial("//common/header"); ?>
            <div class="col-4">
                <?php
                $model = InventoryGoodsReceipt::model()->findByPk($id);
                $customer_name = '';
                if ($model->customer_id > 0) {
                    $customer_name = $model->customer->customer_name;
                }
                $outlets = CustomerOutletLocation::getShippingLocation($model->customer_id);
                $leadOwners = User::getUser(); ?>
                <div class="input-block"><b><?php echo $model->id;?></b></div>
                <small>Customer : <?php echo $customer_name;?> </small><br>
                <small>Outlet : <?php echo $outlets[$model->outlet_id];?> </small><br>
            </div>
            <div class="col-4">
                <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 14px;">
                    <?php if ($model->isApproved == 'Y') {
                        echo "RETURNED MACHINE LIST"; 
                    } else { 
                        echo "MACHINE LIST";
                    } ?>
                </div>
                <p style="font-size:12px;">
                    <?php if ($model->isApproved == 'Y') {
                    } else { 
                        echo "(Not yet received at Store, still in Transit)";
                    } ?>
                </p>
            </div>
            <div class="col-4" style="color:#101010;">
                <table class="table" style="width:100%" style="font-size:10px;">
                    <tr>
                        <td>Returned Date Time</td>
                        <td><?php echo date('d/m/Y h:i a',STRTOTIME($model->created_date_time));?></td>
                    </tr>
                    <tr>
                        <td>Returned By</td>
                        <td><?php echo $leadOwners[$model->lead_owner_id];?></td>
                    </tr>
                    <?php if ($model->isApproved == 'Y') { ?>
                        <tr>
                            <td>Received Date Time</td>
                            <td><?php echo date('d/m/Y h:i a',STRTOTIME($model->approved_date_time));?></td>
                        </tr>
                        <tr>
                            <td>Received By</td>
                            <td><?php echo $model->approver->first_name.' '.$model->approver->last_name;?></td>
                        </tr>
                    <?php } ?>
                </table>
            </div>
        </div><br>
        <div class="col-md-12">
            <table id="" class="table" style="font-size:10px;">
                <thead>
                    <tr>
                        <th >#No</th>
                        <th >Serial Number</th>
                        <th >Machine</th>
                        <th >Location</th>
                        <th >Return Remarks</th>
                    </tr>
                </thead>    
                <tbody>
                    <?php 
                    $m=1;
                    $condition .= '1=1';
                    $condition .= ' AND t.goods_receipt_id ="' . $id.'"';
                    $total=0;
                    $model_items = InventoryGoodsReceiptItem::model()->findAll(array('condition'=>$condition));
                    foreach ( $model_items as $i =>  $model_items) { ?>
                        <tr>
                            <td><?php echo $m++;?></td>
                            <td><?php echo $model_items->serial_no;?></td>
                            <td><?php echo $model_items->product_name;?></td>
                            <td><?php echo $model_items->location->location_name;?></td>
                            <td><?php echo $model_items->description;?></td>
                        </tr>                
                        <?php
                    } ?>
                </tbody>
            </table>
        </div><br><br><br><br><br>
        <?php if ($model->isApproved == 'Y') { ?>
            <div class="col-4" style="color:#101010;">
                <?php /*<small>Approved Date Time : <?php echo date('d/m/Y h:i a',STRTOTIME($model->approved_date_time));?> </small>*/?><br>&nbsp;
            </div>
            <div class="col-4" style="color:#101010;">&nbsp;</div>
            <div class="col-4" style="color:#101010;">
                <small>Approved By : <?php echo $model->approver->first_name.' '.$model->approver->last_name;?> </small><br>
            </div>
        <?php } ?>
        <htmlpagefooter name="myfooter">
            <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
                <?php
                date_default_timezone_set("Asia/Dubai");
                echo date('d/m/Y')." ".date("h:i:sa"); ?>
            </div>
            <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
                <div style="text-align:center;width:100%">
                    <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                    <?= Yii::app()->user->footer_line_2 ?>
                </div>
                <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
            </div>
        </htmlpagefooter>
    </body>
</html>