<!DOCTYPE html>
<html>
    <head>
        <title>PROJECT_ESTIMATION_<?php echo $id; ?></title>
        <style>
            .table_box {
                border-collapse:separate!important;
                margin-top: 10px;                      
                padding: 10px;
                font-size:16px!important;
                border: 1px solid #0066ff;
                border-radius:6px;   
            }
            div.page { page-break-after:auto }
        </style> 
    </head>
    <body>
        <div class="">
            <?php $this->renderPartial("//common/header"); ?>
            <div class="col-4">
                <br>
                <?php
                $model = WsProject::model()->findByPk($id);
                ?>
                <div class="input-block"> 
                    <b><?php echo $id; ?></b>
                </div>
                <b><?php echo strtoupper($model->project_name); ?></b><br>
            </div>
            <div class="col-4">
                <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;color: #000000;font-size: 14px;">
                    <?php echo "Project Details"; ?>
                </div>    
            </div>
            <div class="col-4" style="color:#101010;">
                <br>
                <table class="table" style="width:100%" style="font-size:10px;">
                    <tr>
                        <?php
                        ?>
                        <td class="bc-tl">Location</td>
                        <td>
                            <?php echo $model->location; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Project Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($model->project_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>End Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($model->actual_end_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Manager</td>
                        <td>
                            <?php echo $model->employeedetails->de_first_name; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <br>
        <?php
        $modal_estimation_details = WsProjectEstimationDetails::model()->findAll(array('condition' => 'project_id="' . $id . '"'));
       
            ?>
            <h5>BOM Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl">No</th>
                            <th class="text-center" style="width:8%">Phase</th>
                            <th class="text-center" style="width:20%">Category</th>
                            <th class="text-center" style="width:30%">Description</th>
                            <th class="text-center">Brand</th>
                            <th class="text-center">Qty</th>
                            <th class="text-center" style="width:8%">Unit</th>
                           
                            <th class="text-center" style="width:10%">Unit Price</th>
                            <th class="text-center bc-tr" style="width:7%">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $m = 1;
                         if (!empty($modal_estimation_details)) {
                        foreach ($modal_estimation_details as $i => $estimation) {
                            ?>
                            <tr>
                                <td>
                                    <?php echo $m; ?>
                                </td>
                                <td>
                                    <?php echo $estimation->phase_detail->phase_name; ?>
                                </td>
                                <td>
                                    <?php echo $estimation->category_detail->generic_name; ?>
                                </td>
                                <td>
                                    <?php echo $estimation->description; ?>
                                </td>
                                <td>
                                    <?php echo $estimation->brand_detail->brand; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $estimation->quantity; ?>
                                </td>
                                <td>
                                    <?php echo $estimation->unit_detail->unit_name; ?>
                                </td>
                               
                                <td class="text-right">
                                    <?php echo $estimation->unit_price; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $estimation->total_material_cost; ?>
                                </td>
                            </tr>
                            <?php
                            $m = $m + 1;
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="9" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
        <?php
        $m = 1;
        $modelTaskBreakup = WsProjectTaskBreakup::model()->findAll(array('condition' => 'project_id=' . $id));
      
            ?>
            <h5>Admin Task Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center bc-tl">Category</th>
                            <th class="text-center"> Sub Category</th>
                            <th class="text-center">Assigned  Person</th>
                            <th class="text-center">Start Date</th>
                            <th class="text-center">End Date</th>
                            <th class="text-center" style="width:10%">Plan Hrs</th>
                            <th class="text-center" style="width:10%">Act Hrs</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                          if (!empty($modelTaskBreakup)) {
                        foreach ($modelTaskBreakup as $row) {
                            ?>
                            <tr>
                                <td>
                                    <?php echo $m; ?>
                                </td>
                                <td>
                                    <?php echo $row->taskcategory_details->category_name; ?>
                                </td>
                                <td>
                                    <?php echo $row->taskcategory_sub_details->subcategory_name; ?>
                                </td>
                                <td>
                                    <?php echo $this->ciphertext($row['Assigned_details']['first_name'], "d") . ' ' . $this->ciphertext($row['Assigned_details']['last_name'], "d"); ?>
                                </td>
                                <td>
                                    <?php echo date('d/m/Y', STRTOTIME($row['task_start_date'])); ?>
                                </td>
                                <td>
                                    <?php echo date('d/m/Y', STRTOTIME($row['task_end_date'])); ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $row->budget_task_hours; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $row->task_actual_hours; ?>
                                </td>
                            </tr>
                            <?php
                            $m = $m + 1;
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="8" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
        <?php
        $i = 1;
        $modelLabourTime = WsProjectLabourTime::model()->findAll(array('condition' => 'project_id = ' . $id . '', 'order' => 't.project_id'));
       
            ?>
            <h5>Labour Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center bc-tl">Phase</th>
                            <th class="text-center">Years</th>
                            <th class="text-center">Months</th>
                            <th class="text-center">Days</th>
                            <th class="text-center">Hrs</th>
                            <th class="text-center">Total Hrs</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                         if (!empty($modelLabourTime)) {
                            $labour_total_hrs=0;
                        foreach ($modelLabourTime as $row) {
                            
                            ?>
                            <tr>
                                <td>
                                    <?php echo $i; ?>
                                </td>
                                <td>
                                    <?php echo $row->phase_details->phase_name; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $row->total_years; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $row->total_months; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $row->total_days; ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $row->total_hours; ?>
                                </td>
                               
                                    <?php
                                    $modelLabourTime = WsProjectLabourTime::model()->find(array('condition' => 'project_id="' . $id . '" 
                                                                                                            AND phase_id="' . $row->phase_id . '"'));
                                    $modelMasterLabourHours = MasterLabourHours::model()->findAll();
                                    $year = 0;
                                    $month = 0;
                                    $day = 0;
                                    $hour_rate = 0;
                                    $total_year = 0;
                                    $total_month = 0;
                                    $total_day = 0;
                                    $cat_total = 0;
                                    $admin_total = 0;
                                    $profit_total = 0;
                                    if (!empty($modelMasterLabourHours)) {
                                        foreach ($modelMasterLabourHours as $t => $time) {
                                            if ($time['id'] == '1') {
                                                $year = $time['task_duration'];
                                            } else if ($time['id'] == '2') {
                                                $month = $time['task_duration'];
                                            } else if ($time['id'] == '3') {
                                                $day = $time['task_duration'];
                                            } else if ($time['id'] == '4') {
                                                $hour_rate = $time['task_duration'];
                                            }
                                        }
                                        
                                    }
                                    $houryear = $year * $month * $day;
                                    $hourmonth = $month * $day;
                                    if (!empty($modelLabourTime)) {
                                        $total_year = ($modelLabourTime['total_years'] * $houryear);
                                        $total_month = ($modelLabourTime['total_months'] * $hourmonth);
                                        $total_day = ($modelLabourTime['total_days'] * $day);
                                        $total_hour = $modelLabourTime['total_hours'];
                                        $total_labour_cost = $total_year + $total_month + $total_day + $total_hour;
                                    }
                                    
                                    ?>
                              
                                <td class="text-right"><?php echo $total_labour_cost; ?> </td>
                            </tr>
                            <?php
                         
                            $labour_total_hrs= $labour_total_hrs+$total_labour_cost;
                            $i = $i + 1;
                        }
                       
                        ?>
                        <tr>
                        <td colspan="6" class="text-right">Total</td>
                        <td colspan="" class="text-right">
                        <?php echo number_format($labour_total_hrs); ?></td>
                        </tr>
                        <?php
                        
                    } else {
                        ?>
                        <tr>
                            <td colspan="7" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
        <br>
        <?php
        $i = 1;
        $modelTimesheetStaff = WsProjectWorkTime::model()->findAll(array('condition' => 'project_id=' . $id, 'group' => 'project_id,work_date', 'order' => 'work_date desc'));
        $model_duration_hrs = WsProjectWorkTime::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(worked_hrs))) As worked_hrs,SEC_TO_TIME(SUM(time_to_sec(travel_hrs))) As travel_hrs', 'condition' => 'project_id="' . $id . '"'));
       
            ?>
            <h5>Labour Time Sheet Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center">No</th>
                            <th class="text-center">Date</th>
                            <th class="text-center">Total Working Hrs(<?php echo $model_duration_hrs->worked_hrs; ?>)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                         if (!empty($modelTimesheetStaff)) {
                        foreach ($modelTimesheetStaff as $model_time) {
                            ?>
                            <tr>
                                <td>
                                    <?php echo $i; ?>
                                </td>
                                <td class="text-center">
                                    <?php echo date('d/m/Y', strtotime($model_time->work_date)); ?>
                                </td>
                                <?php
                                $model_duration = WsProjectWorkTime::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(worked_hrs))) As worked_hrs,SEC_TO_TIME(SUM(time_to_sec(travel_hrs))) As travel_hrs', 'condition' => 'project_id="' . $id . '" and work_date ="' . $model_time['work_date'] . '"'));
                                ?>
                                <td class="text-center">    
                                    <?php
                                    echo $model_duration->worked_hrs;
                                    ?>
                                </td>
                                
                            </tr>
                            <?php
                            $i = $i + 1;
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="4" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
        <?php
        $i = 1;
        $modelPurchaseOrder = PurchasingOrder::model()->findAll(array('condition' => 'project_ids = ' . $id . '', 'order' => 't.project_ids'));
       
            ?>
            <h5>Purchase Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center">Type</th>
                            <th class="text-center">File</th>
                            <th class="text-center">PO#</th>
                            <th class="text-center">Supplier</th>
                            <th class="text-center">Order Date</th>
                            <th class="text-center">Currency</th>
                            <th class="text-center">Total Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
               $modelPurchaseOrder_p=PurchasingOrder::model()->findAll(array('condition'=>'project_classification_id = ("'.$id.'")'));

                         if (!empty($modelPurchaseOrder_p)) {
                        foreach ($modelPurchaseOrder_p as $row) {
                            ?>
                            <tr>
                                <td> <?php echo $i; ?> </td>
                                <td><?php echo "Stock"; ?></td>
                                <td><?php echo $row->file_id; ?></td>
                                <td><?php echo $row->id; ?></td>
                                <td><?php echo $row->vendor->vendor_name; ?></td>
                                <td><?php echo date('d/m/Y', strtotime($row->order_date)); ?></td>
                                <td><?php echo $row->currencyname->currency_code; ?></td>
                                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($row->stock_grand_total, ''); ?></b></td>
                            </tr>
                            <?php
                            $i = $i + 1;
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="8" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br><br>
        <?php
        $i = 1;
        $modelGoodsIssueItem=InventoryGoodsIssueItem::model()->with('inventorygoodsissue')->findAll(array('condition'=>'inventorygoodsissue.project_classification_id='.$id));
       
            ?>
            <h5>Material Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center">Issue#</th>
                            <th class="text-center">Reference#</th>
                            <th class="text-center">Issue Date</th>
                            <th class="text-center">Product</th>
                            <th class="text-center">Description</th>
                            <th class="text-center">Quantity</th>
                            <th class="text-center">Unit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                         if (!empty($modelGoodsIssueItem)) {
                        foreach ($modelGoodsIssueItem as $eachItem) {
                            
                            ?>
                            <tr>
                                <td> <?php echo $i; ?> </td>
                                <td><?php echo $eachItem->inventorygoodsissue->id; ?></td>
                                <td><?php echo $eachItem->inventorygoodsissue->reference; ?></td>
                                <td><?php echo date('d/m/Y', strtotime($eachItem->inventorygoodsissue->goods_issue_date)); ?></td>
                                <td><?php echo $eachItem->product->part_number; ?></td>
                                <td><?php echo $eachItem->description; ?></td>
                                <td><?php echo $eachItem->picked_qty; ?></td>
                                <td><?php echo $eachItem->uom->name; ?></td>
                            </tr>
                            <?php
                            $i = $i + 1;
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="8" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
      
        <?php
        $i = 1;
       
            $modelCostDetails = WsProjectPhaseCostDetails::model()->find(array('condition' => 'project_id=' . $id));
 if ($id!=0) {
            ?>
            <h5>Total Cost Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th colspan="2">Items</th>
                            <th>Material Cost</th>
                            <th>Labour Cost</th>
                            <th>Total</th>
                            <th>Admin</th>
                            <th>Profit</th>
                            <th>Net</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                        <tr>
                            <td colspan="5"></td>
                            <td><?php echo $model->admin_percentage; ?></td>
                            <td><?php echo $model->profit_percentage; ?></td>
                            <td></td>
                        </tr>
                        <?php
                        $cost_phase_details = WsProjectEstimationDetails::model()->findAll(array('condition' => 'project_id="' . $id . '"', 'group' => '`phase_id`'));
                        if (!empty($cost_phase_details)) {
                            $sno = 0;
                            $grand_total = 0;
                            $grand_mat_cost = 0;
                            $grand_labourcost = 0;
                            $grand_total_LM = 0;
                            $grand_total_admin = 0;
                            $grand_total_profit = 0;
                            $total_labour_cost = 0;
                            foreach ($cost_phase_details as $each_phase) {
                                ?>
                                <tr>
                                    <th colspan="2" style="background-color: #F2E779;">Phase : <?php $modelPhase = WsProjectPhase::model()->findByPK($each_phase->phase_id);
                    echo $modelPhase->phase_name;
                                ?></th>
                                    <?php
                                    $modelLabourTime = WsProjectLabourTime::model()->find(array('condition' => 'project_id="' . $id . '" 
                                                                                                            AND phase_id="' . $each_phase->phase_id . '"'));
                                    $modelMasterLabourHours = MasterLabourHours::model()->findAll();
                                    $year = 0;
                                    $month = 0;
                                    $day = 0;
                                    $hour_rate = 0;
                                    $total_year = 0;
                                    $total_month = 0;
                                    $total_day = 0;
                                    $cat_total = 0;
                                    $admin_total = 0;
                                    $profit_total = 0;
                                    if (!empty($modelMasterLabourHours)) {
                                        foreach ($modelMasterLabourHours as $i => $time) {
                                            if ($time['id'] == '1') {
                                                $year = $time['task_duration'];
                                            } else if ($time['id'] == '2') {
                                                $month = $time['task_duration'];
                                            } else if ($time['id'] == '3') {
                                                $day = $time['task_duration'];
                                            } else if ($time['id'] == '4') {
                                                $hour_rate = $time['task_duration'];
                                            }
                                        }
                                    }
                                    $houryear = $year * $month * $day;
                                    $hourmonth = $month * $day;
                                    if (!empty($modelLabourTime)) {
                                        $total_year = ($modelLabourTime['total_years'] * $houryear) * $hour_rate;
                                        $total_month = ($modelLabourTime['total_months'] * $hourmonth) * $hour_rate;
                                        $total_day = ($modelLabourTime['total_days'] * $day) * $hour_rate;
                                        $total_hour = $modelLabourTime['total_hours'] * $hour_rate;
                                        $total_labour_cost = $total_year + $total_month + $total_day + $total_hour;
                                    }
                                    $condition = 't.quantity > 0 AND t.project_id = ' . $id . ' AND t.phase_id=' . $each_phase->phase_id;
                                    //   $total_cost_for_labour = EstimationDetails::model()->find(array('select'=>'(SUM(t.total_cost_for_labour)) AS total_cost_for_labour','condition'=>$condition))->total_cost_for_labour;
                                    $cat_total = WsProjectEstimationDetails::model()->find(array('select' => '(SUM(t.total_material_cost)) AS total_material_cost', 'condition' => $condition))->total_material_cost;
                                    $grand_mat_cost +=$cat_total;
                                    $grand_labourcost += $total_labour_cost;
                                    ?>
                                    <td style="width: 10%;text-align: right; font-weight: bold; background-color: #F2E779;"><?php echo Yii::app()->numberFormatter->formatCurrency($cat_total, " "); //echo $total_material_cost;   ?></td>
                                    <td style="width: 10%;text-align: right; font-weight: bold;background-color: #F2E779;"><?php echo Yii::app()->numberFormatter->formatCurrency($total_labour_cost, " "); //echo $total_material_cost;  ?></td>
                                    <?php
                                    $grand_total = $cat_total + $total_labour_cost;
                                    $grand_total_LM += $grand_total;
                                    ?>
                                    <td style="width: 10%;text-align: right; font-weight: bold ;background-color: #F2E779;" id ="total_<?php echo $sno; ?>_val"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); //echo $total_material_cost;  ?></td> 
                                    <?php
                                    $admin_total = $grand_total * ($model->admin_percentage / 100);
                                    $admin_total += $grand_total;
                                    $grand_total_admin += $admin_total;
                                    ?>
                                    <td style="width: 10%;text-align: right; font-weight: bold ;background-color: #F2E779;" id ="admin_<?php echo $sno; ?>_total"><?php echo Yii::app()->numberFormatter->formatCurrency($admin_total, " "); //echo $total_material_cost;  ?></td>  
                                    <?php
                                    $profit_total = $admin_total * ($model->profit_percentage / 100);
                                    $profit_total += $admin_total;
                                    $grand_total_profit +=$profit_total;
                                    ?>
                                    <td style="width: 10%;text-align: right; font-weight: bold ;background-color: #F2E779;" id ="profit_<?php echo $sno; ?>_total"><?php echo Yii::app()->numberFormatter->formatCurrency($profit_total, " "); //echo $total_material_cost;   ?></td>  
                                    <td style="width: 10%;text-align: right; font-weight: bold ;background-color: #F2E779;" id ="net_<?php echo $sno; ?>_total"><?php echo Yii::app()->numberFormatter->formatCurrency($profit_total, " "); //echo $total_material_cost;   ?></td>  
                                </tr><?php $modelEstimetePhase = WsProjectPhaseDetails::model()->findAll(array('condition' => 'project_id="' . $id . '" 
                                                                                                            AND phase_id="' . $each_phase->phase_id . '"', 'group' => '`category_id`')); ?>
                                <tr>
                                    <!-- style="background-color: #F9F4C1;" -->
                                </tr>
                                <?php
                                if (!empty($modelEstimetePhase)) {
                                    foreach ($modelEstimetePhase as $each) {
                                        ?>
                                        <tr>
                                            <!-- style="background-color: #F9F4C1;" -->
                                            <td colspan="2"><?= MasGeneric::model()->findByPk($each->category_id)->generic_name ?></td>
                                            <?php
                                            $total = 0;
                                            $total_labour_cost = 0;
                                            $total_mat_cost = 0;
                                            $total_variance_LC_cost = 0;
                                            $total_variance_MC_cost = 0;
                                            $grand_over_head_total = 0;
                                            $grand_profit_total = 0;
                                            $grand_proposed_total = 0;
                                            $condition = 't.quantity > 0 AND t.project_id = ' . $id . ' AND t.phase_id=' . $each_phase->phase_id . ' AND t.category_id=' . $each_phase->category_id;
                                            $total_material_cost = WsProjectEstimationDetails::model()->find(array('select' => '(SUM(t.total_material_cost)) AS total_material_cost', 'condition' => $condition))->total_material_cost;
                                            ?>
                                            <td style="width: 10%;text-align: right;"><?php echo Yii::app()->numberFormatter->formatCurrency($total_material_cost, " "); //echo $total_material_cost;    ?></td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        }
                        $i = $i + 1;
                        $sno++;
// }
                        ?>
                        <tr style ="background-color: #32CD32;"> <td style="font-weight: bold; ">Total</td>
                            <td colspan="2" style="font-weight: bold;text-align: right;background-color: #32CD32;"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_mat_cost, " "); ?></td>
                            <td style="font-weight: bold;text-align: right;"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_labourcost, " "); ?></td>
                            <td style="font-weight: bold;text-align: right;"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total_LM, " "); ?></td>
                            <td style="font-weight: bold;text-align: right;" id ="grand_total_admin_total"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total_admin, " "); ?></td>
                            <td style="font-weight: bold;text-align: right;" id ="grand_total_profit_total"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total_profit, " "); ?></td>
                            <td style="font-weight: bold;text-align: right;" id ="grand_total_net_total"><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total_profit, " "); ?></td>
                        </tr> 
                        <?php
                    } else {
                        ?>
                        <tr>
                            <td colspan="8" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
           <?php
        $l = 1;
        $modelWsProjectInduction = WsProjectInduction::model()->with('employeedetail')->findAll(array('condition' => ' project_id="' . $id . '" AND type="O"'));
        $modelWsProjectInductionLabour = WsProjectInduction::model()->with('labourdetail')->findAll(array('condition' => ' project_id="' . $id . '" AND type="E"'));
        
            ?>
           
                    <h5>Induction Details(Own Employees)</h5>
                    <div>
            <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center bc-tl">Employee Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                         if (!empty($modelWsProjectInduction)) {
                         foreach ($modelWsProjectInduction as $row) {
                            
                            ?>
                            <tr>
                                <td>
                                    <?php echo $l; ?>
                                </td>
                                <td>
                                    <?php echo $row->employeedetail->de_first_name;?> 
                                </td>
                               
                           
                            </tr>
                            <?php
                            $l = $l + 1;
                             
                        }
                    
                    } else {
                        ?>
                        <tr>
                            <td colspan="2" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <h5>Induction Details(External Employees)</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center bc-tl"> Company</th>
                            <th class="text-center bc-tl">Employee Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                         if (!empty($modelWsProjectInductionLabour)) {
                         foreach ($modelWsProjectInductionLabour as $row) {
                            
                            ?>
                            <tr>
                                <td>
                                    <?php echo $l; ?>
                                </td>
                                <td>
                                    <?php echo $row->labourdetail->company->company_name;?> 
                                </td>
                                <td>
                                    <?php echo $row->labourdetail->employee_name;?> 
                                </td>
                               
                           
                            </tr>
                            <?php
                            $l = $l + 1;
                             
                        }
                    
                    } else {
                        ?>
                        <tr>
                            <td colspan="3" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
                    </div>
<br>
        <?php
        $d = 1;
        $modelWsProjectDailyschedule = WsProjectDailyschedule::model()->findAll(array('condition' => ' project_id="' . $id . '"','order' => 'schedule_date desc'));
            ?>
            <h5>Daily Schedule Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl" style="width:5%"> No</th>
                            <th class="text-center bc-tl"  style="width:10%">Date</th>
                            <th class="text-center bc-tl"  style="width:55%">Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                         if (!empty($modelWsProjectDailyschedule)) {
                         foreach ($modelWsProjectDailyschedule as $row) {
                            if ($row['schedule_date'] != '0000-00-00')
							$row['schedule_date'] = date("d/m/Y", strtotime($row['schedule_date']));
						else
                        $row['schedule_date'] = '';
                            ?>
                            <tr>
                                <td>
                                    <?php echo $d; ?>
                                </td>
                                <td>
                                    <?php 
                                    
                                    echo $row['schedule_date'];?> 
                                </td>
                                <td>
                                    <?php echo $row['schedule_description'];?> 
                                </td>
                               
                           
                            </tr>
                            <?php
                            $d = $d+1;
                             
                        }
                    
                    } else {
                        ?>
                        <tr>
                            <td colspan="3" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
        <?php
        $e = 1;
        $modelWsProjectEquipments = WsProjectEquipments::model()->findAll(array('condition' => ' project_id="' . $id . '"'));
      
            ?>
            <h5>Equipments Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"> No</th>
                            <th class="text-center bc-tl">Item</th>
                            <th class="text-center bc-tl">Description</th>
                            <th class="text-center bc-tl">From Date</th>
                            <th class="text-center bc-tl">To Date</th>
                            <th class="text-center bc-tl">Days</th>
                            <th class="text-center bc-tl">Qty.</th>
                            <th class="text-center bc-tl">Rate</th>
                            <th class="text-center bc-tl">Unit</th>
                            <th class="text-center bc-tl">Amount</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $equip_amount=0;
                         if (!empty($modelWsProjectEquipments) &&  ($modelWsProjectEquipments[0]['stock_item_id']) > 0) { 
                         foreach ($modelWsProjectEquipments as $row) {
                            
                            if($row['id']>0)
                            {
                 
                                 $value = $row->product->part_number;
                 
                            }else{
                 
                                $value = $row->product->part_number;
                 
                            }
                            $days_count="";
        $days = DateModel ::diffInDays($row['from_date'],$row['to_date']);
        if($days > 0)
        $days_count=$days;
                           
                            ?>
                            <tr>
                                <td>
                                    <?php echo $e; ?>
                                </td>
                                <td>
                                    <?php 
                                    
                                    echo $value;?> 
                                </td>
                                <td>
                                    <?php echo $row['stock_item_description'];?> 
                                </td>
                                <td>
                                    <?php 
                                   if ($row['from_date'] != '0000-00-00')
                                      $row['from_date'] = date("d/m/Y", strtotime($row['from_date']));
       
                               else
       
                                    $row['from_date'] = '';
                                    echo $row['from_date'];
                                   ?>
                                </td>
                                <td>
                                    <?php 
                                    if ($row['to_date'] != '0000-00-00')
                                    $row['to_date'] = date("d/m/Y", strtotime($row['to_date']));
        
                                else
        
                                $row['to_date'] = '';
                                echo $row['to_date'];
                                    ?> 
                                </td>
                                <td class="text-right">
                                <?php echo $days_count; ?>
                                </td>
                                <td class="text-right">
                                    <?php 
                                    echo Yii::app()->numberFormatter->formatCurrency($row['stock_item_quantity'], " ");
                                     ?> 
                                </td>
                                <td class="text-right">
                                    <?php
                                    echo Yii::app()->numberFormatter->formatCurrency($row['stock_item_rate'], " "); ?> 
                                </td>
                                <td>
                                    <?php echo $row['stock_item_unit'];?> 
                                </td>
                                <td class="text-right">
                                    <?php 
                                 echo Yii::app()->numberFormatter->formatCurrency($row['amount'], " "); 
                                  // echo $row['amount'];?> 
                                </td>
                                
                               
                           
                            </tr>
                            <?php
                            $e++;
                             $equip_amount = $equip_amount + $row['amount'];
                        }
                        ?>
                        <tr>
                            <td colspan="9" class="text-right">Total</td>
                            <td style="font-weight: bold;text-align: right;" id ="grand_total_net_total"><?php echo Yii::app()->numberFormatter->formatCurrency($equip_amount, " "); ?></td>
                    </tr>
                    <?php
                    } else {
                        ?>
                        <tr>
                            <td colspan="10" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
        <br>
        <?php
        $e = 1;
        $modelWsProjectExpense = WsProjectExpense::model()->findAll(array('condition' => ' project_id="' . $id . '"'));
      
            ?>
            <h5>Expense Details</h5>
            <div class="col-md-12 page">
                <table id="" class="table" style="font-size:10px;">
                    <thead>
                        <tr>
                            <th class="text-center bc-tl"  style="width:5%"> No</th>
                            <th class="text-center bc-tl"  style="width:15%">Date</th>
                            <th class="text-center bc-tl"  style="width:55%">Description</th>
                             <th class="text-center bc-tl" style="width:10%">Amount</th>
                         </tr>
                    </thead>
                    <tbody>
                        <?php
                        $expense_amount=0;
                         if (!empty($modelWsProjectExpense) &&  ($modelWsProjectExpense[0]['amount']) > 0) { 
                         foreach ($modelWsProjectExpense as $row) {
                            
                            if($row['id']>0)
                            {
                 
                                // $value = $row->product->part_number;
                 
                            }else{
                 
                                //$value = $row->product->part_number;
                 
                            }
                            ?>
                            <tr>
                                <td>
                                    <?php echo $e; ?>
                                </td>
                                <td>
                                    <?php 
                                   if ($row['expense_date'] != '0000-00-00')
                                      $row['expense_date'] = date("d/m/Y", strtotime($row['expense_date']));
       
                               else
       
                                    $row['expense_date'] = '';
                                    echo $row['expense_date'];
                                   ?>
                                </td>
                                <td>
                                    <?php echo $row['expense_details'];?> 
                                </td>
                               
                                 
                                <td class="text-right">
                                    <?php 
                                    echo Yii::app()->numberFormatter->formatCurrency($row['amount'], " ");
                                   ?> 
                                </td>
                                 
                            </tr>
                            <?php
                            $expense_amount = $expense_amount +$row['amount'];
                            $e++;
                             
                        }
                        ?>
                         <tr>
                            <td colspan="3" class="text-right">Total</td>
                            <td style="font-weight: bold;text-align: right;" id ="grand_total_net_total"><?php echo Yii::app()->numberFormatter->formatCurrency($expense_amount, " "); ?></td>
                    </tr>
                    <?php
                    } else {
                        ?>
                        <tr>
                            <td colspan="4" class="text-center">No Data Found</td>
                        </tr>
                    <?php }
                    ?>
                </tbody>
            </table>
        </div>
<?php $this->renderPartial("//common/footer"); ?>
    </body>
</html>
