<!DOCTYPE html>
<html>
    <?php
    $crm_login_company_id = Yii::app()->user->master_user_company_id;
    $privillage_modal = new MasCompanySettings();
    $privillage_condition = 'crm_company_id=' . $crm_login_company_id;
    $privillage_count = $privillage_modal->count(array('condition' => $privillage_condition));
    $privillage_settings_module = $privillage_modal->find();
    $master_permission = $privillage_settings_module->permissions;
    $master_permission_array = json_decode($master_permission, true);
    ?>
    <head>
        <title>Proforma Invoice</title>
        <style>
               .table_box {
            border-collapse: separate !important;
            margin-top: 10px;
            padding: 10px;
            font-size: 16px !important;
            border: 1px solid #0066ff;
            border-radius: 6px;

        }
                @page {
            margin-top: 1.5cm;
            margin-bottom:1.5cm;
            margin-left: 1.5cm;
            margin-right: 1.5cm;
            header: html_myHeader;
            header: html_otherpages;
            /*font-family: 'Times New Roman';*/
        }
        </style>
    </head>

    <body>
        <div >
        <div >
            <?php $this->renderPartial("//common/header"); ?>
            <div class="col-4">
                <?php
                $modelOrder = Order::model()->findByPk($id);
                ?>
                <div class="input-block">
                    <b><?php echo $id; ?></b>
                </div>
                <b><?php echo strtoupper($modelOrder->customer->customer_name); ?></b><br>
                <?php if ($modelOrder->billing_address != '') { ?>
                    <small><?php echo strtoupper(nl2br($modelOrder->billing_address)); ?></small><br>
                <?php } ?>
                <?php if ($modelOrder->customer->customer_phone_no != '') { ?>
                    <small>Phone : <?php echo strtoupper($modelOrder->customer->customer_phone_no); ?></small><br>
                <?php } ?>
                <?php if ($modelOrder->customercontact->person_name != '') { ?>
                    <br><small>Kind Attn:</small>
                    <small><b><?php echo strtoupper($modelOrder->customercontact->person_name); ?></b></small><br>
                <?php } ?>
                <?php $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id); ?>
                <?php /*if ($settings->trn_no != '') { ?>
                    <div class="input-block" style="background-color:white;font-size: 10px">
                        <b>Our TRN #<?php echo $settings->trn_no; ?></b>
                    </div>
                <?php }*/ ?>
            </div>
            <div class="col-4">
                <div class="h3" style="margin-top: 0;margin-bottom: 0;font-size: 14px;text-align:center">
                    <?php echo "PROFORMA INVOICE"; ?>
                </div>
            </div>
            <div class="col-4" style="color:#101010;">
                <table class="table" style="width:100%" style="font-size:10px;">
                    <tr>
                        <?php
                        $modelOrder = Order::model()->findByPk($id);
                        $model_lead = Lead::model()->find(array('condition' => 'file_id="' . $modelOrder->file_id . '"'));
                        ?>
                        <td class="bc-tl">File ID</td>
                        <td>
                            <?php echo $modelOrder->file_id; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Order #</td>
                        <td>
                            <?php echo $modelOrder->id; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Order Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($modelOrder->order_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Currency</td>
                        <td>
                            <?php echo $modelOrder->currencyname->currency_code; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>LPO</td>
                        <td>
                            <?php echo $modelOrder->lpo; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Payment Terms</td>
                        <td>
                            <?php echo $modelOrder->paymentTerm->payment_terms; ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width:40%">Inco Terms</td>
                        <td>
                            <?php echo $modelOrder->incoterm->inco_name; ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <?php echo $modelOrder->leadowner->first_name . ' ' . $modelOrder->leadowner->last_name . ' , ' . $modelOrder->leadowner->phno; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <br>
        <div class="col-md-12">
            <table id="" class="table" style="font-size:10px;">
                <thead>
                    <tr>
                        <th class="text-center bc-tl">No</th>
                        <th class="text-center" style="width:15%">Part No</th>
                        <th class="text-center" style="width:25%">Description</th>
                        <?php
                        $colspqn = "8";
                        if (isset($master_permission_array['inventory_image_show_order'])) {
                            $colspqn = "9";
                            ?>
                            <th class="text-center">Image</th>
                        <?php } ?>
                        <th class="text-center">Qty</th>
                        <th class="text-center">Unit</th>
                        <th class="text-center">Rate</th>
    <!--                    <th class="text-center">Disc.</th>
                        <th class="text-center">After Disc.</th>-->
                        <th class="text-center">Total</th>
                        <th class="text-center" style="width:10%">Tax Amt</th>
                        <th class="text-center bc-tr">Net Amt</th>
                    </tr>
                </thead>
                <tbody>

                    <?php
                    $m = 1;
                    $condition .= '1=1';
                    $condition .= ' AND t.order_id ="' . $id . '"';
                    $total = 0;
                    $count_alternate_ids = OrderItem::model()->count(array('condition' => 'alternate_id!="" AND t.order_id ="' . $id . '"'));
                    if ($count_alternate_ids > 0) {
                        $order_by = 'alternate_id ASC';
                    } else {
                        $order_by = 'id ASC';
                    }
                    $model_OrderItemslist = OrderItem::model()->findAll(array('condition' => $condition, 'order' => $order_by));

                    foreach ($model_OrderItemslist as $i => $model_OrderItems) {
                        if ($model_OrderItems->product_id == 999999) {
                            ?>
                            <tr style="background-color: #d0f5c5; color: white;"><td colspan="<?= $colspqn + 1 ?>"><b><?php echo $model_OrderItems->description; ?></b></td></tr>
                            <?php
                        } else {
                            ?>  <tr>
                                <td>
                                    <?php
                                    if ($count_alternate_ids > 0) {
                                        echo $model_OrderItems->alternate_id;
                                    } else {
                                        echo $m;
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php echo $model_OrderItems->product->part_number; ?>
                                </td>
                                <td>
                                    <?php echo $model_OrderItems->description; ?>
                                </td>
                                <?php if (isset($master_permission_array['inventory_image_show_order'])) { ?>
                                    <td>
                                        <?php if ($model_OrderItems->product->item_image != '') { ?>
                                            <img src="<?php echo Yii::app()->baseUrl . '/uploads/inventoryimages/' . $model_OrderItems->product->item_image; ?>">
                                        <?php } ?>
                                    </td>
                                <?php } ?>
                                
                                <td class="text-right"><?php echo (int)$model_OrderItems->quantity; ?></td>
                                <td>
                                    <?php echo $model_OrderItems->orderunit->name; ?>
                                </td>
                                <?php // /$rate=$model_OrderItems->net_amount/$model_OrderItems->quantity;?>
                                <?php // $rate=($model_OrderItems->amount+$model_OrderItems->addition_amount)/$model_OrderItems->quantity; ?>
        <!--                        <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model_OrderItems->rate, " "); ?>
                                </td>-->
        <!--                          <td class="text-right">
                                <?= $model_OrderItems->deduction_amount; ?>
                                </td>-->
                                <td class="text-right">
                                    <?php
                                    $after_discount = $model_OrderItems->rate - $model_OrderItems->deduction_amount;
                                    echo Yii::app()->numberFormatter->formatCurrency($after_discount, " ");
                                    ?>
                                </td>
                                <td class="text-right">
                                    <?php
                                    $total_after_discount = $after_discount * $model_OrderItems->quantity;
                                    echo Yii::app()->numberFormatter->formatCurrency($total_after_discount, " ");
                                    ?>
                                </td>
                                <td class="text-right">
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($model_OrderItems->tax_vat_amount, " "); ?>
                                </td>
                                <td class="text-right">
                                    <?php
                                    $net_amount = $model_OrderItems->net_amount + $model_OrderItems->tax_vat_amount;
                                    echo Yii::app()->numberFormatter->formatCurrency($net_amount, " ");
                                    ?>
                                </td>
                            </tr>

                            <?php
                            $m = $m + 1;
                            $total += $model_OrderItems->net_amount;
                            $total_vat += $model_OrderItems->tax_vat_amount;
                        }
                    }
                    ?>
                    <tr>
                        <td class="text-right" colspan=<?php echo $colspqn; ?>><b> Total   </b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan=<?php echo $colspqn; ?>><b>VAT   </b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_vat, " "); ?></b></td>

                    </tr>
                    <?php
                    $Addition = OrderAddition::model()->findAll(array('condition' => 'order_id=' . $modelOrder->id . ' AND calculated_value>0'));
                    $Dedution = OrderDeduction::model()->findAll(array('condition' => 'order_id=' . $modelOrder->id . ' AND calculated_value>0'));
                    if (!empty($Addition)) {
                        foreach ($Addition as $eachAddition) {
                            ?>
                            <tr>
                                <?php
                                $total += $eachAddition->calculated_value;
                                ?>
                                <td class="text-right" colspan=<?php echo $colspqn; ?>>
                                    <?php
                                    echo MasFooterItems::getFooterItemName($eachAddition->particular);
                                    ?>
                                </td>
                                <td class="text-right">+
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($eachAddition->calculated_value, " "); ?>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    if (!empty($Dedution)) {
                        foreach ($Dedution as $eachDed) {
                            ?>
                            <tr>
                                <?php
                                $total -= $eachDed->calculated_value;
                                ?>
                                <td class="text-right" colspan=<?php echo $colspqn; ?>>
                                    <?php
                                    echo MasFooterItems::getFooterItemName($eachDed->particular);
                                    ?>
                                </td>
                                <td class="text-right">-
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($eachDed->calculated_value, " "); ?>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    ?>
                    <tr>
                        <?php $total += $total_vat; ?>
                        <td class="text-right total bc-bl" colspan=<?php echo $colspqn; ?>><b>Grand Total  </b></td>
                        <td class="text-right total bc-br"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan=<?php echo $colspqn + 1; ?>><b>
                                <?php
                                $fcurrency = new MasCurrency();
                                ?>
                                <?php
                                if ($total > 0) {
                                    echo $fcurrency->number_to_currency(number_format(($total), 2, '.', ''), $modelOrder->currency_id);
                                    //echo $modelQ->currencyname->currency . " " . ucfirst($this->widget('ext.NumtoWord.NumtoWord', array('num' => floatval($total)))->result) . ' only';
                                } else {
                                    echo "FOC(Free Of Cost)";
                                }
                                ?></b></td>
                    </tr>

                </tbody>
            </table>

        </div>
        <?php
        if ($modelOrder->terms_and_conditions != '') {
            ?>
            <div class="box" style="width:100%">    <h5>Terms and Conditions</h5>
                <div class="h5sub-details" style="font-size: 10px;">
                    <?php echo nl2br($modelOrder->terms_and_conditions); ?>
                </div>
            </div>
            <?php
        }
        ?>
          <?php if ($modelOrder->notes != '') { ?>
        <div class="box" style="width: 100%">
            <h5>Notes</h5>
            <div class="h5sub-details">
                <?php echo nl2br($modelOrder->notes); ?>
            </div>
        </div>
    <?php } ?>
          <?php
        $model = OwnerBankDetails::model()->find();
        if (!empty($model)) {
            ?>
            <div class="box" style="width:100%">
            <h5>Bank Details</h5>
            <div class="h5sub-details">
                <?= 'Account Name : ' . $model->bank_account_name ?><br>
                <?= 'Account No   : ' . $model->bank_ac_no ?><br>
                <?= 'Bank Name    : ' . $model->bank->bank_name ?><br>
                <?= 'Direct Deposit & Electronic Payments     : ' . $model->bank_swift ?><br>
                <?= 'Domestic Wire Transfers  : ' . $model->bank_ifsc ?><br>
                <?= 'International Wire Transfers      : ' . $model->bank_iban ?><br>
            </div>
        </div>
        <?php } ?>


        <?php $this->renderPartial("//common/footer", array('company_id' => $company_id)); ?>
         </div>
    </body>

</html>
