<!DOCTYPE html>
<html>
    <head>
        <title>Order List</title>
        <style>
            .table_box {
                border-collapse:separate!important;
                margin-top: 10px;
                padding: 10px;
                font-size:16px!important;
                border: 1px solid #0066ff;
                border-radius:6px;
            }
                 div {
         page-break-inside: auto;
            page-break-after: auto;

        }
        </style>
    </head>

    <body>

        <div style="padding: 35px;">
           <div class="" >
    
            
        <div class="">
            <?php  $this->renderPartial("//common/header"); ?>
            <div class="col-4">
                <?php
                $model = Order::model()->findByPk($id);
                $year = date('y'); 
                $formattedId = "$id";
                ?>
                <div class="input-block">
                    <b><?php echo $formattedId; ?></b>
                </div>
                <b><?php echo strtoupper($model->customer->customer_name); ?></b><br>
                <?php if ($model->billing_address != '') { ?>
                    <small><?php echo strtoupper(nl2br($model->billing_address)); ?></small><br>
                <?php } ?>
                <?php if ($model->customer->customer_phone_no != '') { ?>
                    <small>Phone : <?php echo strtoupper($model->customer->customer_phone_no); ?></small><br>
                <?php } ?>
                <?php if ($model->customercontact->person_name != '') { ?>
                    <br><small>Kind Attn:</small>
                    <small><b><?php echo strtoupper($model->customercontact->person_name); ?></b></small><br>
                <?php } ?>
            </div>
            <div class="col-4">
            <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 14px;">
                <?php echo "SALES ORDER"; ?>
            </div>    
            </div>
            <div class="col-4" style="color:#101010;">
                <table class="table" style="width:100%" style="font-size:10px;">
                    <tr>
                        <?php
                        $modelOrder = Order::model()->findByPk($id);
                        $model_lead = Lead::model()->find(array('condition' => 'file_id="' . $modelOrder->file_id . '"'));
                        ?>
                        <td class="bc-tl">File ID</td>
                        <td>
                            <?php echo $modelOrder->file_id; ?>
                        </td>
                    </tr>
                   
                    <tr>
                        <td>Customer ID</td>
                        <td>
                            <?php echo $modelOrder->customer_id; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Customer TRN #</td>
                        <td>
                            <?php echo $modelOrder->customer->customer_trn_no; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Order Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($modelOrder->order_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Delivery Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($modelOrder->delivery_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>LPO</td>
                        <td>
                            <?php echo $model->lpo; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Payment Terms</td>
                        <td>
                            <?php echo $modelOrder->paymentTerm->payment_terms; ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width:40%">Inco Terms</td>
                        <td>
                            <?php echo $modelOrder->incoterm->inco_name; ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <?php echo $model->leadowner->first_name . ' ' . $model->leadowner->last_name . ' , ' . $model->leadowner->phno; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <br>
        <div class="col-md-12">
            <table class="table" style="font-size:10px;">
    <thead>
        <tr>
            <th>No</th>

            <?php if ($print_type != 5 && $print_type != 6) { ?>
                <th class="text-center">Part No</th>
            <?php } ?>

            <?php if ($print_type == 4 || $print_type == 5 || $print_type == 6 || $print_type == 7 || $print_type == 1) { ?>
                <th class="text-center">Description</th>
            <?php } ?>

            <?php if (isset($master_permission_array['inventory_image_show_order']) || $print_type == 6 || $print_type == 7) { ?>
                <th class="text-center">Image</th>
            <?php } ?>

            <th>Qty</th>

            <?php if ($bonus_quantity == "Y") { ?>
                <th>Bonus Qty</th>
            <?php } ?>

            <th class="text-center">Unit</th>
            <th class="text-center">Rate</th>
            <th class="text-center">Total</th>
            <th class="text-center">Tax Amt</th>
            <th class="text-center bc-tr">Net Amt</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $m = 1;
        $condition .= '1=1 AND t.order_id ="' . $id . '"';
        $total = $totaldeduction = $total_after_discount_tot = $net_amount_tot = 0;
        $total_cbm = $total_weight = 0;

        $modelOrderItem = OrderItem::model()->findAll(['condition' => $condition, 'order' => 'id ASC']);

        foreach ($modelOrderItem as $eachItem) {
            $totaldeduction += $eachItem->deduction_amount;

            // Memo Row
            if ($eachItem->product_id == 999999) {
                echo '<tr style="background-color:#d0f5c5;color:white;">
                        <td colspan="12"><b>' . $eachItem->description . '</b></td>
                      </tr>';
                continue;
            }

            echo '<tr>';
            echo '<td>' . $m . '</td>';

            if ($print_type != 5 && $print_type != 6) {
                echo '<td>' . $eachItem->product->part_number . '</td>';
            }

            if ($print_type == 4 || $print_type == 5 || $print_type == 6 || $print_type == 7 || $print_type == 1) {
                echo '<td>' . nl2br($eachItem->description) . '</td>';
            }

            if (isset($master_permission_array['inventory_image_show_order']) || $print_type == 6 || $print_type == 7) {
                echo '<td>';
                if (!empty($eachItem->product->item_image)) {
                    echo '<img src="' . Yii::app()->baseUrl . '/uploads/inventoryimages/' . $eachItem->product->item_image . '" style="max-width:100px;height:auto;">';
                }
                echo '</td>';
            }

            echo '<td class="text-right">' . (int)$eachItem->quantity . '</td>';

            if ($bonus_quantity == "Y") {
                echo '<td class="text-right">' . (int)$eachItem->bonus_qty . '</td>';
            }

            echo '<td>' . $eachItem->orderunit->name . '</td>';

            echo '<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($eachItem->rate, " ") . '</td>';
            echo '<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(($eachItem->rate * $eachItem->quantity), " ") . '</td>';

            $taxamount = $eachItem->tax_vat_amount;
            echo '<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($taxamount, " ") . '</td>';

            $net_amount = $eachItem->net_amount + $eachItem->tax_vat_amount;
            echo '<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($net_amount, " ") . '</td>';
            echo '</tr>';

            $m++;
            $total += $eachItem->amount;
            $net_amount_tot += $net_amount;
            $total_after_discount_tot += (($eachItem->rate - $eachItem->deduction_amount) * $eachItem->quantity);

            // CBM & Weight
            if ($eachItem->orderunit->name == 'Carton') {
                $total_cbm += ($eachItem->quantity * $eachItem->product->cubic_meter);
                $total_weight += ($eachItem->quantity * $eachItem->product->weight);
            }
        }

        // Determine dynamic colspan
        $colCount = 1; // "No"
        if ($print_type != 5 && $print_type != 6) $colCount++; // "Part No"
        if ($print_type == 4 || $print_type == 5 || $print_type == 6 || $print_type == 7 || $print_type == 1) $colCount++; // "Description"
        if (isset($master_permission_array['inventory_image_show_order']) || $print_type == 6 || $print_type == 7) $colCount++; // "Image"
        $colCount++; // Qty
        if ($bonus_quantity == "Y") $colCount++; // Bonus Qty
        $colCount += 4; // Unit, Rate, Total, Tax Amt, Net Amt
            //echo $colCount;
        ?>

        <!-- TOTALS SECTION -->
        <?php if ($modelOrder->total_tax_amount > 0): ?>
            <tr>
                <td class="text-right" colspan="<?php echo $colCount; ?>"><b>Total</b></td>
                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b></td>
            </tr>

            <?php if ($print_type == 2 || $print_type == 7 || $print_type == 1): ?>
                <tr>
                    <td class="text-right" colspan="<?php echo $colCount; ?>"><b>Discount</b></td>
                    <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($totaldeduction, " "); ?></b></td>
                </tr>
                <tr>
                    <td class="text-right" colspan="<?php echo $colCount; ?>"><b>Total After Discount</b></td>
                    <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total - $totaldeduction, " "); ?></b></td>
                </tr>
                <?php $total -= $totaldeduction; ?>
            <?php endif; ?>

            <tr>
                <td class="text-right" colspan="<?php echo $colCount; ?>"><b>VAT</b></td>
                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($modelOrder->total_tax_amount, " "); ?></b></td>
            </tr>
        <?php endif; ?>

        <!-- ADDITIONS & DEDUCTIONS -->
        <?php
        $Addition = OrderAddition::model()->findAll(['condition' => 'order_id=' . $modelOrder->id . ' AND calculated_value>0']);
        $Deduction = OrderDeduction::model()->findAll(['condition' => 'order_id=' . $modelOrder->id . ' AND calculated_value>0']);

        foreach ($Addition as $eachAddition) {
            $total += $eachAddition->calculated_value;
            echo '<tr><td class="text-right" colspan="' . $colCount . '">' . MasFooterItems::getFooterItemName($eachAddition->particular) . '</td>';
            echo '<td class="text-right">+' . Yii::app()->numberFormatter->formatCurrency($eachAddition->calculated_value, " ") . '</td></tr>';
        }

        foreach ($Deduction as $eachDed) {
            $total -= $eachDed->calculated_value;
            echo '<tr><td class="text-right" colspan="' . $colCount . '">' . MasFooterItems::getFooterItemName($eachDed->particular) . '</td>';
            echo '<td class="text-right">-' . Yii::app()->numberFormatter->formatCurrency($eachDed->calculated_value, " ") . '</td></tr>';
        }
        ?>

        <!-- GRAND TOTAL -->
        <tr>
            <td class="text-right total bc-bl" colspan="<?php echo $colCount; ?>"><b>Grand Total</b></td>
            <?php $total += $modelOrder->total_tax_amount; ?>
            <td class="text-right total bc-br"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b></td>
        </tr>
        <tr>
            <td class="text-right" colspan="<?php echo $colCount + 1; ?>">
                <b>
                    <?php
                    $fcurrency = new MasCurrency();
                    if ($total > 0) {
                        echo $fcurrency->number_to_currency(number_format(($total), 2, '.', ''), $modelOrder->currency_id);
                    } else {
                        echo "FOC (Free Of Cost)";
                    }
                    ?>
                </b>
            </td>
        </tr>
    </tbody>
</table>


        </div>

        <?php
        if ($modelOrder->terms_and_conditions != '') {
            ?>
            <div class="box" style="width:100%">    <h5>Terms and Conditions</h5>
                <div class="h5sub-details" style="font-size: 10px;">
                    <?php echo nl2br($modelOrder->terms_and_conditions); ?>
                </div>
            </div>
            <?php
        }

        if ($modelOrder->notes != '') {
            ?>
            <div class="box" style="width:100%">    <h5>Notes</h5>
                <div class="h5sub-details" style="font-size: 10px;">
                    <?php echo nl2br($modelOrder->notes); ?>
                </div>
            </div>
        <?php } ?>
        <?php $this->renderPartial("//common/footer", array('company_id' => $company_id)); ?>
</div>

    </body>

</html>
