<?php
 $modelOrder = Order::model()->findByPk($id);
 ?>
<!DOCTYPE html>
<html>
<head>
<title>Service Agreement</title>
</head>
<body>

 <?php $this->renderPartial('//common/header');?>


<h3 style="text-align: center;text-decoration:underline;">SERVICE AGREEMENT</h3>
<p>AGREEMENT NO –<b>CRL/CA/<?php echo $modelOrder->id;?></b></p>
<p>THIS AGREEMENT IS DATED <b><?php echo date('d/m/Y',strtotime($modelOrder->order_date));?></b><?php if($modelOrder->id>0){ ?> from the Quotation : <b><?php echo $modelOrder->id;?></b><?php } ?></p>
<p>BETWEEN <br><br> <b>CORAL CONCEPTS LLC</b>, a company incorporated in the United Arab Emirates (UAE) and whose principal address is <b>P.O BOX: 186887, DUBAI U.A.E.</b> (referred to as the Company)
<br><br>AND <br><br>
<b><?php echo strtoupper($modelOrder->customer->customer_name);?></b>, a company incorporated in the United Arab Emirates (UAE) and whose principal address is <b><?php echo $modelOrder->billing_address;?></b>. (referred to as the Client)
<br><br>WHEREAS,  <br><br>The company has entered into an Agreement (“Service Agreement”)with The Client to provide Scent Diffuser Equipment Service including installation of Scent Diffuser Equipment at the locations of the Customer’s premises. </p>
<p>Now therefore it is agreed as follows: </p>

<h4>1.	DEFINITIONS</h4>
<ol>
	<li style="padding: 5px 0px;"> “Equipment” means Scent Diffuser Machine known as the oil diffuser required to produce Scent smell in the area where the machine is installed. </li>
	<li style="padding: 5px 0px;"> “Commencement Date” means the date on which this Agreement is duly signed and executed by the Parties; </li>
</ol>

<h4 style="margin-bottom:2px;">2.	TERMS OF ENGAGEMENT</h4>
<ol style="margin-bottom:10px;">
	<li style="padding: 5px 0px;"> The Client is obligated to submit the copies of Trade License, Tax Registration Certificate, authorized signatory details etc. to the Company and any change in such certificates are to be updated on time. </li>
	<li style="padding: 5px 0px;"> This Agreement will take effect from the Commencement Date and will continue, until the completion of the Project (ref 6.2) unless terminated earlier. </li>
	<li style="padding: 5px 0px;"> The Company agrees to rent Equipment to the client for the rental period and the Client agrees to take the Equipment on hire for that period and to pay the rental fee set out in the pricelist for the equipment for that rental period, on the terms and conditions set out in this agreement. </li>
	<li style="padding: 5px 0px;"> The Company will install the complete system in presence of the Client’s authorized official, who will acknowledge the installation.</li>
	<li style="padding: 5px 0px;"> The client is obligated to take care and shall not allow any damage to the equipment installed by the company. The client will be liable to compensate the Company for any physical damage or missing of the equipment during the contract period. </li>
	<li style="padding: 5px 0px;"> The Client agrees to select the fragrance oil from the sample submitted by the Company and if any changes required later in the selected fragrance oil it must be informed to the company at least one month in advance. </li>
	<li style="padding: 5px 0px;"> The Client agrees that the installation, removal, service, repair or modification of the Equipment or replacement of fragrance oil shall be carried out solely by the Company, unless a prior written consent is obtained from the Company to do such things. </li>
</ol>

<h4>3.	BILLING AND PAYMENTS </h4>

<ol>
	<li style="padding: 5px 0px;"> The Company will submit invoice on monthly basis to the Client and the Client is obligated to settle the invoices by payment either through Cash, Bank Transfer or by Cheque within agreed days in the agreement (ref 6.4).  </li>
	<li style="padding: 5px 0px;"> If any change in credit period and credit amount required it will be decided by the Company on submission of new credit application form by the Client with required documents. </li>

</ol>

<h4>4.	DISPUTE RESOLUTION </h4>

<ol>
	<li style="padding: 5px 0px;"> If any difference or dispute between the two parties shall arise at any time, the parties involved shall, acting reasonably and in good faith, use their best effort to resolve the same as soon as possible in an amicable manner. If such dispute is not resolved within fifteen(15)days from a written notice by one party to the other, such dispute shall be referred to DUBAI COURTS. </li>

</ol>
<h4>5.	TERMINATION OF CONTRACT </h4>

<ol>
	<li style="padding: 5px 0px;"> Both the Company and the Client can terminate the contract by providing 30 days’ notice written or mail.  </li>
	<li style="padding: 5px 0px;"> The Client while sending termination notice is required to pay all  the dues and hand over the equipment. </li>

</ol>

<h4>6.	Details of Equipment/Contract Period/Rental Charge and Payment Terms </h4>

<ol>
<li style="padding: 5px 0px;">1.
	
<table style="border:1px solid black;border-collapse:collapse; width: 100%;">

<tr>

<th style="border:1px solid black;padding: 5px;text-align: left;width:10%">Sl</th>
<th style="border:1px solid black;text-align: left;padding: 5px;width:40%">Machine</th>
<th style="border:1px solid black;text-align: left;padding: 5px;width:10%">Quantity</th>
<th style="border:1px solid black;text-align: left;padding: 5px;width:20%">Amount</th>
<th style="border:1px solid black;text-align: left;padding: 5px;width:20%">Tot.AED.(VAT.Exclusive)</th>

</tr>

<?php
    $m = 1;
    $condition .= 'order_id ="' . $id . '"';
    
    $total = 0;
    
    $modelOrderOrderItem = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
    $grand_total=0;
    foreach ($modelOrderOrderItem as $i => $eachItem) {
        $rate = ($eachItem->amount + $eachItem->addition_amount) / $eachItem->quantity; 
        
        ?>
        <tr>
            <td style="border:1px solid black;padding: 5px;text-align: left;"><?php echo $m;?></td>
            <td style="border:1px solid black;padding: 5px;"><?php echo nl2br($eachItem->description);?></td>
            <td style="border:1px solid black;padding: 5px;text-align: right;"><?php echo $eachItem->quantity;?></td>
            <td style="border:1px solid black;padding: 5px;text-align: right"><?php echo Yii::app()->numberFormatter->formatCurrency($rate, " ");?></td>
            <td style="border:1px solid black;padding: 5px;text-align: right"><?php echo Yii::app()->numberFormatter->formatCurrency(($rate * $eachItem->quantity), " ");?></td>
        </tr>
        <?php
        $m++;
        $grand_total+= ($rate * $eachItem->quantity);
    }
    
    ?>



</table>
</li>
</ol>
<ul style="list-style-type: none;">
	<li style="padding: 5px 0px;">2. Contract Rental service Period : <b><?php echo ($modelOrder->contract_start_date!='' && $modelOrder->contract_start_date!='0000-00-00')?date('d/m/Y',strtotime($modelOrder->contract_start_date)):'';?></b> to <b><?php echo ($modelOrder->contract_end_date!='' && $modelOrder->contract_end_date!='0000-00-00')?date('d/m/Y',strtotime($modelOrder->contract_end_date)):'';?></b></li><br/>
	<li style="padding: 5px 0px;">3. Total Rental Charges per month: AED - <b><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " ");?></b>(VAT Exclusive) </li><br/> 
    <li style="padding: 5px 0px;">4. Payment Terms- <b>
        
        <?php
        $modelOrderOrder = Order::model()->findByPk($id);
        echo $modelOrderOrder->paymentTerm->paymentTerm;?></b> </li>

</ul>

<p>Executed as an agreement:</p>
<div style="width:100%;display: flex;">
	<div style="width:50%;float: left;">

		<p>For &nbsp;<?php echo strtoupper($modelOrder->customer->customer_name);?>   </p>   
		<p>.....................................................   </p>
		<p>(Signature & Company Stamp)   </p>   
		<p>.....................................................<br>Name & Position in the company   </p>                                           
	</div>

	<div style="width:50%;float: right;">

		<p style="text-align:right;margin-right: 60px;">For   Coral Concepts LLC  </p>  
		<p style="text-align:right;">.....................................................    </p>
		 <p style="text-align:right;margin-right: 20px;">(Signature & Company Stamp)                                                                                                  </p>
		 <p style="text-align:right;">.....................................................<br>Name & Position in the company    </p>
   
	</div>
</div>
<?php $this->renderPartial('//common/footer');?>
</body>
</html>