<?php
$current_date = date('Y-m-d');
$condition = 'employee_id="' . $model->employee_id . '" and isActive="Y" AND valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"';
$model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount,valid_from', 'condition' => $condition));
$total_salary = 0.00;
if ($model_salary->amount > 0) {
    $total_salary = $model_salary->amount;
}
?>

<!DOCTYPE html>
<html>
    <head>
        <title>NOC-Consulate</title>

        <style>
            @import url('https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800');
            @page {

                margin-top: 1.9cm;
                margin-bottom: 0cm !important;
                margin-left: 0cm;
                margin-right: 0cm;
                header: html_myHeader;
                footer: html_myfooter;
                font-family: 'Oswald', sans-serif;


            }
            table, tr, td{
                border:solid 1px #333333;
                border-collapse: collapse;
                padding: 10px;
            }
        </style>

    </head>

    <body>
        <?php
        $model_company = MasCompanyWpsDetails::model()->findbyPK($model->employeedetail->employee_wps_company);
        $company_name = "";
        $company_address = "";
        $company_phno = "";
        $company_web_address = "";
        if (!empty($model_company)) {
            $company_name = strtoupper($model_company->company_name);
            $company_address = $model_company->company_address;
            $company_phno = $model_company->phone_number;
            $web = substr($model_company->website, 0, 3);
            if ($web != 'www') {
                $company_web_address = 'www.';
            }
            $company_web_address .= $model_company->website;
        } else {
            $model_company = MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id);
            $company_name = strtoupper($model_company->company_name);
            ;
            $company_address = $model_company->billing_address;
            $company_phno = $model_company->genral_phno;
            $web = substr($model_company->genral_web, 0, 2);
            if ($web != 'www') {
                $company_web_address = 'www.';
            }
            $company_web_address = $model_company->genral_web;
        }
        ?>
        <div class="heading" style="text-align:center;">
            <div class="logo col-1">
                <img src="uploads/profilephotos/<?php echo $model_company->company_logo; ?>" style="margin-top: 5px; width: 170px; height: 75px">
            </div>
            <h3 style="margin: 0px;padding: 0px;font-size: 24px;color: #0070c0;font-weight: bold;"><?php echo $company_name; ?></h3>
            <h6 style="font-size: 11px;font-weight:200;color: #0070c0;margin:10px 0px 0px 0px;margin-top:1px;"><?php echo $company_address; ?>; <?php echo $company_phno; ?>; <span style="text-decoration:underline;color:#0000ff;"><?php echo $company_web_address; ?></span></h6>
        </div>
        <br>

        <div>
            <p>Date: <?php echo date("d/m/Y"); ?></p>
            <p>MIS/<?php echo $ref_no; ?>/<?php echo date("Y"); ?></p>
            <p>To: <?php echo $model->embassy; ?></p>
            <p><?php echo $model->addresses_to; ?></p>
        </div>

        <br>
        <div style="text-align: center;">
            <h3><u>No Objection Certificate</u></h3>
        </div>

        <br>

        <div>
            <p>The following are the details of <b><?php echo $sign . '' . $this->ciphertext($model->employeedetail->first_name, 'd') . '' . $this->ciphertext($model->employeedetail->last_name, ''); ?></b>, Employee of <?php echo $model_company->company_name; ?>.</p>
        </div>

        <br>

        <table>
            <tr>
                <td>Date of Joining:</td>
                <td><?php echo date_format(date_create($model->employeedetail->date_join), "d/m/Y") ?></td>
            </tr>

            <tr>
                <td>Nationality:</td>
                <td><?php echo $model->employeedetail->employeenationality->nationality; ?></td>
            </tr>

            <tr>
                <td>Passport No:</td>
                <td><?php echo $model_document->document_number ?></td>
            </tr>

            <tr>
                <td>Designation:</td>
                <td><?php echo $model->employeedetail->designationdetail->designation_name; ?></td>
            </tr>

            <tr>
                <td>Basic Salary:</td>
                <td><?php echo $total_salary; ?></td>
            </tr>
        </table>

        <br>

        <div>
            <p>This is to certify that above-mentioned person is a trusted member of <?php echo $model_company->company_name; ?>.</p>
        </div>

        <br>

        <div>
            <?php
            foreach ($signature as $value) {
                echo '<h4><strong>' . $value . '</strong></h4>';
            }
            ?>
        </div>

    </body>

</html>