<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("Disable", "function Disable(id){
    var r = confirm('Are you sure to disable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=paymentterms/Disable',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    reloadTable('#tbl_paymentterm_detail');
                    t8.success('Payment Terms Disabled SuccessFully!');
                }
               }
            });
        }

};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>

<script>
    $(document).ready(function () {
        var table_id = "#tbl_paymentterm_detail";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('paymentterms/getpaymenttermlist') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //console.log(aData);

                if (aData[3] == "Y") {
                    $("td", nRow).addClass("bg-payment");

                } else {
                    $("td", nRow).addClass("bg-test");
                }
                if (aData[4].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                AddContextMenu(nRow, aData);
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;

        <?php if (isset(Yii::app()->user->havePermissionOn['paymentterm_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['paymentterm_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_disable = 1;
        <?php } ?>

        // Build menu items dynamically
        var menuItems = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['paymentterm_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal("paymentterms/create&id=" + datas[4].id, datas[4].code, "lg");
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['paymentterm_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.Disable_Enable = {
                name: (datas[4].status == "Y") ? "Disable" : "Enable",
                icon: "edit",
                accesskey: "d",
                callback: function () {
                    Disable(datas[4].id, datas[4].status);
                },
                disabled: function (key, opt) {
                    // disable if already active (Y) or other condition
                    if (String(datas[3]).trim().toUpperCase() === 'Y') {
                        return true;
                    }
                    return false;
                }
            };
        <?php } ?>

        // Attach context menu only if there is at least one menu item
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }

</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=paymentterms/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_paymentterm_detail').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-users"></i> -->
        Payment Terms
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['paymentterm_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <a class="ad-btn" onclick="loadPopupModal('paymentterms/create', 'Add New Payment Term', 'lg')" title="Add">

                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>

            <?php }
            ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_paymentterm_detail">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Payment Terms</th>
                        <th>No of Days</th>
                        <!-- <th>Base</th> -->

                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>