<?php
$cs = Yii::app()->getClientScript();
?>
<div id ="div_service_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="substitite_order_item_table">        
            <tr>            
                <th>No</th>
                <th>Product</th>        
                <th>Description</th>   
                <th>Qty</th>
                <th>Unit</th>   
                <th class="cls_td_bill_type" style="<?php echo $hiring_li_style; ?>">Bill Type</th>
                <th>Rate</th>            
                <th>Amount</th>        
                <th>Tax(%)</th>  
                <th class="bg-success text-center">+/-</th>           
                <th class="bg-danger text-center">Discount</th>           
                <th>Net</th>
                <th class="text-center">
                    <a class="btn btn-xs btn-theme" href="javascript:void(0);" onclick="addTableNewRow($('#substitite_order_item_table'));"><i class="fa fa-plus"></i></a>          
                </th>  
            </tr>
            <?php
            $model_order_item_checked = OrderItem::model()->find(array('condition' => 'order_id ="'.$model->id.'" and checked="1" and hiring_master="Y"'));
            $bill_type=$model_order_item_checked->bill_type;
            foreach ($model_order_substitute_items as $i => $substitute_items):
                $readonly=false;
                $model_item_delivered = DeliveryNoteItem::model()->find(array('condition' => 'picked_qty>0 and order_item_id="'.$substitute_items->id.'"'));
                if($model_item_delivered->id>0){
                    $readonly=true;
                }
                ?>
                <tr>                
                    <td><label><?php echo ($i + 1); ?></label></td>
                    <?php
                        $product_name = $substitute_items->product->hiring_part_number;
                    ?>
                    <td><?php
                        echo $form->textField($substitute_items, "[" . $i . "]product_name", array('class' => 'form-control', 'placeholder' => 'Type & Select',
                            'onKeyup' => 'js:autoCompleteMachine(this.id,"substitutemachine");', 'value' => $product_name, 'style' => 'width: 120px',
                            'title' => 'Select product','readonly'=>$readonly));
                        ?>                                        
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]hiring_id"); ?>  
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]id"); ?>    
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]product_id"); ?>                                    
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]product_location_hiring_id"); ?>
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]inventory_type",array('value'=>'H')); ?>
                        <?php echo CHtml::hiddenField('product[' . $i . '][inventorytype]', $product_inventory_type); ?> 
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]expected_delivery_date"); ?>
                    </td>
                    <td>
                        <div id="div_description">                
                            <?php
                                echo $form->textArea($substitute_items, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here','readonly'=>$readonly));                           
                            ?>                
                        </div>
                    </td>   
                    <td>
                        <?php echo $form->textField($substitute_items, "[" . $i . "]quantity", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatesubstituevalue($("#substitite_order_item_table"));','readonly'=>$readonly)); ?>                    
                        <a href="javascript:void(0);" class="substitutions_stockhover" id="substitutionstockhelper_<?php echo $i; ?>"><i class="fa fa-shopping-cart "><div class="triangle-right"></div></i></a>
                    </td> 
                        
                    <td id="substituteunit_<?php echo $i; ?>">
                        <?php
                        ($substitute_items->product_id > 0) ? $data = UnitOfMeasurement::getUnits($substitute_items->product_id) : $data = array();
                        ?>
                    <?php echo $form->dropdownlist($substitute_items, "[" . $i . "]unit_id", $data, array('class' => 'qty go','readonly'=>$readonly)); ?>

                    </td>
                    <td class="cls_td_bill_type">
                        <?php
                        echo $form->dropdownlist($substitute_items, "[" . $i . "]bill_type", array('1' => 'Daily', '2' => 'Weekly', '3' => 'Monthly'), array('class' => 'qty go'));
                        ?>
                    </td>
                    <td>
                        <?php echo $form->textField($substitute_items, "[" . $i . "]rate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatesubstituevalue($("#substitite_order_item_table"));','readonly'=>$readonly)); ?>                    
                    </td>  
                    <td>
                        <?php echo $form->textField($substitute_items, "[" . $i . "]amount", array('class' => 'amt go text-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true)); ?>                    
                    </td>  
                    <td>
                        <?php
                        if ($substitute_items->product_id > 0) {
                            $substitute_items->tax_vat_percentage = $substitute_items->product->tax->percentage;
                            $substitute_items->tax_vat_amount = ($substitute_items->net_amount * $substitute_items->product->tax->percentage) / 100;
                        }
                        ?>
                        <?php echo $form->textField($substitute_items, "[" . $i . "]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => true)); ?>                    
                        <?php echo $form->hiddenField($substitute_items, "[" . $i . "]tax_vat_amount"); ?>
                        <input type="hidden" id="check_subtax_vat_percentage_<?php echo $i; ?>" value="<?php echo $substitute_items->product->tax->percentage;?>" />
                    </td>                
                    <td class="bg-success nw">
                        <?php echo $form->textField($substitute_items, "[" . $i . "]addition_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatesubstituevalue($("#substitite_order_item_table"));','readonly'=>$readonly)); ?>                    
                        <?php echo $form->textField($substitute_items, "[" . $i . "]addition_amount", array('class' => 'txt-6 go exception text-right additions', 'readonly' => true)); ?>                   
                    </td>                
                    <td class="bg-danger nw">
                        <?php echo $form->textField($substitute_items, "[" . $i . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatesubstituevalue($("#substitite_order_item_table"));','readonly'=>$readonly)); ?>                                      
                        <?php echo $form->textField($substitute_items, "[" . $i . "]deduction_amount", array('class' => 'txt-6 go exception text-right deductions', 'readonly' => true)); ?>                    
                    </td>    
                    <td>
                        <?php echo $form->textField($substitute_items, "[" . $i . "]net_amount", array('class' => 'amt go text-right', 'readonly' => true)); ?>                                                  
                    </td>  


                    <td class="text-center nw" width="1%">  
                        <?php
                            echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('id'=>"tdreplacemachine_delete_".$i,'class' => 'btn btn-xs btn-danger', 'onclick' => 'removelineitem($(\'#substitite_order_item_table\'),this,this.id);', 'title' => 'Remove this item'));                        
                        ?>                
                    </td>            
                </tr>        
<?php endforeach; ?>    
        </table>
        <input type="hidden" id="checked_bill_type" name="checked_bill_type" value="<?php echo $bill_type; ?>"/>
        <input type="hidden" id="checked_rate" name="checked_rate" value="<?php echo $model_order_item_checked->rate; ?>"/>
    </div>
</div>
<?php
$cs->registerScript("autoCompleteMachine", "function autoCompleteMachine(field_id,frm)
    {
        var customer_id =$('#Order_customer_id').val();
        var order_type =$('#Order_order_type').val();
        var sales_group =$('#Order_sales_group').val();
        var application = $('#Order_hiring_application').val();
        if(customer_id==''){
            t8.error('Please select a customer'); 
            return false;
        }
        else if(order_type==''){
            t8.error('Please select a type'); 
            return false;
        }
        else{ 
            var arr_fields= field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field  = arr_fields[1];
            var all_str  = $('#'+field_id).val();
            $('#SubstituteOrderItem_'+row_field+'_quantity').attr( 'readonly', false );
            $('#SubstituteOrderItem_'+row_field+'_rate').attr( 'readonly', true);
            $('#SubstituteOrderItem_'+row_field+'_unit').attr( 'readonly', false );
            $('#SubstituteOrderItem_'+row_field+'_addition_percentage').attr( 'readonly', true);
            $('#SubstituteOrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', true);
            var url = '" . Yii::app()->createUrl('order/GetMachineProducts') . "';
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
                select          : function( event, ui ) {
                    event.preventDefault();
                    trigger_target_id  	=   $(event.target).attr('id');
                    var product_id=ui.item.value; 	
                    var desc=ui.item.description; 
                    var unit_id=ui.item.unit_id;  
                    var unit_name=ui.item.unit_name;                    
                    var tot_quantity=ui.item.total_qty;
                    var default_hour=ui.item.default_hour;
                    var hiring_id=0;
                    if(order_type=='H'){
                        var arr_others = (ui.item.other).split('##');
                        var item_type = arr_others[0];
                        hiring_id = arr_others[1];  
                        if(hiring_id>0){
                            $('#hiring_id').val(hiring_id);
                        }
                        $('#Order_default_hrs_per_day').val(default_hour);
                    }
                    else{
                      var item_type = ui.item.other;  
                      var product_location_hiring_id=ui.item.pdt_loc_hiring;
                      var salesgp_type=ui.item.serialno;
                      $('#salesgp_type').val(salesgp_type);
                    }
                    var tax_percentage = 0;
                    if(ui.item.tax_code!=null)
                        tax_percentage = ui.item.tax_code.percentage;
                    $('#SubstituteOrderItem_'+row_field+'_description').val(desc);
                    $('#SubstituteOrderItem_'+row_field+'_product_location_hiring_id').val(product_location_hiring_id);
                    $('#SubstituteOrderItem_'+row_field+'_unit').val(unit_name); 
                    $('#SubstituteOrderItem_'+row_field+'_product_name').val(ui.item.part_number); 
                    $('#SubstituteOrderItem_'+row_field+'_unit_id').val(unit_id);  
                    $('#SubstituteOrderItem_'+row_field+'_product_id').val(product_id);
                    $('#SubstituteOrderItem_'+row_field+'_quantity').val(tot_quantity);
                    $('#SubstituteOrderItem_'+row_field+'_bill_type').val($('#checked_bill_type').val());
                    $('#SubstituteOrderItem_'+row_field+'_quantity').focus();
                    var item_type = ui.item.other;
                    $('#product_'+row_field+'_inventorytype').val(item_type); 
                    if(product_id > 0){
                        jQuery.ajax({
                           'type': 'post',
                           'dataType': 'json',
                           'url': '" . Yii::app()->createUrl('order/getunitdrop') . "',
                           'data': {'row_field' : row_field, 'product_id' : product_id},
                           'cache': false,
                           'success': function(data) {
                               $('#substituteunit_'+row_field).html(data.drop);
                               return false;
                           }
                        });
                        var exchange_rate = $('#Order_exchange_rate').val();
                        $('#SubstituteOrderItem_'+row_field+'_rate').val($('#checked_rate').val());
                    }                     
                    var Order_invoice_type_id  = $('#Order_invoice_type').val(); 
                    if(Order_invoice_type_id>0){

                        jQuery.ajax({
                            'dataType' : 'json',
                            'type'  : 'post',
                            'data'  : 'id='+Order_invoice_type_id,
                            'url'  : $('#liveSite').val()+'index.php?r=masinvoicetype/getInvoiceTypeTax',
                            'cache': false,
                            'success':function(data){

                                if(data.status=='success'){ 
                                    if(item_type == '2'){  // itemtype = 2 means service items
                                        $('#SubstituteOrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                $('#check_subtax_vat_percentage_'+row_field).val(tax_percentage);
                                        calculatesubstituevalue($('#substitite_order_item_table'));
                                    }
                                    else{
                                        if(data.tax == 'Y'){
                                                $('#SubstituteOrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                $('#check_subtax_vat_percentage_'+row_field).val(tax_percentage); 
                                            }
                                        else{
                                            $('#SubstituteOrderItem_'+row_field+'_tax_vat_percentage').val(0);
                                                $('#check_subtax_vat_percentage_'+row_field).val(tax_percentage); 
                                        }
                                        calculatesubstituevalue($('#substitite_order_item_table'));
                                    }
                                }
                            }
                        });
                    }
                }
            })
        }
    }", CClientScript::POS_HEAD);
$cs->registerScript("calculatesubstituevalue", " function calculatesubstituevalue(jQtable,frm) {
        formIdStarter =   jQtable.attr('id').split(/_(.+)?/)[0];
        var count,qty,rate,amount,add_ded,discount,net,count_hash;
        var other_additions = 0;
        var other_deductions = 0;
        var total = 0;
        var grand_total =   0;
        var total_vat_amount	= 0;
        var vat_percentage  = $('#Order_vat_percentage').val();
        var order_type =$('#Order_order_type').val();
        jQtable.find('tr:gt(0)').each(function() {
            net = 0;
            qty =   $(this).find('[id $=_quantity]').val();
            rate =   $(this).find('[id $=_rate]').val();
            amount  =   (Number(qty)*Number(rate)).toFixed(2);
            add_ded  =   $(this).find('[id $=_addition_percentage]').val();
            discount  =   $(this).find('[id $=_deduction_percentage]').val();
            if(add_ded === '-' || add_ded === '*'){
                add_ded = '';
            }
            if(add_ded!=undefined)
            {
                count = add_ded.match(/%/g);
                count_hash=add_ded.match(/#/g);
                add_ded   =   add_ded.replace(/#/,'');
                add_ded   =   add_ded.replace(/%/,'');              
                var value = Number(add_ded)/100;
            }                   
            if(isNumber(add_ded)){
                add_ded  =   (count!==null && count.length>0) ? (amount*value) : add_ded;
                add_ded  =   (count_hash!==null && count_hash.length>0) ? (Number(add_ded)*qty) : add_ded;
            }
            if(discount!=undefined)
            {
                count = discount.match(/%/g);
                discount   =   discount.replace(/%/,'');
                var value = Number(discount)/100;
            }
            if(isNumber(discount))
                discount  =  (count!==null && count.length>0) ? ((Number(add_ded)+Number(amount))*value) : discount;
            net =   Number(add_ded) - Number(discount);
            net =   (Number(net)+Number(amount)).toFixed(2);
            if(net != 0){
                total   =   Number(total)+Number(net);
            }
            else{
                total   =   Number(total);
            }
            $(this).find('[id $=_amount]').val(Number(amount).toFixed(2));
            if($(this).find('[id $=_tax_vat_percentage]').length > 0){
                tax_percentage = $(this).find('[id $=_tax_vat_percentage]').val();
                var  tax_amount = (net * tax_percentage) / 100;
                $(this).find('[id $=_tax_vat_amount]').val(Number(tax_amount).toFixed(2));
                total_vat_amount+=tax_amount;
            }
            $(this).find('[id $=_addition_amount]').val(Number(add_ded).toFixed(2));
            $(this).find('[id $=_deduction_amount]').val(Number(discount).toFixed(2));
            $(this).find('[id $=_net_amount]').val(Number(net).toFixed(2));
        });
        return false;
    }", CClientScript::POS_HEAD);
$cs->registerScript("addTableNewRow", " function addTableNewRow(jQtable) {
        formId              =   jQtable.attr('id');
        formIdStarter       =   jQtable.attr('id').split(/_(.+)?/)[0];
        lastId = jQtable.find('tr:last input:first').attr('id');
        thenum = lastId.match(/\d+/g);
        newId = Number(thenum) + 1;
        newrow= jQtable.find('tr:last').clone();
        newrow.find('label:first').html(newId+1);
        newrow.attr('class',newId);
        newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a').each(function() {
        this.id= this.id.replace(/\d+/,newId);
        if(!$(this).is(':checkbox'))
            this.value  = '';
        else
            $(this).prop('checked', false);
        (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   '';});
        jQtable.append(newrow);
        $('#SubstituteOrderItem_'+newId+'_bill_type').val($('#checked_bill_type').val());
        $('#SubstituteOrderItem_'+newId+'_product_name').attr( 'readonly', false );
        $('#SubstituteOrderItem_'+newId+'_description').attr( 'readonly', false );
        if($('#SubstituteOrderItem_'+newId+'_addition_percentage').length > 0){
             $('#SubstituteOrderItem_'+newId+'_addition_percentage').val(0);
        }
        if($('#SubstituteOrderItem_'+newId+'_deduction_percentage').length > 0){
             $('#SubstituteOrderItem_'+newId+'_deduction_percentage').val(0);
        }
        if($('#SubstituteOrderItem_'+newId+'_addition_amount').length > 0){
             $('#SubstituteOrderItem_'+newId+'_addition_amount').val('0.00');
        }

        if($('#SubstituteOrderItem_'+newId+'_deduction_amount').length > 0){
             $('#SubstituteOrderItem_'+newId+'_deduction_amount').val('0.00');
        }
}", CClientScript::POS_HEAD);
$cs->registerScript("removelineitem", " function removelineitem(jQtable,evt,field_id) {
            var arr_fields= field_id.split('_');
            var row_field=arr_fields[2];
            var id=$('#SubstituteOrderItem_'+row_field+'_id').val();
            formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows    =   jQtable.find('tr:gt(0)').length;
            if(num_rows>1){
            var tr  =   $(evt).parent().parent();
            if(isRowEmpty(tr)) {
                if(id!=''){
                    jQuery.ajax({
                        'type': 'post',
                        'dataType': 'json',
                        'url': '" . Yii::app()->createUrl('order/removereplacedmachine') . "',
                        'data': {'id':id} ,
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() {
                                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                    {
                                        old_id = $(this).attr('id');
                                        if(old_id!==undefined) {
                                            new_id = old_id.replace(/\d+/,i);
                                            $(this).attr('id',new_id);
                                        }
                                        old_name = $(this).attr('name');
                                        if(old_name!==undefined) {
                                            new_name = old_name.replace(/\d+/,i);
                                            $(this).attr('name',new_name);
                                        }
                                    });
                                    $(this).find('td:first label').html(++i);
                                });
                                t8.success('Deleted');
                            }else if(data.status=='convert'){
                                t8.error('Deletion Not Possible, Machine Delivered');
                            }else{
                                t8.error('Error in Deletion');
                            }
                        }
                    });
                }else{
                    $(evt).parents('tr').remove();
                    var i=0;
                    jQtable.find('tr:gt(0)').each(function() {
                        $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                        {
                            old_id = $(this).attr('id');
                            if(old_id!==undefined) {
                                new_id = old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                            }
                            old_name = $(this).attr('name');
                            if(old_name!==undefined) {
                                new_name = old_name.replace(/\d+/,i);
                                $(this).attr('name',new_name);
                            }
                        });
                        $(this).find('td:first label').html(++i);
                    });
                }
            }
        }else {
            alert('Atleast one item needed here');
        }
    }", CClientScript::POS_HEAD);
?>

<style type="text/css">
    body table .desc, body table .desc.go {
        min-width: 170px;
    }
</style>

<script>
    $(document).bind("keydown", function (event) {

        var allclass = $(event.target).attr("class");
        var substring = 'en-text-area';
        var id = $(event.target).attr("id");

        if (allclass.indexOf(substring) !== -1) {

            try {
                if (event.which == 13) {
                    document.getElementById(id).value = document.getElementById(id).value;
                }
            } catch (e) {
            }
        } else if (event.keyCode == 13) {
            return false;
        }
    });

    $(document).ready(function () {

        $('.substitutions_stockhover').popover({
            title: '<b>Available Qty</b>',
            html: true,
            placement: 'right',
            trigger: 'hover',
            content: popoverContent
        });


    });

    function popoverContent() {

        var content = '';
        var element = $(this);
        var id = element.attr("id");
        content = "";
        var arr_fields = id.split('_');
        var row_field = arr_fields[1];
        var id = $('#SubstituteOrderItem_' + row_field + '_product_id').val();
        var qtn_type = $('#Order_order_type').val();
        jQuery.ajax({
            'type': 'post',
            'url': "<?php echo Yii::app()->createUrl('inventory/GetAvaibaleQty') ?>",
            'data': {'id': id, 'type': qtn_type},
            'cache': false,
            'async': false,
            'success': function (retdata) {
                content = retdata;
            }
        });

        return content;


    }
</script>
