<?php
$condition = "job.customer_id =  " . $orderModel->customer_id;
$jobLogArray = SalesRequestLog::model()->with('job')->findAll([
    "condition" => $condition
        ]
);
?>
<div class="panel-body">
    <div class="table-responsive">
        <table   class="table table-fixed table-bordered table-primaryy datatable html_table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Job No</th>
                    <th>Outlet</th>
                    <th>Actual Date</th>
                    <th>Technician</th>
                    <th>Service Type</th>
                    <th>Start Time</th>
                    <th>End Time</th>
                    <th>Total Time</th>
                </tr>
            </thead>
            <tbody>
                <?php
                foreach ($jobLogArray as $key => $logModel) {
                    $jobSheetModel = $logModel->job;
                    $startDate = DateTime::createFromFormat("Y-m-d H:i:s", $logModel->start_date . " " . $logModel->start_time);
                    $endDate = DateTime::createFromFormat("Y-m-d H:i:s", $logModel->end_date . " " . $logModel->end_time);
                    $totalTime = "";
                    if (!is_bool($startDate) && !is_bool($endDate)) {
                        $interval = $startDate->diff($endDate);
//                        $totalTime = $interval->format('%d Days %h:%i:%s');
                        $totalHours = $interval->d * 24 + $interval->h;          // Days to hours
                        $totalTime = $totalHours . ":" . $interval->format('%i:%s');
                    }
                    ?>
                    <tr>
                        <td>
                            <?php echo ($key + 1) ?>
                        </td>
                        <td>
                            <?php echo $jobSheetModel->id ?>
                        </td>
                        <td>
                            <?php echo $jobSheetModel->customer_outlet->shipping_customer_name ?>
                        </td>
                        <td>
                            <?php echo date("d/m/Y", strtotime($logModel->start_date)) ?>

                        </td>
                        <td>
                            <?php echo $jobSheetModel->assigned->getFullName(); ?>
                        </td>
                        <td>
                            <?php echo $jobSheetModel->service->name ?>
                        </td>
                        <td>
                            <?php echo date("d/m/Y", strtotime($logModel->start_date)) ?>
                            <?php echo date("h:i a", strtotime($logModel->start_time)) ?>
                        </td>
                        <td>
                            <?php
                            if ($logModel->end_date != '0000-00-00') {
                                echo date("d/m/Y", strtotime($logModel->end_date)) . ' ' . date("h:i a", strtotime($logModel->end_time));
                            } else {
                                $totalTime = "";
                            }
                            ?>
                        </td>
                        <td>
                            <?php echo $totalTime; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>
