<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_order_table" class="table table-fixed table-bordered table-primaryy datatable html_table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Issue Date</th>
                    <!--<th>Technician</th>-->
                    <!--<th>Type</th>-->
                    <th>Fragrance</th>
                    <th>Description</th>
                    <th class="text-right">Quantity</th>
                    <th class="text-right">Unit</th>

                </tr>
            </thead>
            <tbody>
                <?php
                $customer_id = $orderModel->customer_id;
                $condition = "t.customer_vendor_id = " . $customer_id . " AND product.inventory_item_type IN (1,3) AND transaction_from= 'OIL_USED'  ";
                $ledgerList = StockLedger::model()->with('product')->findAll(
                        [
                            "condition" => $condition,
                            "order" => "transaction_date desc"
                        ]
                );
                foreach ($ledgerList as $key => $ledgerModel) {
                    ?>
                    <tr>
                        <td>
                            <?php echo $key + 1; ?>
                        </td>
                        <td>
                            <?php echo date("d/m/Y", strtotime($ledgerModel->transaction_date)); ?>
                        </td>
    <!--                        <td>
                        <?php // echo empty($ledgerModel->user) ? "" : $ledgerModel->user->getFullName(); ?>
                        </td>-->
                        <td>
                            <?php echo $ledgerModel->product_name ?>
                        </td>
                        <td>
                            <?php echo $ledgerModel->product_description ?>
                        </td>
                        <td class="text-right">
                            <?php echo number_format(abs(floatval($ledgerModel->quantity)), 2); ?>
                        </td>
                        <td class="text-right">
                            <?php echo $ledgerModel->product->unit->symbol; ?>
                        </td>

                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
        <br>
    </div>
</div>