<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_order_table" class="table table-fixed table-bordered table-primaryy datatable html_table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Job No</th>
                    <!--<th>Service Order</th>-->
                    <th>Issue Date</th>
                    <!--<th>Type</th>-->
                    <th>Machine</th>
                    <th>Serial Number</th>
                    <th>Description</th>
                    <th>Technician</th>
                    <th>Outlet</th>
                    <th>Location</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $customer_id = $orderModel->customer_id;
                $from_date = DateTime::createFromFormat('d/m/Y', $from_date);
                $to_date = DateTime::createFromFormat('d/m/Y', $to_date);
                $model = new InventoryGoodsIssue();
                $criteria = new CDbCriteria;
//                $criteria->condition = 't.issue_type = "MH" AND t.production_order_id = ' . $orderModel->id;
                $criteria->condition = 't.issue_type = "MH" AND t.customer_id = ' . $orderModel->customer_id;
                //$criteria->params = $params;
                $criteria->order = 't.id';
                $criteria->with = array('customer', 'items', 'outlet', 'owner');
                $criteria->together = true;
                $recordsTotal = $model->count($criteria);
                $rows = $model->findAll($criteria);
                foreach ($rows as $i => $model) {
                    $sales_group_id = Order::model()->findByPk($model->production_order_id)->sales_group_id;
//                    $contract_type = isset($sales_group_id) ? MasSalesGroup::model()->findByPk($sales_group_id)->group_name : '';
                    $assigned_user = isset($model->lead_owner_id) ? $model->owner->first_name . ' ' . $model->owner->last_name : '';
                    $locations = ServiceCustomerLocation::getLocation($model->customer_id);
                    ?>
                    <tr>
                        <td><?php echo $i + 1; ?></td>
                        <td><?php echo $model->id; ?></td>
                        <!--<td class="nw"><?php echo $model->production_order_id; ?></td>-->

                        <?php if ($model->goods_issue_date != '0000-00-00') { ?>
                            <td><?php echo date("d/m/Y", strtotime($model->goods_issue_date)); ?></td>
                        <?php } else { ?>
                            <td>&nbsp;</td>
                        <?php } ?>

            <!--                        <td><?php echo $contract_type; ?></td>-->

                        <td><?php echo $model->items[0]->product_name; ?></td>
                        <td><?php echo $model->items[0]->serial_no; ?></td>
                        <td><?php echo $model->items[0]->description; ?></td>
                        <td class="nw"><?php echo $assigned_user; ?></td>
                        <td>
                            <?php
                            $outlets = CustomerOutletLocation::getShippingLocation($model->customer_id);
                            echo $outlets[$model->outlet_id];
                            ?>
                        </td>

                        <td><?php echo $locations[$model->items[0]->location_id]; ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table><br>
    </div>
</div>

<div class="panel-heading panel-theme clearfix report-head">Returned Machines</div>
<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_order_table" class="table table-fixed table-bordered table-primaryy datatable html_table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Job No</th>
                    <th>Issue Date</th>
                    <th>Machine</th>
                    <th>Serial Number</th>
                    <th>Description</th>
                    <th>Technician</th>
                    <th>Outlet</th>
                    <th>Location</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $model = new InventoryGoodsReceipt();
                $criteria = new CDbCriteria;
//                $criteria->condition = 't.receipt_type = "MH" AND t.reference_id = ' . $orderModel->id;
                $criteria->condition = 't.receipt_type = "MH" AND t.customer_id = ' . $orderModel->customer_id;
                //$criteria->params = $params;
                $criteria->order = 't.id';
                $criteria->with = array('customer', 'items', 'outlet', 'owner');
                $criteria->together = true;
                $recordsTotal = $model->count($criteria);
                $rows = $model->findAll($criteria);
                foreach ($rows as $i => $model) {
                    $sales_group_id = Order::model()->findByPk($model->reference_id)->sales_group_id;
                    $contract_type = isset($sales_group_id) ? MasSalesGroup::model()->findByPk($sales_group_id)->group_name : '';
                    $assigned_user = isset($model->lead_owner_id) ? $model->owner->first_name . ' ' . $model->owner->last_name : '';
                    $locations = ServiceCustomerLocation::getLocation($model->customer_id);
                    ?>
                    <tr>
                        <td><?php echo $i + 1; ?></td>
                        <td><?php echo $model->id; ?></td>

                        <?php if ($model->goods_receipt_date != '0000-00-00') { ?>
                            <td><?php echo date("d/m/Y", strtotime($model->goods_receipt_date)); ?></td>
                        <?php } else { ?>
                            <td>&nbsp;</td>
                        <?php } ?>
                        <td><?php echo $model->items[0]->product_name; ?></td>
                        <td><?php echo $model->items[0]->serial_no; ?></td>
                        <td><?php echo $model->items[0]->description; ?></td>


                        <td class="nw"><?php echo $assigned_user; ?></td>

                        <td>
                            <?php
                            $outlets = CustomerOutletLocation::getShippingLocation($model->customer_id);
                            echo $outlets[$model->outlet_id];
                            ?>
                        </td>

                        <td><?php echo $locations[$model->items[0]->location_id]; ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table><br>
    </div>
</div>