<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<?php
$model_settings = new MasCompanySettings();
$crm_login_company_id = Yii::app()->user->master_user_company_id;
$model_settings = $model_settings->find(array('condition' => 'crm_company_id=' . $crm_login_company_id));
$allow_change = $model_settings->allow_change_description;
$bonus_quantity = $model_settings->bonus_quantity;

if ($model->id == '') {
    $status = true;
}
?>

<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="hiring_item_table">
        <tr>
           <?php if($model->approved_level>=2): ?>  <th>No</th> <?php endif; ?>
            <th>Product</th>
            <th>Description</th>
            <th>Quantity</th>
            <?php if ($bonus_quantity == "Y") { ?>
                <th>Bonus Qty</th>
            <?php } ?>
            <th>Unit</th>
            <th>Unit Price</th>
            <th>Amount</th>
            <th>Tax(%)</th>
            <th class="bg-success text-center">+/-</th>
            <th class="bg-danger text-center">Discount</th>
            <th>Net</th>
            <th class="text-center">
                <a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addTableRow($('#hiring_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>

        <?php
        $j = 0;
        $show_extra_tr=0;
        foreach ($modelOrderHiringItems as $i => $modelOrderHiringItems):
            if($modelOrderHiringItems->hiringorderitem->type==4 || $modelOrderHiringItems->hiring_item_id==0 || $model->approved_level>=2){
                $show_extra_tr=1;
                $bgcolor="";
             if($modelOrderHiringItems->hiringorderitem->type==4 || $modelOrderHiringItems->hiring_item_id==0){
                 $bgcolor="#e6ffff";
             }
            ?>
            <tr class="<?php echo $i; ?>  vis_hiring"  bgcolor="<?php echo $bgcolor;?>">
                <?php
                $product_inventory_type = 1;

                $status = true;
                $product_name = '';
                if ($modelOrderHiringItems->product_id > 0) {
                    $modelHiring = HiringItems::model()->findByPk($modelOrderHiringItems->hiring_item_id);
                    //$product_name = $modelHiring->part_number;
                    $product_name=$modelOrderHiringItems->product->hiring_part_number;
                }
                ?>
                <?php if($model->approved_level>=2): ?> <td><label><?php echo ($i + 1); ?></label></td><?php endif; ?>
                <td>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]product_name", array('class' => 'tooltipster go', 'value' => $product_name, 'placeholder' => 'Type & Select', 'onKeyup' => 'js:autoCompleteHiringProduct(this.id,"order");', 'title' => 'Select product')); ?>
                    <?php echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]product_id"); ?>
                    <?php echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]id"); ?>
                    <?php echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]hiring_item_id"); ?>
                    <?php echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]hiring_id"); ?>
                    <?php echo CHtml::hiddenField('product[' . $j . '][inventorytype]', $product_inventory_type); ?>
                </td>
                <td>
                    <?php
                    if ($allow_change == "N") {
                        echo CHtml::activeTextArea($modelOrderHiringItems, "[" . $j . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                    } else {
                        echo CHtml::activeTextArea($modelOrderHiringItems, "[" . $j . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                    }
                    ?>
                </td>
                <td>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'nextline(event)', 'onkeyup' => 'calculateHiringOrderValue($("#hiring_item_table"));', 'readonly' => $disabled)); ?>
                </td>
                <?php if ($bonus_quantity == "Y") { ?>
                    <td>
                        <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]bonus_qty", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'nextline(event)', 'readonly' => $disabled)); ?>
                    </td>
                <?php } ?>

                <td id="unit_<?php echo $j; ?>">
                    <?php
                    ($modelOrderHiringItems->product_id > 0) ? $data = UnitOfMeasurement::getUnits($modelOrderHiringItems->product_id) : $data = array();
                    ?>
                    <?php echo CHtml::activeDropdownlist($modelOrderHiringItems, "[" . $j . "]unit_id", $data, array('class' => 'qty go')); ?>

                </td>

                <td>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]rate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeydown' => 'nextline(event)', 'onkeyup' => 'calculateHiringOrderValue($("#hiring_item_table"));', 'readonly' => $disabled)); ?>
                </td>
                <td>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]amount", array('class' => 'amt go text-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true, 'disabled' => $disabled)); ?>
                </td>
                <td>
                    <?php
                    if ($modelOrderHiringItems->product_id > 0) {
                        $modelOrderHiringItems->tax_vat_percentage = $modelOrderHiringItems->product->tax->percentage;
                        $modelOrderHiringItems->tax_vat_amount = ($modelOrderHiringItems->net_amount * $modelOrderHiringItems->tax_vat_percentage) / 100;
                        $model->total_tax_amount += $modelOrderHiringItems->tax_vat_amount;
                    }
                    ?>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => true)); ?>                    
                    <?php echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]tax_vat_amount"); ?>
                    <input type="hidden" id="check_tax_vat_percentage_hiring_<?php echo $j; ?>" value="<?php echo $modelOrderHiringItems->product->tax->percentage; ?>" />

                </td>
                <td class="bg-success nw">

                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]addition_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateHiringOrderValue($("#hiring_item_table"),this.id);', 'disabled' => $disabled)); ?>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]addition_amount", array('class' => 'txt-6 go exception text-right additions', 'readonly' => true, 'disabled' => $disabled)); ?>

                </td>
                <td class="bg-danger nw">

                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateHiringOrderValue($("#hiring_item_table"),this.id);', 'disabled' => $disabled)); ?>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]deduction_amount", array('class' => 'txt-6 go exception text-right deductions', 'readonly' => true, 'disabled' => $disabled)); ?>

                </td>
                <td>
                    <?php echo CHtml::activeTextField($modelOrderHiringItems, "[" . $j . "]net_amount", array('class' => 'amt go text-right', 'readonly' => true, 'disabled' => $disabled)); ?>
                    <?php
                    //if ($modelOrderHiringItems->checked == 1) {
                    $total += $modelOrderHiringItems->net_amount;
                    $total_vat += $modelOrderHiringItems->tax_vat_amount;
                    // }
                    ?>
                </td>
                <td class="text-center nw" width="1%">
                    <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('id' => 'delhire_' . $j, 'class' => 'btn btn-xs btn-danger', 'onclick' => 'removeTableRowhiring($(\'#hiring_item_table\'),this,this.id);', 'title' => 'Remove this item')); ?>
                </td>
            </tr>
            <?php
            }else{
                if($modelOrderHiringItems->rate==''){
                    $modelOrderHiringItems->rate=0.00;
                }
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]id");
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]product_id"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]hiring_id");
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]hiring_item_id"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]description"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]quantity"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]unit_id"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]rate"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]amount"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]tax_vat_percentage"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]tax_vat_amount"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]addition_percentage"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]addition_amount"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]deduction_percentage"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]deduction_amount"); 
                echo CHtml::activeHiddenField($modelOrderHiringItems, "[" . $j . "]net_amount");  
            }
            $j++;
        endforeach;
        ?>
        <?php
            if ($show_extra_tr==0) {
                $model_hiring_items=new HiringOrderItem();
                $j=$j+1;
                ?>
                  <tr class="<?php echo $j; ?> vis_hiring">
                    <!--<td><label><?php echo ($slno + 1); ?></label></td>-->
                    <td>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]product_name", array('class' => 'tooltipster go', 'value' => $value, 'placeholder' => 'Type & Select', 'onKeyup' => 'js:autoCompleteHiringProduct(this.id,"quotation");', 'title' => 'Select product')); ?>
                        <?php echo CHtml::activeHiddenField($model_hiring_items, "[" . $j . "]product_id"); ?>
                        <?php echo CHtml::activeHiddenField($model_hiring_items, "[" . $j . "]id"); ?>
                        <?php echo CHtml::activeHiddenField($model_hiring_items, "[" . $j . "]hiring_item_id"); ?>
                        <?php echo CHtml::activeHiddenField($model_hiring_items, "[" . $j . "]hiring_id"); ?>
                        <?php echo CHtml::hiddenField('product[' . $j . '][inventorytype]', 1); ?>
                    </td>
                    <td>
                        <?php
                        if ($allow_change == "N") {
                            echo CHtml::activeTextArea($model_hiring_items, "[" . $j . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                        } else {
                            echo CHtml::activeTextArea($model_hiring_items, "[" . $j . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                        }
                        ?>
                    </td>
                    <td>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'nextline(event)', 'onkeyup' => 'calculateHiringQuoteValue($("#hiring_item_table"));', 'readonly' => $disabled)); ?>
                    </td>
                    <?php if ($bonus_quantity == "Y") { ?>
                        <td>
                            <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j. "]bonus_qty", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'nextline(event)', 'readonly' => $disabled)); ?>
                        </td>
                    <?php } ?>

                    <td id="unit_<?php echo $j; ?>">
                        <?php echo CHtml::activeDropdownlist($model_hiring_items, "[" . $j . "]unit_id", $data, array('class' => 'qty go')); ?>

                    </td>
                     <td>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]rate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeydown' => 'nextline(event)', 'onkeyup' => 'calculateHiringOrderValue($("#hiring_item_table"));', 'readonly' => $disabled)); ?>
                    </td>
                    <td>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]amount", array('class' => 'amt go text-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true, 'disabled' => $disabled)); ?>
                    </td>
                    <td>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => true)); ?>                    
                        <?php echo CHtml::activeHiddenField($model_hiring_items, "[" . $j . "]tax_vat_amount"); ?>
                        <input type="hidden" id="check_tax_vat_percentage_hiring_<?php echo $j; ?>" value="<?php echo $model_hiring_items->tax_vat_percentage; ?>" />

                    </td>
                    <td class="bg-success nw">

                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]addition_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateHiringQuoteValue($("#hiring_item_table"),this.id);', 'disabled' => $disabled)); ?>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]addition_amount", array('class' => 'txt-6 go exception text-right additions', 'readonly' => true, 'disabled' => $disabled)); ?>

                    </td>
                    <td class="bg-danger nw">

                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateHiringQuoteValue($("#hiring_item_table"),this.id);', 'disabled' => $disabled)); ?>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]deduction_amount", array('class' => 'txt-6 go exception text-right deductions', 'readonly' => true, 'disabled' => $disabled)); ?>

                    </td>
                    <td>
                        <?php echo CHtml::activeTextField($model_hiring_items, "[" . $j . "]net_amount", array('class' => 'amt go text-right', 'readonly' => true, 'disabled' => $disabled)); ?>                       
                    </td>
                    <td class="text-center nw" width="1%">
                        <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('id' => 'delhire_' . $j, 'class' => 'btn btn-xs btn-danger', 'onclick' => 'removeTableRowhiring($(\'#hiring_item_table\'),this,this.id);', 'title' => 'Remove this item')); ?>
                    </td>
                </tr>
                <?php
                
            }        
        ?>
    </table>

    <table class="table table-hover table-bordered table-nexted hiring_total">
        <tr class="bg-total">
            <td width="70%" class="text-right table_total_title">
                <h2>Total</h2>
            </td>
            <td width="30%" class="text-right table_total ">
                <h2 class="text-right hiring_total"><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></h2>
            </td>
        </tr>
    </table>
<?php $grand_total = $total; ?>

    <table class="table table-hover table-bordered table-nexted hiring_grand_total">
        <tr class="summary_tr total_val">
            <td class="text-right table_total_title" width="70%">
                <h1>VAT</h1></td>
            <td width="30%" class="text-right table_total">
                <h1 class="hiring_vat_total_val cell-right">
                    <?php
                    echo Yii::app()->numberFormatter->formatCurrency($total_vat, " ");
                    $grand_total += $total_vat;
                    ?>
                </h1>
            </td>
        </tr>
        <tr class="summary_tr bg-total">
            <td width="70%" class="text-right table_total_title">
                <h1>Grand Total</h1>
            </td>
            <td width="30%" class="text-right table_total">
                <h1 class="hiring_grandtotal text-right">
<?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); ?>
                </h1>
            </td>
        </tr>
    </table>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteHiringProduct", "function autoCompleteHiringProduct(field_id,frm)
    {
        var customer_id =$('#Order_customer_id').val();
        var order_type =$('#Order_order_type').val();
        var application = $('#Order_hiring_application').val();
        if(customer_id==''){
            t8.error('Please select a customer'); 
            return false;
        }
        else if(order_type==''){
            t8.error('Please select a Order Type'); 
            return false;
        }
        else{ 
            var allow_change =$('#allow_change').val();
            var arr_fields= field_id.split('_');
            var model_name = arr_fields[0];
            var row_field = arr_fields[1];
            var all_str = $('#'+field_id).val();
            if(all_str == 'memo'){
                $('#HiringOrderItem_'+row_field+'_quantity').attr( 'readonly', true );
                $('#HiringOrderItem_'+row_field+'_rate').attr( 'readonly', true );
                $('#HiringOrderItem_'+row_field+'_unit').attr( 'readonly', true );
                $('#HiringOrderItem_'+row_field+'_addition_percentage').attr( 'readonly', true );
                $('#HiringOrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', true );
                $('#HiringOrderItem_'+row_field+'_description').attr( 'readonly', false );
                $('#HiringOrderItem_'+row_field+'_description').val('');
                $('#HiringOrderItem_'+row_field+'_quantity').val('');
                $('#HiringOrderItem_'+row_field+'_unit').val('');
                $('#HiringOrderItem_'+row_field+'_addition_percentage').val('');
                $('#HiringOrderItem_'+row_field+'_deduction_percentage').val('');
                $('#HiringOrderItem_'+row_field+'_addition_amount').val('');
                $('#HiringOrderItem_'+row_field+'_deduction_amount').val('');
                $('#HiringOrderItem_'+row_field+'_product_id').val('');
                $('#HiringOrderItem_'+row_field+'_product_id').val('');   /////////////////// Product ID Reset ///////////////////////////
            
            }else{
                
                $('#HiringOrderItem_'+row_field+'_quantity').attr( 'readonly', false );
                $('#HiringOrderItem_'+row_field+'_rate').attr( 'readonly', false );
                $('#HiringOrderItem_'+row_field+'_unit').attr( 'readonly', false );
                $('#HiringOrderItem_'+row_field+'_addition_percentage').attr( 'readonly', false );
                $('#HiringOrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', false ); 
                $('#HiringOrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', false );
                

                var url = '" . Yii::app()->createUrl('quotation/GetInventoryHiringProducts') . "'+'&customer_id='+customer_id+'&qtn_type='+order_type+'&application='+application+'&frm=orderhireitem';
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response,url) },
                    focus       : function( event, ui ) { },
                    select      : function( event, ui ) {
                        event.preventDefault();
                        trigger_target_id   =   $(event.target).attr('id');
                        var product_id=ui.item.value;
                        var product_name=ui.item.part_number;
                        var desc=ui.item.description;
                        var unit_id=ui.item.unit_id;
                        var unit_name=ui.item.unit_name;
                        var tot_quantity=ui.item.total_qty;
                        var hiring_id=0;
                        if(order_type=='H'){
                            var arr_others = (ui.item.other).split('##');
                            var item_type = arr_others[0];
                            hiring_id = arr_others[1];
                        }
                        else{
                          var item_type = ui.item.other;  
                        }

                        var tax_percentage = 0;
                        if(ui.item.tax_code!=null)
                            tax_percentage = ui.item.tax_code.percentage;
                        $('#HiringOrderItem_'+row_field+'_product_name').val(product_name);
                        $('#HiringOrderItem_'+row_field+'_description').val(desc);

                        // if(allow_change=='N'){
                        //   $('#HiringOrderItem_'+row_field+'_description').attr( 'readonly', true );                               
                        // }

                        $('#product_'+row_field+'_inventorytype').val(item_type); 

                        $('#HiringOrderItem_'+row_field+'_unit_id').val(unit_id); //for showing hidden field
                        $('#HiringOrderItem_'+row_field+'_unit').val(unit_name); //FOR SHOWING UNIT NAME
                        $('#HiringOrderItem_'+row_field+'_product_id').val(product_id);
                        var Order_invoice_type_id  = $('#Order_invoice_type').val();
                        $('#HiringOrderItem_'+row_field+'_quantity').val(tot_quantity);
                        $('#HiringOrderItem_'+row_field+'_quantity').focus();

                        if(product_id > 0){
                            jQuery.ajax({
                                'type': 'post',
                                'dataType': 'json',
                                'url': '" . Yii::app()->createUrl('order/getunitdrop') . "',
                                'data': {'row_field' : row_field, 'product_id' : product_id,'type' : 2},
                                'cache': false,
                                'success': function(data) {
                                    $('#unit_'+row_field).html(data.drop);
                                    return false;
                                }
                            });
                            var exchange_rate = $('#Order_exchange_rate').val();
                            jQuery.ajax({
                               'type': 'post',
                               'dataType': 'json',
                               'url': '" . Yii::app()->createUrl('quotation/getalldetailsforproduct') . "',
                               'data': {'product_id' : product_id,'customer_id':customer_id},
                               'cache': false,
                               'success': function(data) {
                                    var item_price=data.price;
                                    if(exchange_rate > 0){
                                    item_price = (item_price / exchange_rate).toFixed(3);
                                   }
                                    $('#HiringOrderItem_'+row_field+'_rate').val(item_price);
                                    if(item_price>0){
                                         $('#HiringOrderItem_'+row_field+'_rate').attr( 'readonly', true );  
                                    }
                                   calculateHiringOrderValue($('#hiring_item_table'));
                                   return false;
                               }
                            });

                        }
                        if(Order_invoice_type_id>0){
                            jQuery.ajax({
                                'dataType'  : 'json',
                                'type'      : 'post',
                                'data'      : 'id='+Order_invoice_type_id,
                                'url'       : $('#liveSite').val()+'index.php?r=masinvoicetype/getInvoiceTypeTax',
                                'cache'     : false,
                                'success'   :function(data){
                                    if(data.status=='success'){ 

                                        if(item_type == '2'){  // itemtype = 2 means service items
                                            $('#HiringOrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                            $('#checkhiring_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                             calculateHiringOrderValue($('#hiring_item_table'));
                                        }
                                        else{
                                            if(data.tax == 'Y'){
                                                  $('#HiringOrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                  $('#checkhiring_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                            }else{
                                                $('#HiringOrderItem_'+row_field+'_tax_vat_percentage').val(0);
                                                $('#checkhiring_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    }
                })
            }
        }
    }", CClientScript::POS_HEAD);
