<ul class="clearfix form-ul material">
    <?php
    if ($model->file_id > 0) {
        $model->file_title = $model->file_title;
    } else {
        $model->file_title = $modelmaster->file_title;
    }
    ?>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'file_title', array('class' => 'tooltipster', 'data-label' => 'File Title','readonly'=>TRUE)); ?>
    </li>
    <li class="col-sm-3">
        <?php if ($model->customer_id > 0) {
            $customer = $model->customer->customer_name;
            $customer_id = $model->customer_id;
        } else {
            $customer = $modelQuotes->customer->customer_name;
            $customer_id = $modelQuotes->customer_id;
        } ?>
        <?php
        echo $form->textField($model, 'customer_name', array('class' => 'text-bold', 'data-label' => "Customer <span style='color:red'>*</span>", 'title' => 'Please select customer', 'value' => $customer,'readonly'=>TRUE));
        ?>
            <?php echo $form->hiddenField($model, 'customer_id', array('value' => $customer_id)); ?>
            <?php echo $form->hiddenField($model, 'tender_file_id'); ?>
            <?php echo $form->error($model, 'customer_id'); ?>
    </li>
    <div id="div_contact">
        <li class="col-sm-3">
            <?php
            if ($model->contact_id > 0) {
                $contact_name = $model->customercontact->person_name;
                echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($customer_id), array('options' => array($model->contact_id => array('selected' => true)), 'disabled' => true, 'data-label' => 'Contact <span style="color:red">*</span>'));
            } else {
                echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($customer_id), array('data-label' => 'Contact Person', 'prompt' => 'Select lead owner', 'disabled' => true));
            }
            echo $form->hiddenField($model, 'contact_id');
            ?> 
        </li>
    </div>
    <li class="col-sm-3">
    <?php echo $form->dropDownList($model, 'lead_owner_id', User::getLeadOwners(), array('class' => 'tooltipster ', 'data-label' => "Lead Owner <span style='color:red'>*</span>", 'empty' => '--Select--', 'title' => 'Please select lead owner', 'options' => array($model->lead_owner_id ? $modelQuotes->lead_owner_id : Yii::app()->user->id => array('selected' => true)))); ?>
    <?php echo $form->hiddenField($model, 'lead_owner_id',array('value'=>$model->lead_owner_id ? $modelQuotes->lead_owner_id : Yii::app()->user->id));    
    echo $form->error($model, 'lead_owner_id'); ?> 
    </li>
    <li class="col-sm-3">  
        <?php echo $form->dropDownList($model, 'order_type', array('S'=>'Sales','H'=>'Hiring'), array('data-label'=>'Type','disabled'=>'true')); ?>
        <input type="hidden" name="Order[order_type]" id="Order_order_type" value="<?php echo $model->order_type; ?>"/>
        <?php echo $form->error($model, 'order_type'); ?>     
    </li>
    <?php if ($model->tender_file_id > 0) { ?>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'tender_file_id', array('class' => 'tooltipster ', 'data-label' => "Ref Quotation No", "readonly" => 'true')); ?>
        <?php echo $form->error($model, 'tender_file_id'); ?> 
    </li>
        <?php } ?>
    <li class="col-sm-3">
        <?php if ($model->order_date != '') {
            $order_date = date("d/m/Y", strtotime($model->order_date));
        } else {
            $order_date = date("d/m/Y");
        } ?>
        <?php echo $form->textField($model, 'order_date', array('class' => '', 'data-label' => 'Order Date', 'value' => $order_date,'readonly'=>TRUE)); ?>
        <?php echo $form->error($model, 'order_date'); ?> 
    </li>
    <li class="col-sm-3">
        <?php if ($model->delivery_date != '') {
            $delivery_date = date("d/m/Y", strtotime($model->delivery_date));
        } else {
            $delivery_date = date("d/m/Y", strtotime("+30 days"));
        } ?>
        <?php echo $form->textField($model, 'delivery_date', array('class' => 'datepicker', 'data-label' => 'Delivery Date', 'value' => $delivery_date,'readonly'=>TRUE)); ?>
        <?php echo $form->error($model, 'delivery_date'); ?> 
    </li>
    <li class="col-sm-3">
        <div id="order_salesgroup_div">
        <?php echo $form->dropDownList($model, 'sales_group', MasSalesGroup::getSalesGroup(), array('options' => array(1 => array('selected' => true)), 'disabled' => true, 'data-label' => 'Sales Group <span style="color:red">*</span>')); ?>
            <input type="hidden" name="Order[sales_group]" id="Order_sales_group" value="<?php echo $model->sales_group; ?>"/>
        </div>
               
    </li>
    <?php
    $hiring_li_style = 'display: none;';
    if ($model->order_type == 'H') {
        $hiring_li_style = 'display: block;';
    }?>
     <li class="col-sm-2 hiring_li" style="<?php echo $hiring_li_style; ?>">
        <?php echo $form->textField($model, 'default_hrs_per_day', array('class' => 'tooltipster clockpicker','data-label'=>'Default M/c Hours/Day','readonly'=>TRUE)); ?>
    </li>
    <li class="col-sm-2 hiring_li" style="<?php echo $hiring_li_style; ?>">
        <?php echo $form->textField($model, 'default_man_hours', array('class' => 'tooltipster clockpicker','data-label'=>'Default ManHours/Day','readonly'=>TRUE)); ?>
    </li>
    <li class="col-sm-2 hiring_li" style="<?php echo $hiring_li_style; ?>">                  
        <?php echo $form->dropDownList($model, 'hiring_application', MasHiringApplication::getHiringApplication(), array('data-label' => 'Application', 'disabled' => true)); ?>
        <?php echo $form->error($model, 'hiring_application'); 
        echo $form->hiddenField($model, 'hiring_application');
        ?>                
    </li>
    <li class="col-sm-2 hiring_li" style="<?php echo $hiring_li_style; ?>">                  
        <?php echo $form->dropDownList($model, 'hiring_type', array('1' => 'Short Term', '2' => 'Long Term'), array('data-label' => 'Type', 'disabled' => true)); ?>
        <?php echo $form->error($model, 'hiring_type'); 
        echo $form->hiddenField($model, 'hiring_type');
        ?>                
    </li>
    <li class="col-sm-2 hiring_li" style="<?php echo $hiring_li_style; ?>">                  
        <?php echo $form->dropDownList($model, 'operator', array('N' => 'No', 'Y' => 'Yes'), array('data-label' => 'Operator', 'onchange' => 'changeOperator(this.value);', 'disabled' => true)); ?>
        <?php echo $form->error($model, 'operator');
        echo $form->hiddenField($model, 'operator');
        ?>                
    </li>
    <li class="col-sm-3">
        <div id="order_paymentterm_div">
            <?php $term = $modelQuotes->payment_terms; ?>
            <?php echo $form->dropDownList($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('data-label' => 'Payment Terms <span style="color:red">*</span>', 'prompt' => '--Select--', 'disabled' => true, 'options' => array($term => array('selected' => true)))); ?>
            <?php echo $form->error($model, 'payment_terms');
        echo $form->hiddenField($model, 'payment_terms'); ?>
        </div> 
    </li>
    <li class="col-sm-3">
        <?php $currency = $modelQuotes->currency; ?>
        <div id="order_currency_div">
        <?php echo $form->dropDownList($model, 'currency', MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'onChange' => 'getExchangeRate(this.id)', 'value' => $modelQuotes->currencyname->currency, 'prompt' => '--Select--', 'disabled' => true));
        echo $form->hiddenField($model, 'currency'); ?>
        </div> 
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate <span style="color:red">*</span>', 'value' => $modelQuotes->exchange_rate,'readonly'=>TRUE)); ?>
        <?php echo $form->error($model, 'exchange_rate'); ?> 
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'lpo', array('data-label' => 'LPO Reference <span style="color:red;">*</span>', 'value' => $model->lpo,'readonly'=>TRUE)); ?>
        <?php echo $form->error($model, 'lpo'); ?> 
    </li>

    <li class="col-sm-3">
        <?php
        if ($model->id > 0) {
            $default_invc_id = $model->invoice_type;
            if ($default_invc_id <= 0) {
                $default_invc_count = MasInvoiceType::model()->count('inv_type="sales" AND is_default="Y"');
                if ($default_invc_count > 0) {
                    $default_invc_model = MasInvoiceType::model()->find('inv_type="sales" AND is_default="Y"');
                } else {
                    $default_invc_model = MasInvoiceType::model()->find('inv_type="sales"');
                }
                $default_invc_id = $default_invc_model->id;
            }
        } else {
            $default_invc_count = MasInvoiceType::model()->count('inv_type="sales" AND is_default="Y"');
            if ($default_invc_count > 0) {
                $default_invc_model = MasInvoiceType::model()->find('inv_type="sales" AND is_default="Y"');
            } else {
                $default_invc_model = MasInvoiceType::model()->find('inv_type="sales"');
            }
            $default_invc_id = $default_invc_model->id;
        }


        echo $form->dropDownList($model, 'invoice_type', MasInvoiceType::getInvoceType('sales'), array('class' => '', 'data-label' => 'Invoice Type <span style="color:red">*</span>','disabled'=>'true', 'options' => array($default_invc_id => array('selected' => true))));
        ?>
        <?php echo $form->error($model, 'invoice_type');echo $form->hiddenField($model, 'invoice_type'); ?> 
    </li>
     <li class="col-sm-3">
        <?php echo $form->textField($model, 'project_location', array('class' => 'tooltipster', 'data-label' => 'Project Location','readonly'=>TRUE)); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textArea($model, 'billing_address', array('data-label' => 'Billing Address <span style="color:red">*</span>', 'class' => 'en-text-area','readonly'=>TRUE)); ?>
        <?php echo $form->error($model, 'billing_address'); ?> 
    </li>

</ul>

<?php
$cs = Yii::app()->getClientScript();
//for hide and show operator expense tab
$cs->registerScript("changeOperator", "function changeOperator(value){
    
    if(value == 'Y'){
        $('.cls_operator').show();
    }
    else{
        $('.cls_operator').hide();
    }
}", CClientScript::POS_HEAD); 
//for changing tax based on invoice_type
$cs->registerScript("loadUsers", '
        $(document).ready(function() {
            function getInvoiceTypePercentage1(id)
            {
                if(id>0){
        
            jQuery.ajax({
                "dataType" : "json",
              "type"  : "post",
              "data"  : "id="+id,
              "url"  : $("#liveSite").val()+"index.php?r=masinvoicetype/getInvoiceTypeTax",
              "cache": false,
              "success":function(data){
                
                if(data.status=="success"){
                    
                    var tr_rowCount = $("#order_item_table tr").length;
                   
                    tr_rowCount  = tr_rowCount-2;
                    var rowCount=$("#hiring_item_table").find("tr:gt(0)").length;
                    if(data.tax == "Y"){
                        for (i = 0; i <= tr_rowCount; i++){
                            var find_value  = $("#check_tax_vat_percentage_"+i).val();                            
                            $("#OrderItem_"+i+"_tax_vat_percentage").val(find_value);
                        }
                        for(i= 0;i <rowCount; i++){
                            var find_value  = $("#check_tax_vat_percentage_hiring_"+i).val();                            
                            $("#HiringOrderItem_"+i+"_tax_vat_percentage").val(find_value);
                        }
                    }
                    else{
                        for (i = 0; i <= tr_rowCount; i++){
                            
                            var pro_item_type   = $("#product_"+i+"_inventorytype").val();
                            var find_value  = $("#check_tax_vat_percentage_"+i).val();
                            $("#OrderItem_"+i+"_tax_vat_percentage").val(0);
                        }
                        for(i= 0;i <rowCount; i++){                          
                            $("#HiringOrderItem_"+i+"_tax_vat_percentage").val(0);
                        }
                    }
                    calculateorderValue($("#order_item_table"));
                    calculateHiringOrderValue($("#hiring_item_table"));
                }
                else{
                    $("#Order_vat_percentage").val();
                }
                
               }
            });
        
    }
            }
            var Order_invoice_type  = $("#Order_invoice_type").val();
            getInvoiceTypePercentage1(Order_invoice_type);
            $("#Order_invoice_type").change(function(){
                var Order_invoice_type  = $(this).val();
                getInvoiceTypePercentage1(Order_invoice_type);
            });
            
});', CClientScript::POS_HEAD);
?>      
