<?php
$modelMasCompanySettings = new MasCompanySettings();
$modelMasCompanySettings = $modelMasCompanySettings->find(array('condition' => 'crm_company_id=' . (int) Yii::app()->user->master_user_company_id));
$salesGroupCodes = MasSalesGroup::getSalesGroupCode();

?>
<style>
    .clockpicker-popover {
        z-index: 999999999999 !important;
    }
</style>

<?php echo $form->hiddenField($model, 'ticket_id', array()); ?>

<ul class="clearfix form-ul material">
    <?php
    if ($frm == 3) {

        $hidden = 'hidden';
    }
    ?>

    <li class="col-sm-3">
        <?php
        if ($model->customer_id > 0) {
            $customer = $model->customer->customer_name;
        } else {
            $customer = $modelQuotes->customer->customer_name;
        }
        ?>
        <?php
        echo $form->textField($model, 'customer_name', array('class' => 'text-bold', 'data-label' => "Customer <span style='color:red'>*</span>", 'title' => 'Please select customer', 'onKeyup' => 'js:autoCompleteOrderCustomer(this.id,"Order");', 'value' => $customer));
        ?>
        <?php echo $form->hiddenField($model, 'customer_id', array('value' => $modelQuotes->customer_id)); ?>
        <?php echo $form->hiddenField($model, 'quotes_id', array('value' => $modelQuotes->id)); ?>

        <?php echo $form->error($model, 'customer_id'); ?>
        <?php $model->shipping_by = MasShipping::getDefault(); ?>
        <?php echo $form->hiddenField($model, 'shipping_by'); ?>
    </li>
    <div id="div_contact">
        <li class="col-sm-3">
            <?php if ($model->customer_id > 0) {
                $customer_id = $model->customer_id;
            } else {
                $customer_id = $model_lead->customer_id;
            }
            if ($model->contact_id > 0) {
                $contact_name = $model->customercontact->person_name;
                echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($customer_id), array('options' => array($model->contact_id => array('selected' => true)), 'readonly' => true, 'data-label' => 'Contact <span style="color:red;">*</span>'));
            } else {
                echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($model_lead->customer_id), array('data-label' => 'Contact Person', 'prompt' => 'Select Contact Person', ));
            } ?>
        </li>
    </div>
    <?php
    $customer_outlet_array = array();
    
        if($model->customer_id>0)
        $customer_outlet_array =  ($model->customer_id > 0) ? CustomerOutletLocation::getShippingLocation($model->customer_id) : [];
        ?>
          <li class="col-sm-2">
        <?php
        echo $form->dropDownList($model, 'customer_outlet_id', $customer_outlet_array, array('data-label' => 'Outlet', 'prompt' => '--Select--'));
        ?>
    </li>
    <?php
    
    ?>
    <li class="col-sm-2">

        <div id="order_paymentterm_div">
            <?php
            $term = $modelQuotes->payment_terms_id;

            $payment_terms = '';
            if ($model->payment_terms_id > 0) {
                $payment_terms = $model->payment_terms_id;
            } else {
                $payment_terms = $modelQuotes->payment_terms_id;
            }

            $arr_payment_term_details = MasPaymentTerm::model()->findByPk($payment_terms);
            $payment_terms_name = $arr_payment_term_details->payment_terms;
            ?>
            <?php
            if (((int) Yii::app()->user->havePermissionOn["other_customer_finance_view"])) {
                echo $form->dropDownList($model, 'payment_terms_id', MasPaymentTerm::getPaymentTerms(), array('data-label' => 'Payment Terms <span style="color:red">*</span>', 'prompt' => '--Select--', 'options' => array($term => array('selected' => true))));
            } else {
                echo CHtml::textField('payment_terms_name', $payment_terms_name, array('class' => 'text-bold', 'data-label' => 'Payment Terms <span style="color:red">*</span>', 'readonly' => true));
                echo $form->hiddenField($model, 'payment_terms_id', array('value' => $payment_terms));
            }
            ?>
            <?php echo $form->error($model, 'payment_terms'); ?>
        </div>

    </li>



    <?php
    $flag_finance_view = 0;
    if (((int) Yii::app()->user->havePermissionOn["other_customer_finance_view"])) {
        $flag_finance_view = 1;
    }

    if ($model->file_id > 0) {
        $model->file_title = $model->file_title;
    } else {
        $model->file_title = $modelmaster->file_title;
    }
    ?>
    <?php echo CHtml::hiddenField('flag_finance_view', $flag_finance_view); ?>
    <li class="col-sm-2">



        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_view_all"])) {
            echo $form->dropDownList($model, 'lead_owner_id', User::getuser(), array('class' => 'tooltipster ', 'data-label' => "Sales Man <span style='color:red'>*</span>", 'title' => 'Please select lead owner', 'options' => array($model->lead_owner_id ? $modelQuotes->lead_owner_id : Yii::app()->user->id => array('selected' => true))));
        } else {
            $model->lead_owner_id = Yii::app()->user->id;
            echo $form->dropDownList($model, 'lead_owner_id', User::getLeadOwners(Yii::app()->user->id), array('class' => 'tooltipster ', 'data-label' => "Sales Man <span style='color:red'>*</span>", 'title' => 'Please select lead owner', 'options' => array($model->lead_owner_id ? $modelQuotes->lead_owner_id : Yii::app()->user->id => array('selected' => true))));
        }

        ?>
        <?php echo $form->error($model, 'lead_owner_id'); ?>
    </li>
    <li class="col-sm-3">
        <?php
        echo $form->dropDownList($model, 'project_id', WsProject::getProjectAll(), array('options' => array($model->project_id => array('selected' => true)), 'readonly' => true, 'data-label' => 'Project', 'prompt' => '--Select--'));
        ?>
    </li>


    <?php if (isset($modelMasCompanySettings->projects_menu) && $modelMasCompanySettings->projects_menu == 1) { ?>
        <!-- <li class="col-sm-3">
            <?php //echo $form->dropDownList($model, 'project_id', WsProject::getProject(), array('data-label' => 'Project <span style="color:red"></span>'));  
                ?>
            <?php //echo $form->error($model, 'project_id');
                ?>
        </li> -->
    <?php } ?>

    <li class="col-sm-3">
        <?php
        if ($model->id > 0) {
            $default_invc_id = $model->invoice_type_id;
            if ($default_invc_id <= 0) {
                $default_invc_count = MasInvoiceType::model()->count('inv_type="sales" AND is_default="Y"');
                if ($default_invc_count > 0) {
                    $default_invc_model = MasInvoiceType::model()->find('inv_type="sales" AND is_default="Y"');
                } else {
                    $default_invc_model = MasInvoiceType::model()->find('inv_type="sales"');
                }
                $default_invc_id = $default_invc_model->id;
            }
        } else {
            $default_invc_count = MasInvoiceType::model()->count('inv_type="sales" AND is_default="Y"');
            if ($default_invc_count > 0) {
                $default_invc_model = MasInvoiceType::model()->find('inv_type="sales" AND is_default="Y"');
            } else {
                $default_invc_model = MasInvoiceType::model()->find('inv_type="sales"');
            }
            $default_invc_id = $default_invc_model->id;
        }


        echo $form->dropDownList($model, 'invoice_type_id', MasInvoiceType::getInvoceType('sales'), array('class' => '', 'data-label' => 'Invoice Type <span style="color:red">*</span>', 'options' => array($default_invc_id => array('selected' => true))));
        ?>
        <?php echo $form->error($model, 'invoice_type_id'); ?>




    </li>
    <?php

    if (empty($model->inco_term_id)) {
        $defaultTerm = MasIncoTerms::model()->findByAttributes(['isDefault' => 'Y', 'isActive' => 'Y']);
        if ($defaultTerm) {
            $model->inco_term_id = $defaultTerm->id;
        }
    }
    ?>
    <li class="col-sm-2 <?php echo $hidden; ?>" style="display:none">
        <?php echo $form->dropDownList(
            $model,
            'inco_term_id',
            MasIncoTerms::getIncoTerms(),
            array(
                'prompt' => '--Select--',
                'data-label' => 'Inco Terms <span style="color:red">*</span>'
            )
        ); ?>
    </li>
    <li class="col-sm-3">
        <?php
        $date_picker_class = 'datepicker';
        if ($model->id > 0) {
            $model_deliverynote_exist = DeliveryNote::model()->find(array('condition' => 'order_id="' . $model->id . '"'));
            if ($model_deliverynote_exist->id > 0) {
                $date_picker_class = '';
            }
        }
        if ($model->order_date != '') {
            $order_date = date("d/m/Y", strtotime($model->order_date));
        } else {
            $order_date = date("d/m/Y");
        }
        ?>
        <?php echo $form->textField($model, 'order_date', array('class' => '' . $date_picker_class . '', 'data-label' => 'Order Date', 'value' => $order_date, 'onkeypress' => 'return false;')); ?>
        <?php echo $form->error($model, 'order_date'); ?>
    </li>
    <li class="col-sm-3">
        <?php
        if ($model->delivery_date != '') {
            $delivery_date = date("d/m/Y", strtotime($model->delivery_date));
        } else {
            $delivery_date = date("d/m/Y", strtotime("+3 days"));
        }
        ?>
        <?php echo $form->textField($model, 'delivery_date', array('class' => '' . $date_picker_class . '', 'data-label' => 'Delivery Date', 'value' => $delivery_date, 'onkeypress' => 'return false;')); ?>
        <?php echo $form->error($model, 'delivery_date'); ?>
    </li>

    <?php if ((int) Yii::app()->user->haveLevelPermissionOn['master_level_permission_currency'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['currency_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <li class="col-sm-3">
                <?php $currency = $modelQuotes->currency_id; ?>

                <div id="order_currency_div">
                    <?php

                    if ((int) $model->currency_id <= 0) {
                        $model->currency_id = Yii::app()->user->company_base_currency;
                    }

                    // echo $form->dropDownList($model, 'currency_id', MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'onChange' => 'getExchangeRate(this.id)', 'value' => $modelQuotes->currencyname->currency, 'prompt' => '--Select--')); 
                    echo $form->dropDownList($model, 'currency_id', MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency ', 'data-label' => 'Currency <span style="color:red">*</span>', 'onChange' => 'getExchangeRate(this.id)', 'prompt' => '--Select--')); ?>
                </div>
            </li>
            <li class="col-sm-3">
                <?php
                if ((Yii::app()->user->company_base_currency == $model->currency_id || (int) $model->id == 0) && (float) $model->exchange_rate <= 0) {
                    $model->exchange_rate = 1;
                    echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate <span style="color:red">*</span>', 'readonly' => true));
                } else {
                    echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate <span style="color:red">*</span>'));
                }
                ?>
            </li>
        <?php }
        $model->currency_id = MasCurrency::base_currency_id();
        echo $form->hiddenField($model, 'currency_id');
        $model->exchange_rate = MasCurrency::base_exchange_rate();
        echo $form->hiddenField($model, 'exchange_rate');
        ?>
    <?php } else {
        $model->currency_id = MasCurrency::base_currency_id();
        echo $form->hiddenField($model, 'currency_id');
        $model->exchange_rate = MasCurrency::base_exchange_rate();
        echo $form->hiddenField($model, 'exchange_rate');
    }
    ?>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'lpo', array('data-label' => 'LPO <span style="color:red">*</span>', 'value' => $model->lpo)); ?>
        <?php echo $form->error($model, 'lpo'); ?>
    </li>
    <li class="col-sm-3">
        <?php
        $lpo_date_class = 'datepicker';
        if ($model->lpo_date != '' && $model->lpo_date != '0000-00-00') {
            $model->lpo_date = date("d/m/Y", strtotime($model->lpo_date));
        } else {
            $model->lpo_date = date("d/m/Y");
            $lpo_date_class = 'datepicker';
        }
        echo $form->textField($model, 'lpo_date', array('class' => "$lpo_date_class", 'data-label' => 'LPO Date <span style="color:red">*</span>', 'onkeypress' => 'return false;'));
        // 
        ?>
    </li>

    <?php

    if ((int) Yii::app()->user->haveLevelPermissionOn['master_level_permission_sales_groups'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_salegroup_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <li class="col-sm-3">
                <?php if (!($model->isNewRecord) || $quote_id > 0) { ?>
                    <div id="order_salesgroup_div">
                        <?php echo $form->dropDownList($model, 'sales_group_id', MasSalesGroup::getSalesGroup($frm), array('options' => array(1 => array('selected' => true)), 'disabled' => true, 'data-label' => 'Sales Group <span style="color:red">*</span>', 'onchange' => 'LoadServiceDiv(this.value)')); ?>
                        <input type="hidden" name="Order[sales_group_id]" id="Order_sales_group_id"
                            value="<?php echo $model->sales_group_id; ?>" />
                    </div>
                <?php } else { ?>
                    <div id="order_salesgroup_div">
                        <?php echo $form->dropDownList($model, 'sales_group_id', MasSalesGroup::getSalesGroup($frm), array('options' => array(1 => array('selected' => true)), 'data-label' => 'Sales Group <span style="color:red">*</span>', 'onchange' => 'LoadServiceDiv(this.value)')); ?>
                    </div>
                <?php } ?>
            </li>
        <?php }
        //  $model->sales_group_id = MasSalesGroup::base_sales_group();
        // echo $form->hiddenField($model, 'sales_group_id');
        ?>
    <?php } else {
        $model->sales_group_id = MasSalesGroup::base_sales_group();
        echo $form->hiddenField($model, 'sales_group_id');
    }
    ?>
    <?php
    $service_contract_style = $service_trial_style = $service_style = "display:none";

    if ($frm == 3) {
        if ($salesGroupCodes[$model->sales_group_id] == 'T' || $salesGroupCodes[$model->sales_group_id] == 'C') {
            $service_style = "";
            ?>

            <li class="col-sm-3" style="<?php echo $service_style; ?>" id="div_contract_no">
                <?php
                $contract_no = '';


                if ($model->id > 0) {
                    $model->contract_no = $contract_no . $model->contract_no;
                    echo $form->textField($model, 'contract_no', array('data-label' => 'Contract Number ', 'value' => $model->contract_no, 'readonly' => true));
                } else {
                    $SQL = 'SELECT (MAX(contract_no) + 1) AS next_contract_no FROM `erp_order`';
                    $max_contract_no = (int) Yii::app()->db->createCommand($SQL)->queryScalar();

                    if ($max_contract_no == 0) {
                        $max_contract_no = 10001;
                    }
                    $contract_no = $contract_no . $max_contract_no;


                    echo $form->textField($model, 'contract_no', array('data-label' => 'Contract Number', 'value' => $contract_no, 'readonly' => true));
                }
                ?>

            </li>
            <?php
            if ($salesGroupCodes[$model->sales_group_id] == 'T') {
                $service_trial_style = "";
                ?>
                <li class="col-sm-3" style="<?php echo $service_trial_style; ?>" id="div_trial_start_date">
                    <?php

                    $lpo_date_class = 'datepicker';
                    if ($model->contract_start_date != '' && $model->contract_start_date != '0000-00-00') {
                        $model->contract_start_date = date("d/m/Y", strtotime($model->contract_start_date));
                    } else {
                        $model->contract_start_date = date("d/m/Y");
                        $lpo_date_class = 'datepicker';
                    }
                    echo $form->textField($model, 'contract_start_date', array('class' => "$lpo_date_class datepicker", 'data-label' => 'Trial Start Date', 'onkeypress' => 'return false;'));
                    ?>
                    <!--<label for="Order_contract_start_date">Contract Start Date</label>-->
                </li>
                <li class="col-sm-3" style="<?php echo $service_trial_style; ?>" id="div_trial_end_date">
                    <?php
                    //$lpo_date_class = 'datepicker';
                    if ($model->contract_end_date != '' && $model->contract_end_date != '0000-00-00') {
                        $model->contract_end_date = date("d/m/Y", strtotime($model->contract_end_date));
                    } else {
                        $startDate = isset($model->contract_start_date) ? str_replace('/', '-', $model->contract_start_date) : date("d-m-Y");
                        $model->contract_end_date = date("d/m/Y", strtotime("365 Days", strtotime($startDate)));
                    }
                    echo $form->textField($model, 'contract_end_date', array('class' => "datepicker", 'data-label' => 'Trial End Date', 'onkeypress' => 'return false;'));
                    ?>
                    <!--<label for="Order_contract_end_date">Contract End Date</label>-->
                </li>
            <?php } else if ($salesGroupCodes[$model->sales_group_id] == 'C') {
                $service_contract_style = "";
                ?>

                    <li class="col-sm-3" style="<?php echo $service_contract_style; ?>" id="div_contract_start_date">
                        <?php

                        $lpo_date_class = 'datepicker';
                        if ($model->contract_start_date != '' && $model->contract_start_date != '0000-00-00') {
                            $model->contract_start_date = date("d/m/Y", strtotime($model->contract_start_date));
                        } else {
                            $model->contract_start_date = date("d/m/Y");
                            $lpo_date_class = 'datepicker';
                        }
                        echo $form->textField($model, 'contract_start_date', array('class' => "$lpo_date_class datepicker", 'data-label' => 'Contract Start Date', 'onkeypress' => 'return false;'));
                        ?>
                        <!--<label for="Order_contract_start_date">Contract Start Date</label>-->
                    </li>
                    <li class="col-sm-3" style="<?php echo $service_contract_style; ?>" id="div_contract_end_date">
                        <?php
                        //$lpo_date_class = 'datepicker';
                        if ($model->contract_end_date != '' && $model->contract_end_date != '0000-00-00') {
                            $model->contract_end_date = date("d/m/Y", strtotime($model->contract_end_date));
                        } else {
                           $startDate = isset($model->contract_start_date) ? str_replace('/', '-', $model->contract_start_date) : date("d-m-Y");
                            $model->contract_end_date = date("d/m/Y", strtotime("+1 year ", strtotime($startDate)));
                        }
                        echo $form->textField($model, 'contract_end_date', array('class' => "datepicker", 'data-label' => 'Contract End Date', 'onkeypress' => 'return false;'));
                        ?>
                        <!--<label for="Order_contract_end_date">Contract End Date</label>-->
                    </li>

            <?php
            }
        }
    } else { //no need in sales ?>

        <?php echo $form->hiddenField($model, 'contract_no', array('value' => 0)); ?>
        <?php echo $form->hiddenField($model, 'contract_start_date'); ?>
        <?php echo $form->hiddenField($model, 'contract_end_date'); ?>
    <?php } ?>



    <li class="col-sm-3">
        <?php echo $form->dropDownList(
            $model,
            'shipping_city',
            CustomerShippingDetails::getCity($model->customer_id),
            array(
                'data-label' => 'Delivery Location',
                'prompt' => 'Select',
                'onchange' => 'getshippingAddress(this)'
            )
        ); ?>

    </li>

    <?php if ((int) Yii::app()->user->haveLevelPermissionOn['sales_level_permission_balncerecevble'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
        <?php if ($model->id > 0) { ?>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'balance_receiveable', array('class' => 'tooltipster', 'data-label' => 'Balance Receiveable', 'readonly' => true, 'value' => Yii::app()->numberFormatter->formatCurrency((float) $current_credit, ""))); ?>
            </li>
        <?php } ?>
    <?php } ?>
    <?php if (isset($modelMasCompanySettings->fm_menu) && $modelMasCompanySettings->fm_menu == 1) { ?>
        <?php if ((int) $model->ticket_id > 0) { ?>

            <li class="col-sm-2">
                <?php
                $disabled_pro = ((int) $model->ticket_id > 0) ? true : false;

                $modelTicketHeader = new TicketHeader();
                echo $form->dropDownList($model, 'ticket_id', $modelTicketHeader->GetJoblist(), array('disabled' => $disabled_pro, 'class' => '', 'prompt' => '--Select--', 'title' => 'Select Job', 'data-label' => 'Job Order No')); ?>

            </li>
        <?php } ?>
    <?php } ?>


    <?php if ($model->id > 0) { ?>

        <li class="col-sm-3">
        <?php } else { ?>
        <li class="col-sm-3">
        <?php } ?>
        <?php echo $form->textArea($model, 'billing_address', array('data-label' => 'Billing Address ', 'class' => 'en-text-area')); ?>
        <?php echo $form->error($model, 'billing_address'); ?>
    </li>
    <?php if ((int) Yii::app()->user->haveLevelPermissionOn['sales_level_permission_shipping'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
        <li class="col-sm-3">
            <?php echo $form->textArea($model, 'shipping_address', array('data-label' => 'Shipping Address')); ?>
            <?php echo $form->error($model, 'shipping_address'); ?>
        </li>
    <?php } ?>
    <style>
        select#Order_terms_id {
            width: 200px;
        }

        .the-legend {
            border-style: none;
            border-width: 0;
            font-size: 15px;
            line-height: 20px;
            margin-bottom: 0;
            width: auto;
            padding: 6px 17px;
            border: 1px solid #e0e0e0;
            background: #1f67b2;
            color: white;
            font-weight: 500;
            border-radius: 18px 2%;
        }

        .the-fieldset {
            border: 1px solid #e0e0e0;
            padding: 10px;
            background: #d2e8ffa3;
            border-radius: 5px;

        }
    </style>

    <?php if ($model->id > 0) { ?>

        <li class="col-sm-3">
        <?php } else { ?>
        <li class="col-sm-3">
        <?php } ?>
        <?php echo $form->textArea($model, 'notes', array('data-label' => 'Notes', 'class' => 'en-text-area')); ?>

        <?php echo $form->error($model, 'notes'); ?>

    </li>

    <li class="col-sm-3">

        <?php echo $form->textArea($model, 'remarks', array('data-label' => 'Remarks', 'class' => 'en-text-area')); ?>

        <?php echo $form->error($model, 'remarks'); ?>

    </li>

    <li class="col-sm-3">
        <?php echo $form->hiddenField($model, 'terms_id'); ?>
        <?php echo $form->textArea($model, 'terms_and_conditions', array('rows' => 7, 'cols' => 60, 'data-label' => 'Terms & Conditions', 'class' => 'en-text-area')); ?>


    </li>
</ul>

<!--ul class="clearfix form-ul material">
    <fieldset class="the-fieldset">
        <legend class="the-legend">Terms & Conditions</legend>

        <li class="col-sm-4">
            <?php //echo $form->dropDownList($model, 'terms_id', MasTermsAndConditions::getTerms(), array('data-label' => 'Terms', 'prompt' => 'select')); ?>
            <?php //echo $form->error($model, 'terms_id'); ?>
            <button type="button" class="btn btn-theme" onclick="getTerms()">Publish</button>
        </li>

        <li class="col-sm-8">

            <?php //echo $form->textArea($model, 'terms_and_conditions', array('rows' => 7, 'cols' => 60, 'data-label' => 'Terms & Conditions', 'class' => 'en-text-area')); ?>

            <?php //echo $form->error($model, 'terms_and_conditions'); ?>

        </li>

    </fieldset>
</ul-->

<?php
$cs = Yii::app()->getClientScript();
//autocomplete order customer
$cs->registerScript("autoCompleteOrderCustomer", "
    function autoCompleteOrderCustomer(field_id,frm){
        var url = '" . Yii::app()->createUrl('customer/GetcustomerDetails') . "'+'&frm='+frm;
        $('#'+field_id).autocomplete({
            minLength : 1,
            source : function (request, response) {
                autoCompleteSource(request, response,url)
            },
            focus : function( event, ui ) { $(this).val((ui.item.label)); return false; },
            select : function( event, ui ) {
                event.preventDefault(); trigger_target_id = $(event.target).attr('id');
                var customer_id=ui.item.value;
                $('#Order_customer_name').val(ui.item.customername);
                var currency=ui.item.currency_id;
                var currency_id=ui.item.currency_id;
                var exchange_rate =ui.item.exchangerate;
                var payment_term = ui.item.payment_term;
                var lead_owner_id = ui.item.contact_id;
                var payment_terms_name = ui.item.other;
                /*$('#Order_lead_owner_id').multiselect('select',lead_owner_id);*/
                jQuery.ajax({
                    'data' :{'id':customer_id,'currency_id':currency_id},
                    'dataType' : 'json', 'type':'post',
                    'url': '" . Yii::app()->createUrl('order/getCustomerContactdetails') . "',
                    'success': function(data) {
                        $('#div_contact').html(data.dt);
                        $('#Order_billing_address').val(data.adds).addClass('filled');
                        $('#Order_customer_id').val(customer_id);
                        /*$('#Order_currency_id').multiselect('select', currency_id); */

                        if($('#flag_finance_view').val()==1){
                              $('#Order_payment_terms_id').multiselect('select', payment_term);
                        }
                        else{
                              $('#Order_payment_terms_id').val(payment_term);
                              $('#payment_terms_name').val(payment_terms_name);
                              $('#payment_terms_name').addClass('filled');
                        }
                        $('#Order_exchange_rate').val(exchange_rate);
                        $('#Order_exchange_rate').addClass('filled');
                    }
                });

                //clearQuotationTableData();
            }
        })
    }", CClientScript::POS_HEAD);
//get exchange rate based on currency change
$cs->registerScript("getExchangeRate", " function getExchangeRate(currency) {
            var base_currency = " . Yii::app()->user->company_base_currency . ";
            var currency_id = $('#'+currency).val();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('lead/getExchangeRate') . "',
                'data': {'currency_id':currency_id}, 'cache': false,
                'success': function(data) {
                    $('#Order_exchange_rate').val(data).addClass('filled');
                    if(base_currency==currency_id){
                       $('#Order_exchange_rate').attr('readonly',true);
                   }
                   else{
                       $('#Order_exchange_rate').attr('readonly',false);
                   }
                }
            }); }", CClientScript::POS_HEAD);
//for hide and show operator expense tab
$cs->registerScript("changeOperator", "function changeOperator(value){

    /*if(value == 'Y'){
        $('.cls_operator').show();
    }
    else{
        $('.cls_operator').hide();
    }*/
}", CClientScript::POS_HEAD);
//for changing tax based on invoice_type
$cs->registerScript("loadUsers", '
        $(document).ready(function() {
            function getInvoiceTypePercentage1(id)
            {
                if(id>0){

            jQuery.ajax({
                "dataType" : "json",
              "type"  : "post",
              "data"  : "id="+id,
              "url"  : $("#liveSite").val()+"index.php?r=masinvoicetype/getInvoiceTypeTax",
              "cache": false,
              "success":function(data){

                if(data.status=="success"){

                    var tr_rowCount = $("#order_item_table tr").length;
                    tr_rowCount  = tr_rowCount-2;
                    var serviceCount = $("#orderoperator_item_table").find("tr:gt(0)").length;
                    var subCount = $("#substitite_order_item_table").find("tr:gt(0)").length;
                    subCount=subCount-1;
                    if(data.tax == "Y"){
                        for (i = 0; i <= tr_rowCount; i++){
                            var find_value  = $("#check_tax_vat_percentage_"+i).val();
                            $("#OrderItem_"+i+"_tax_vat_percentage").val(find_value);
                        }


                    }
                    else{
                        for (i = 0; i <= tr_rowCount; i++){

                            var pro_item_type   = $("#product_"+i+"_inventorytype").val();
                            var find_value  = $("#check_tax_vat_percentage_"+i).val();
                            $("#OrderItem_"+i+"_tax_vat_percentage").val(0);

                        }

                    }
                    calculateorderValue($("#order_item_table"));
                }
                else{
                    $("#Order_vat_percentage").val();
                }

               }
            });

    }
            }
            var Order_invoice_type_id  = $("#Order_invoice_type_id").val();
            getInvoiceTypePercentage1(Order_invoice_type_id);
            $("#Order_invoice_type_id").change(function(){
                var Order_invoice_type_id  = $(this).val();
                getInvoiceTypePercentage1(Order_invoice_type_id);
            });

});', CClientScript::POS_HEAD);
?>
<?php

$cs = Yii::app()->getClientScript();

$cs->registerScript("getTerms", " function getTerms() {
        var terms_id = $('#Order_terms_id').val();
       
        jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('termsandcondition/getTermsFromId') . "',
                'data': {'term_id':terms_id},
                'cache': false,
                'success': function(data) {
                   
                   data.replace('<br>', '');
                   $('#Order_terms_and_conditions').addClass('filled');
                   $('#Order_terms_and_conditions').text(data);
                   /*tinymce.activeEditor.setContent(data);
                   CKEDITOR.instances.Order_terms_and_conditions.setData(data);
                   for (instance in CKEDITOR.instances) 
                    {
                        CKEDITOR.instances[instance].updateElement();
                    }*/
                }
        });

    }", CClientScript::POS_HEAD); ?>
<script>
    function clearQuotationTableData() {
        $('#order_item_table').find(':input').each(function () {

            $(this).val('');

        });




        $('.total').html('0.00');
        $('.vat_total_val').html('0.00');
        $('.grandtotal').html('0.00');

    }

    $(function () {
        var date_value = $("#Order_order_date").val().split("/");
        var current = new Date(date_value[2], date_value[1] - 1, date_value[0]);
        $('#Order_delivery_date').datetimepicker({
            minDate: current,
            format: 'DD/MM/YYYY'
        });



        $("#Order_order_date").on("dp.change", function (e) {
            var d = new Date(e.date);
            var duedate = new Date(d);
            duedate.setDate(d.getDate() + 3);
            var month = String(duedate.getMonth() + 1);
            var day = String(duedate.getDate());
            const year = String(duedate.getFullYear());

            if (month.length < 2)
                month = '0' + month;
            if (day.length < 2)
                day = '0' + day;
            var final = `${day}/${month}/${year}`;

            if ($('#Order_id').val() == '') {
                $('#Order_delivery_date').datetimepicker('destroy');
                $('#Order_delivery_date').datetimepicker({
                    minDate: final,
                    format: 'DD/MM/YYYY'
                }).val(final);
            }

        });
    });
</script>


<script>
    function getshippingAddress(element) {
        var id = $(element).val(); // Get selected city or ID

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("delivery/getCustomerContactdetails"); ?>',
            data: { id: id },
            dataType: 'json',
            success: function (response) {
                if (response.adds) {
                    $('#Order_shipping_address').val(response.adds).addClass('filled');
                }
                else {
                    $('#Order_shipping_address').val('').removeClass('filled');
                }
            },
            error: function () {
                console.log('Error fetching shipping address');
            }
        });
    }

    const salesGroupCodes = <?php echo json_encode(MasSalesGroup::getSalesGroupCode()); ?>;

    function LoadServiceDiv(group) {
        var code = salesGroupCodes[group];

        if (code == 'C') {
            console.log('contract');
            $('#div_contract_no, #div_contract_start_date, #div_contract_end_date').show();

            $('#Order_contract_start_date').attr('data-label', 'Contract Start Date');
            $('#Order_contract_end_date').attr('data-label', ' Contract End  Date');
        }
        else if (code == 'T') {
            console.log('Trial');
            $('#div_contract_no, #div_trial_start_date, #div_trial_end_date').show();

            $('#Order_contract_start_date').attr('data-label', 'Trial Start Date');
            $('#Order_contract_end_date').attr('data-label', ' Trial End  Date');
        }
        else if (!code || code === '' || code === null || code === undefined) {
            console.log('No code found');
            $('#div_contract_no, #div_contract_start_date, #div_contract_end_date').hide();
            $('#div_contract_no, #div_trial_start_date, #div_trial_end_date').show();
        }
        else {
            console.log('Other code: ' + code);
            $('#div_contract_no, #div_contract_start_date, #div_contract_end_date').hide();
            $('#div_contract_no, #div_trial_start_date, #div_trial_end_date').show();
        }
    }
</script>
 