<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteSettings",  "function deleteSettings(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=modulesettings/DeleteModuleSettings',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                   t8.error(' Deletion failed!');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=settings/index';
                    t8.success('Settings Deleted!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
    ?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_settings_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [[ 1, "asc" ]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('modulesettings/GetModuleSettingsList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                if ( aData[3] == "Y" )  {  
                                $("td", nRow).addClass("bg-payment");

                              }else{
                                  $("td", nRow).addClass("bg-test");
                              }
                              if(aData[4].status == "N") {
                                  $("td", nRow).addClass("bg-danger");
                              }
                    AddContextMenu(nRow, aData);
            }
        });
    });
    function AddContextMenu(row, datas) {
        // var mas_edit=0;
        // var mas_disable=0;
        
        <?php //if (isset(Yii::app()->user->havePermissionOn['mas_settings_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php //} ?>
        <?php //if (isset(Yii::app()->user->havePermissionOn['mas_settings_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php //} ?> 
        $(row).contextMenu({
            selector: 'td',

            items: {
                                
                "edit": {
                    
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("modulesettings/create&id=" + datas[4].id, datas[4].code, "lg");
                    }, disabled: function(key, opt) { 
                                // this references the trigger element
                                if(mas_edit=='0' || datas[4].code === "Damage"){
                                    return !this.data('editDisabled'); 
                                }
                    }
                },            
                "Disable_Enable":{
                    name: (datas[4].status == "Y") ?"Disable" : "Enable",
                    icon: "edit",
                    accesskey: "d",
                    callback: function () {
                        Disable(datas[4].id, datas[4].status);
                    }, disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0' || datas[4].code === "Damage"){
                                return true; 
                            }

                            if (String(datas[3]).trim().toUpperCase() === 'Y') {
            return true;
        }
        return false;      
                    }
                }

            }
        });
    }
</script>
<script>
    function Disable(id, status){
    var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
    if (r == true)
    {
    jQuery.ajax({
    'type'  : 'post',
            'datatype' :'json',
            'data'  : 'id=' + id + "&status=" + status,
            'url'  : $('#liveSite').val() + 'index.php?r=modulesettings/Disable',
            'cache': false,
            'success':function(data){
            if (data.status == 'fail'){
            t8.error('Error while Delete');
            } else {
            $('#tbl_settings_details').DataTable().ajax.reload()
                    t8.success(' Success!');
            }
            }
    });
    }


    }
</script>

    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="material-icons">domain</i> Module Settings
            <div class="pull-right">
     <?php  //if ((isset(Yii::app()->user->havePermissionOn['mas_settings_add']) ||  Yii::app()->user->authorised_user == 1)) {?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('modulesettings/create','Add New Settings','lg')" title="Add"><i class="fa fa-plus"></i></button>
                <?php //} ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_settings_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>Sl.No</th>
                            <th>Module Name</th>
                            <th>Grand Access</th>
                            
                            
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </section>
