<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'mas-erp-notification-form',
    'enableAjaxValidation' => false,
));
?>

<?php echo $form->errorSummary($model); ?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <!-- User IDs -->
            <?php
            if (!empty($model->user_ids) && is_string($model->user_ids)) {
                $model->user_ids = explode(',', $model->user_ids);
            }
            ?>
            <li class="col-sm-2">
                <?php
                $userList = User::getAllUsers();//Employee::model()->getEmployee(); // [id => name]
                echo $form->dropDownList($model, 'user_ids', $userList, array(
                    'multiple' => 'multiple',
                    'size' => 6,
                    'data-label' => 'User IDs',
                    'class' => 'tooltipster',
                ));
                ?>
                <?php echo $form->error($model, 'user_ids'); ?>
            </li>
            
            <!-- Reference No -->
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'reference_no', array(
                    'maxlength' => 100,
                    'data-label' => 'Reference No',
                    'class' => 'tooltipster',
                )); ?>
                <?php echo $form->error($model, 'reference_no'); ?>
            </li>

             <li class="col-sm-2" >
                <?php
                if($model->isNewRecord)
                $model->notification_type = MasNotificationType::getDefaultTypeId();
                 echo $form->dropDownList($model, 'notification_type', MasNotificationType::getAll(), array(
                    'data-label' => 'Notification Type',
                    'class' => 'tooltipster','empty'=>'---Select---'
                ));
                ?>
                <?php echo $form->error($model, 'notification_type'); ?>
            </li>

            <!-- Notification Date Time -->
            <?php
            if (!empty($model->notification_date_time)) {
                $model->notification_date_time = date('d/m/Y H:i', strtotime($model->notification_date_time));
            } else {
                $model->notification_date_time = date('d/m/Y H:i');
            }
            ?>

            <li class="col-sm-2">
                <?php echo $form->textField($model, 'notification_date_time', array(
                    'data-label' => 'Notification Date',
                    'class' => 'tooltipster datetimepicker',
                )); ?>
                <?php echo $form->error($model, 'notification_date_time'); ?>
            </li>
            <li class="col-sm-3" style="display:none">
                <?php
                if ($model->status === null) {
                    $model->status = 'S';
                }
                echo $form->dropDownList($model, 'status', array(
                    'O' => 'Open',
                    'S' => 'Sent',
                    'C' => 'Closed',
                ), array(
                    'data-label' => 'Status',
                    'class' => 'tooltipster',
                ));
                ?>
                <?php echo $form->error($model, 'status'); ?>
            </li>
            <!-- Notes -->
            <li class="col-sm-4">
                <?php echo $form->textArea($model, 'notes', array(
                    'rows' => 3,
                    'data-label' => 'Notes',
                    'class' => 'tooltipster',
                )); ?>
                <?php echo $form->error($model, 'notes'); ?>
            </li>
        </ul>
    </div>
</div>

<!-- Hidden Fields -->
<?php echo $form->hiddenField($model, 'id'); ?>




<!-- Submit -->
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="notification_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/masErpNotification/SaveNotification');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Details Saved Successfully!");
                                         $("#notification_close").click();
                                         location.href="index.php?r=masErpNotification/index";
                                        //reloadTable("#tbl_c_notification");
                                    } else { 
                                        $("#c_notification-form .c_notification-save-btn").prop("disabled", false);
                                        $("#c_notification-form .c_notification-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) { 
                                                t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#c_notification-form .c_notification-save-btn").prop("disabled", true);
                                $("#c_notification-form .c_notification-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'c_notification-save-btn btn btn-theme'));
    ?>


</div>

<?php $this->endWidget(); ?>