<?php
$cs = Yii::app()->getClientScript();
?>
<script>
	var imageBase64Logo = null;
	$(document).ready(function() {
		var table_id = "#tbl_currency_exchangedetails";
		table = $(table_id).on("preXhr.dt", function(e, settings, data) {
			data.display_type = $("#display_type").val();
			return data;
		}).DataTable({
			//scrollY: "450px",
			pageLength: 50,
			processing: true,
			ajax: {
				url: "<?php echo Yii::app()->createUrl('masCurrencyExchange/GetCurrencyExchangeList') ?>",
				type: "POST",
				cache: false,
			},
			serverSide: true,
			fixedColumns: true,
			columnDefs: [{
				"targets": [3],
				"visible": false,
			}, ],

			"fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
			
			}
		});

	});
</script>
<section class="panel" style="background-color:#F6F3EE;">
	<header class="panel-heading clearfix panel-theame">
		<i class="fa fa-money"></i> Currency Exchange
		<div class="pull-right">
			<?php if (isset(Yii::app()->user->havePermissionOn['currency_exchange_add']) ||  Yii::app()->user->authorised_user == 1) { ?>
				<button class="btn btn-sm btn-theme" onclick="loadPopupModal('masCurrencyExchange/create','Add New Currency','lg')"><i class="fa fa-plus"></i> ADD</button>
			<?php } ?>

			<button class="btn btn-sm btn-theme" onclick="loadPopupModal('masCurrencyExchange/View','View Currency','lg')"><i class="fa fa-eye"></i> View</button>

		</div>
	</header>
	<div class="panel-body">
		<div class="custom-data-table">
			<table class="table table-hover table-bordered personal-task" id="tbl_currency_exchangedetails" style="font-size:13px;">
				<thead>
					<tr>
						<th>SI No</th>						
						<th>Currency Code</th>
						<?php if (
							Yii::app()->user->authorised_user == 1 ||
							isset(Yii::app()->user->havePermissionOn['currency_exchange_edit'])
						) { ?>
							<th class="noExport">Action</th>
						<?php } ?>
					</tr>
				</thead>
			</table>
		</div>
	</div>
</section>