<?php
$sql = "SELECT COUNT(*) as qty, `service_id` FROM `erp_sale_repair_request` WHERE `status_id` = 2 GROUP BY service_id ORDER BY qty desc; ";
$dataArray = Yii::app()->db->createCommand($sql)->queryAll();
?>
<table class="table table-hover table-bordered" style="widtd: 100%" >
    <thead>
        <tr>
            <th colspan="4">
                Pending jobs
            </th>
        </tr>
        <tr>
            <th>#</th>
            <th>Service Type</th>
            <th class="text-right" >Job</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($dataArray as $key => $row) {
            $servicerModel = MasServices::model()->findByPk($row["service_id"]);
            ?>
            <tr onclick="loadPendingByServiceList('<?= $servicerModel->id ?>', '<?= $servicerModel->name ?>')">
                <td>
                    <?php echo $key + 1 ?>
                </td>
                <td>
                    <?php echo empty($servicerModel) ? "(Not Specific)" : $servicerModel->name ?>
                </td>
                <td class="text-right">
                    <?php echo $row["qty"]; ?>
                </td>
            </tr>
            <?php
        }
        ?>
    </tbody>
</table>
<script>
    function loadPendingByServiceList(service_id, serviceType) {
        var url = 'managementinfo/renderpage&page=pending_job_by_service&service_id=' + service_id;
        loadPopupModal(url, "Pending jobs of " + serviceType, 'lg');

    }
</script>