<?php
$dataMonth = [];
$selectedYear = date('Y');
$sql = "SELECT COUNT(*) as val, MONTH(`schedule_date`) as month, YEAR(`schedule_date`) FROM `erp_sale_repair_request` WHERE YEAR(`schedule_date`) = " . $year . "GROUP BY MONTH(`schedule_date`), YEAR(`schedule_date`)";
$rawData = Yii::app()->db->createCommand($sql)->queryAll();
foreach ($rawData as $key => $value) {
    $dataMonth[intval($value["month"])] = intval($value["val"]);
}
$plotArray = [];
for ($index = 1; $index <= 12; $index++) {
    $timestamp = mktime(0, 0, 0, $index, 1, date('Y'));
    $month_name = date('F', $timestamp);
    $plotArray[] = [
        "x" => $month_name,
        "value" => isset($dataMonth[$index]) ? $dataMonth[$index] : 0
    ];
}
?>
<div>
    <canvas  id="maintence-per-month" width="400" height="400" onclick="" style="width: 300px;height: 300px">
    </canvas>
</div>
<script>
    const ctx = document.getElementById('maintence-per-month').getContext('2d');
// Define the data for the chart
    const data = {
        // Labels for the x-axis (e.g., months)
        labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
        datasets: [{
                // Label for the dataset (used in the legend)
                label: 'My First Dataset',

                // The actual data points
                data: [65, 59, 80, 81, 56, 55, 40],

                // Customization
                fill: false, // Do not fill the area under the line
                borderColor: 'rgb(75, 192, 192)', // Color of the line
                tension: 0.1 // Smoothness of the line (0 is straight lines)
            }]
    };

// Define the configuration object
    const config = {
        // Crucially set the type to 'line'
        type: 'line',
        data: data,
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: true,
                    text: 'Sample Line Chart'
                }
            },
            // You can configure scales (axes) here
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    };

// Create the new chart instance
    const myLineChart = new Chart(ctx, config);
</script>
<style>
    #maintence-per-month_legend .graph-legend{
        width: 16px;
        height: 16px;
        border-radius: 50%;

        display: inline-flex;
        margin-right: 10px;
    }
</style>


