<?php
$sql = "SELECT erp_store.inventory_item_type, SUM(erp_stock_ledger.quantity * erp_store.rate) as amt FROM erp_stock_ledger JOIN erp_store ON (erp_store.id = erp_stock_ledger.product_id) GROUP by erp_store.inventory_item_type  ";
$sqlWarehouse = "SELECT erp_mas_inv_warehouse.warehouse_name, erp_store.inventory_item_type, SUM( erp_stock_ledger.quantity * erp_store.rate ) AS amt FROM erp_stock_ledger JOIN erp_store ON ( erp_store.id = erp_stock_ledger.product_id ) RIGHT JOIN erp_mas_inv_warehouse ON( erp_mas_inv_warehouse.id = erp_stock_ledger.warehouse_id ) GROUP BY erp_store.inventory_item_type, erp_mas_inv_warehouse.warehouse_name ";
$data = Yii::app()->db->createCommand($sql)->queryAll();
$dataWareHouse = Yii::app()->db->createCommand($sqlWarehouse)->queryAll();
$total = 0;
$arr = [
    "1" => 0,
    "2" => 0,
    "3" => 0
];
$warehouseTable = [];
foreach ($dataWareHouse as $value) {
    $warehouseTable[$value['inventory_item_type']][] = [
        "name" => $value['warehouse_name'],
        "amt" => $value['amt']
    ];
}
//echo '<pre>';
//print_r($warehouseTable);
//echo '</pre>';
//die();

foreach ($data as $value) {
    $arr[$value["inventory_item_type"]] = $value["amt"];
    $total += $value["amt"];
}
?>
<table  class="table table-bordered">    
    <thead>
    <th class="text-center" colspan="2">
        Summary
    </th>
</thead>
<tbody>
    <tr onclick="$('#finished_warehouse').toggle()" style="cursor: pointer" >
        <td>Finished Inventory Stock Value</td>
        <td class="text-right">
            <?= number_format($arr["1"]) ?>
        </td>
    </tr>
    <tr>
        <td colspan="3"  style="" id="finished_warehouse">
            <table class="table">
                <tr>

                    <th>Warehouse</th>
                    <th class="text-right">Amount</th>
                </tr>
                <?php
                $tyep1 = $warehouseTable[1];

                foreach ($tyep1 as $key => $row) {
                    ?>
                    <tr>
                        <td>
                            <?php echo $row["name"] ?>
                        </td>
                        <td class="text-right">
                            <?php echo number_format($row["amt"]) ?>
                        </td>
                    </tr>
                <?php }
                ?>
            </table>

        </td>
    </tr>
    <tr onclick="$('#raw_warehouse').toggle()"  style="cursor: pointer" >
        <td>Raw Material Stock Value</td>
        <td class="text-right"> <?= number_format($arr["3"]) ?></td>
    </tr>
    <tr>
        <td colspan="3" style="" id="raw_warehouse">
            <table class="table">
                <tr>

                    <th>Warehouse</th>
                    <th class="text-right">Amount</th>
                </tr>
                <?php
                $tyep1 = $warehouseTable[3];

                foreach ($tyep1 as $key => $row) {
                    ?>
                    <tr>
                        <td>
                            <?php echo $row["name"] ?>
                        </td>
                        <td class="text-right">
                            <?php echo number_format($row["amt"]) ?>
                        </td>
                    </tr>
                <?php }
                ?>
            </table>

        </td>
    </tr>
    <tr>
        <td>Total Stock Value</td>
        <td  class="text-right">
            <?= number_format($total) ?>
        </td>
    </tr>
</tbody>
</table>
