<?php
$currentYear = date('Y');
if (!isset($year)) {
    $year = date('Y');
}
$yearArray = [];
for ($index = 2018; $index <= $currentYear; $index++) {
    $yearArray[$index] = $index;
}

//$sql = "SELECT product_id, qty, amt, erp_store.part_number, erp_store.description FROM ( SELECT `product_id`, SUM(`quantity`) AS qty, SUM(`cost_price` * `quantity` ) AS amt FROM `erp_stock_ledger` WHERE `transaction_from` LIKE 'DELIVERY_NOTE' OR `transaction_from` LIKE 'CREDIT_NOTE' AND YEAR(transaction_date) = {$year} GROUP BY `product_id` ORDER BY SUM(`quantity`) ASC LIMIT 10 ) a JOIN erp_store ON (erp_store.id = a.product_id)";

$sql = "SELECT 
    product_id, 
    qty, 
    amt, 
    erp_store.part_number, 
    erp_store.description 
FROM (
    SELECT 
        `product_id`, 
        SUM(`quantity`) AS qty, 
        SUM(`cost_price` * `quantity`) AS amt 
    FROM 
        `erp_stock_ledger` 
    WHERE 
        (`transaction_from` LIKE 'DELIVERY_NOTE' OR `transaction_from` LIKE 'CREDIT_NOTE')
        AND YEAR(transaction_date) = {$year}
    GROUP BY 
        `product_id` 
    ORDER BY 
        qty ASC 
    LIMIT 10
) a 
JOIN erp_store ON (erp_store.id = a.product_id)";

$data = Yii::app()->db->createCommand($sql)->queryAll();
?>

<div class="custom-data-table">
    <h5>Top Ten Product sales in  <?= CHtml::dropDownList("top_ten_item", $year, $yearArray, array('onchange' => 'js:TopTenItem(this.value)')) ?></h5>
    <table class="table table-hover table-bordered" style="width: 100%" id="top-ten-customer">
        <thead>

            <tr>
                <th>#</th>
                <th>Item</th>
                <th class="text-right">Qty(<?= $year ?>)</th>
                <th class="text-right">Amount(<?= $year ?>)</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($data as $key => $value) {
                $id = $value["product_id"];
                $title = $value["part_number"] . " : " . $value["description"];
                ?>
                <tr  ondblclick=" productDetails('<?= $id ?>', '<?= $title ?>')">
                    <td><?= ($key + 1) ?></td>            
                    <td><?= $value["part_number"] ?> : <?= $value["description"] ?> </td>
                    <td class="text-right"><?= number_format((-1) * $value["qty"]) ?></td>
                    <td class="text-right"><?= number_format((-1) * $value["amt"]) ?></td>
                </tr>        
            <?php }
            ?>

        </tbody>
    </table>
</div>

