<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'lead-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    )); ?>
    <div class="tab-content">
        <div class="tab-pane active" id="tab1">            
            <?php echo $form->hiddenField($model, 'id'); ?>
            <input type="hidden" name="level" id="level" value="<?php echo $level; ?>">
            <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
            <ul class="clearfix form-ul material">
                <?php $customer_name = '';
                if ($model->crm_user_id > 0) {
                    $customer_name = $model->customer->customer_name;
                } ?>
                <li class="col-sm-3">
                    <?php echo CHtml::textField('customer_name', $customer_name, array('class' => 'tooltipster', 'title' => 'Customer', 'data-label' => 'Customer <span style="color:red">*</span>', 'readonly' => true)); ?>
                    <?php echo $form->hiddenField($model, 'customer_id'); ?>
                </li>
                <li class="col-sm-3">
                    <?php
                    if ($model->enq_date != '0000-00-00' && $model->enq_date != '') {
                        $model->enq_date = date("d/m/Y", strtotime($model->enq_date));
                    } else {
                        $model->enq_date = date('d/m/Y');
                    }
                    echo $form->textField($model, 'enq_date', array('class' => 'datepicker', 'title' => 'Enquiry Date', 'data-label' => 'Enquiry Date <span style="color:red">*</span>', 'readonly' => true)); ?>
                </li>
                <li class="col-sm-3">
                    <?php
                    if ($model->closing_date != '0000-00-00' && $model->closing_date != '') {
                        $model->closing_date = date("d/m/Y", strtotime($model->closing_date));
                    } else {
                        $model->closing_date = date('d/m/Y', strtotime('+7 days', strtotime(date('Y-m-d'))));
                    }
                    echo $form->textField($model, 'closing_date', array('class' => 'datepicker', 'title' => 'Closing Date', 'data-label' => 'Closing Date', 'readonly' => true)); ?>
                </li>
                <li class="col-sm-3">
                    <?php echo $form->dropDownList($model, 'source_of_lead', MasSourceOfLead::getSourceOfLeadList(), array('class' => 'tooltipster', 'title' => 'Source of Lead', 'data-label' => 'Source of Lead', 'empty' => '--Select--', 'disabled' => true)); ?>
                </li>
                <li class="col-sm-6">
                    <?php echo $form->textArea($model, 'remarks', array(
                        'class' => 'tooltipster',
                        'title' => 'Notes',
                        'value' => '',
                        'data-label' => 'Notes',
                    )); ?>
                </li>
            </ul>
        </div>
    </div> 
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="lead_close" data-dismiss="modal">Close</button>
        <?php
        $btn = 'Approve';
        $url = Yii::app()->createUrl('features/approvelevel/saveapprove');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#lead-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Lead Approved!","Success");
                    $("#lead_close").click();
                    reloadTable("#tbl_lead_details");
                } else {
                    $("#lead-form .lead-save-btn").prop("disabled", false);
                    $("#lead-form .lead-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#lead-form #"+key+"_em_").text(val).show();
                            t8.error(""+val+"");
                        });
                    }
                }',
                'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'lead-save-btn btn btn-theme'));
        $btn = 'Reject';
        $url = Yii::app()->createUrl('features/approvelevel/savereject');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#lead-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Lead Rejected!","Success");
                    $("#lead_close").click();
                    reloadTable("#tbl_lead_details");
                } else {
                    $("#lead-form .lead-save-btn").prop("disabled", false);
                    $("#lead-form .lead-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#lead-form #"+key+"_em_").text(val).show();
                        t8.error(""+val+"");
                    });
                }
            }',
            'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'lead-save-btn btn btn-theme')); ?>        
        <?php $this->endWidget(); ?>
    </div>
</div>