<?php
$currentUser = MasCompany::getCurrentUserERPSetting();
$erpsettings = MasCompany::getCurrentUserERPSetting();
if ($erpsettings == 'E') {
    $warehouseArray = MasInventoryWarehouse::getWarehouses();
}
if ($erpsettings == 'C') {
    $warehouseArray = MasInventoryWarehouse::getWarehousesCRM();
}
$readOnly = false;
if ($model->status == 'C') {
    $readOnly = true;
} ?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2 m-select">
                <?php echo $form->dropDownList($model, 'from_warehouse_id', $warehouseArray, array('class' => '', 'onChange' => 'getTowareHouse(this.value);clearTableInputs(this.value);', 'data-label' => 'From Warehouse <span style="color:red">*</span>', 'empty' => '--Select--', 'disabled' => $readOnly)); ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
                <input type="hidden" name="hid_from_warehouse_id" id="hid_from_warehouse_id" value="<?php echo $model->from_warehouse_id; ?>">
            </li>
            <div id="div_towarehouse">
                <li class="col-sm-2" id="to_ware_house_data">
                    <?php
                    if (empty($model->id)) {
                         if($model->from_warehouse_id>0)
                        echo $form->dropDownList($model, 'to_warehouse_id', MasInventoryWarehouse::getToWarehouses($model->from_warehouse_id), array('class' => '', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'empty' => '--Select--', 'onChange' => '', 'disabled' => $readOnly));
                         else
                        echo $form->dropDownList($model, 'to_warehouse_id', array(), array('class' => '', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'empty' => '--Select--', 'onChange' => '', 'disabled' => $readOnly));
                    } else {
                        echo $form->dropDownList($model, 'to_warehouse_id', MasInventoryWarehouse::getToWarehouses($model->from_warehouse_id), array('class' => '', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'empty' => '--Select--', 'onChange' => '', 'disabled' => $readOnly));
                    } ?>
                </li>
            </div>
            <?php
            $display = '';
            if ($model->lead_owner_id > 0) {
                $display = '';
            } ?>
            <li class="col-sm-2" id="div_lead_owner_id" style="<?php echo $display; ?>">
                <?php
                if ($_REQUEST['lead_owner_id']) {
                    $model->lead_owner_id = $_REQUEST['lead_owner_id'];
                }
                echo $form->dropDownList($model, 'lead_owner_id', User::getUser(), array('options' => array($model->lead_owner_id => array('selected' => true)), 'disabled' => $readOnly, 'data-label' => 'Technician <span style="color:red">*</span>', 'prompt' => '--Select--')); ?>
            </li>
            <li class="col-sm-2">
                <?php $model->customer_name = ($model->customer_id > 0) ? $model->customer->customer_name : ''; ?>
                <?php echo $form->textField($model, "customer_name", [
                    'class' => 'tooltipster',
                    'title' => 'Please choose a customer',
                    'data-label' => 'Customer <span style="color:red">*</span>',
                    'onKeyup' => 'js:autoCompleteMachineCustomer(this.id,"Machine");', 'readonly' => $readOnly
                ]); ?>
                <?php echo $form->hiddenField($model, "customer_id"); ?>
            </li>
            <li class="col-sm-2" id="div_customershippimg">
                <?php
                echo $form->dropDownList(
                    $model,
                    "outlet_id",
                    ($model->customer_id > 0) ? CustomerOutletLocation::getShippingLocation($model->customer_id) : [],
                    [
                        'data-label' => 'Outlet Location <span style="color:red">*</span>',
                        'class' => 'tooltipster',
                        'prompt' => 'Select', 'disabled' => $readOnly
                        //'onChange' => 'js:getOutletLocationDetails(this.id,"Machine");'
                    ]
                ); ?>
            </li>
            <li class="col-sm-2" id="div_InvoiceFileList">
                <?php
                $invoiceList = [];
                // If editing or viewing existing record — preload available invoices
                if ((int) $model->id > 0 && (int) $model->customer_id > 0) {
                    $condition = '1=1';
                    $condition .= ' AND customer_id=' . (int) $model->customer_id;
                    $orders = Order::model()->findAll([
                        'select' => 'id,file_id',
                        'condition' => $condition,
                        'limit' => 200
                    ]);
                    foreach ($orders as $order) {
                        $invoiceList[$order->id] = $order->file_id . ' : ' . $order->id;
                    }
                    echo $form->dropDownList(
                    $model,
                    "service_order_id",
                    $invoiceList,
                    [
                        'class' => 'tooltipster',
                        'data-label' => 'Service Order <span style="color:red">*</span>',
                        'prompt' => '--Select Order--',
                        'onchange' => 'js:setInvoiceId(this);', 'disabled' => $readOnly
                    ]
                );
                    
                }
                else if ($frm=="JO" && $job_id>0) {
                      $invoiceList[(int)$model->service_order_id] = $model->service_order_id.' : '.$model->file_id; 
                      $model->reference = $job_id;
                      echo $form->dropDownList(
                    $model,
                    "service_order_id",
                    $invoiceList,
                    [
                        'class' => 'tooltipster',
                        'data-label' => 'Service Order <span style="color:red">*</span>',
                          'disabled' => $readOnly
                    ]
                );
                }
                else
                {
                echo $form->dropDownList(
                    $model,
                    "service_order_id",
                    $invoiceList,
                    [
                        'class' => 'tooltipster',
                        'data-label' => 'Service Order <span style="color:red">*</span>',
                        'prompt' => '--Select Order--',
                        'onchange' => 'js:setInvoiceId(this);', 'disabled' => $readOnly
                    ]
                );
                }
                echo $form->hiddenField($model, "production_order_id");
                echo $form->hiddenField($model, "job_id");
                echo $form->hiddenField($model, "file_id");
                echo $form->hiddenField($model, "production_order_id");
                //echo $form->hiddenField($model, "service_order_id");
                ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'title' => 'Reference', 'data-label' => 'Reference ', 'readonly' => $readOnly)); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'transfer_date', array('class' => 'datepicker', 'title' => 'Transfer Date', 'data-label' => 'Transfer Date  <span style="color:red">*</span>', 'value' => date('d/m/y'), 'readonly' => $readOnly)); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textArea($model, 'direct_transfer_description', array('class' => 'tooltipster', 'title' => 'Description', 'data-label' => 'Description', 'readonly' => $readOnly)); ?>
            </li>
        </ul>
        <?php
        $cs = Yii::app()->getClientScript();
        $baseUrl = Yii::app()->baseUrl; ?>
        <div class="table-responsive">
            <table class="table table-hover table-bordered personal-task" id="transfer_item_table">
                <tr>
                    <th>No</th>
                    <th>Item</th>
                    <th>Item Description</th>
                    <th>Available Qty <span style="color:red">(Base Qty)</span></th>
                    <th>Transfer Qty</th>
                    <?php if ($model->status == 'C') { ?>
                        <th>Returned Qty</th>
                        <th>Used Qty</th>
                    <?php } ?>
                    <th>Unit</th>
                    <?php if (!(int) $model->id) { ?>
                        <th class="text-center">
                            <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTransferTableRow($('#transfer_item_table'));"><i class="fa fa-plus"></i></a>
                        </th>
                    <?php } ?>
                </tr>
                <?php
                foreach ($model_items as $i => $modeltransfer) {
                    //echo $modeltransfer->stock_ledger_id;
                    $returnedQty = $usedQty = 0;
                    if ($modeltransfer->stock_ledger_id && $model->status == 'C') {
                        $modeltransfer->balance_qty = (float) StockLedger::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'master_stock_ledger_id="' . $modeltransfer->stock_ledger_id . '" AND transaction_type="IN"'))->quantity;
                    }else{
                           $modeltransfer->available_qty = (float) ProductLocation::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '" AND warehouse_id=' . $model->from_warehouse_id))->quantity;
                    }
                    if ((int) $model->id > 0) {
                        $modeltransfer->available_qty = (float) ProductLocation::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '" AND warehouse_id=' . $model->from_warehouse_id))->quantity;
                    } ?>
                    <tr>
                        <td><label><?php echo ($i + 1); ?></label></td>
                        <td>
                            <?php echo $form->textField($modeltransfer, "[" . $i . "]item_name", array('class' => 'tooltipster go', 'placeholder' => 'Type & Select', 'onKeyup' => 'js:autoCompleteProduct(this.id,"transfer");', 'title' => 'Select product', 'readonly' => $readOnly)); ?>
                            <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]id"); ?>
                            <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]item_id"); ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]id"); ?>
                        </td>
                        <td>
                            <?php echo $form->textArea($modeltransfer, "[" . $i . "]item_description", array('class' => 'tooltipster desc go', 'title' => 'Add Description here', 'readonly' => $readOnly)); ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]item_description"); ?>
                        </td>
                        <td>
                            <?php echo $form->textField($modeltransfer, "[" . $i . "]available_qty", array('class' => 'qty go cell-center text-right', 'readonly' => true)); ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]available_qty"); ?>
                        </td>
                        <td>
                            <?php echo $form->textField($modeltransfer, "[" . $i . "]transfer_qty", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeyup' => 'checkVal(this.id,this.value);', 'readonly' => $readOnly)); ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]transfer_qty"); ?>
                        </td>
                        <?php if ($model->status == 'C') { ?>
                            <td>
                                <?php echo $form->textField($modeltransfer, "[" . $i . "]balance_qty", array('class' => 'qty go cell-center text-right', 'readonly' => true )); ?>
                            </td>
                            <td>
                                <?php echo ((int) $modeltransfer->transfer_qty - (int) $modeltransfer->balance_qty );?>
                            </td>
                        <?php } ?>
                        <td id="unit_<?php echo $i; ?>">
                            <?php
                            ($modeltransfer->item_id > 0) ? $data = UnitOfMeasurement::getUnits($modeltransfer->item_id) : $data = array();
                            echo $form->dropdownlist($modeltransfer, "[" . $i . "]unit", $data, array('class' => 'qty go', 'disable' => $readOnly)); ?>
                        </td>
                        <?php if (!(int) $model->id) { ?>
                            <td class="text-center nw" width="1%">
                                <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'rmRow($(\'#transfer_item_table\'),this,this.id)', 'title' => 'Remove this item', 'id' => 'ProductLocation_' . $i)); ?>
                            </td>
                        <?php } ?>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getTowareHouse", " function getTowareHouse(from_id) {
    if(from_id>0){
        $('#stock_details_table').html('');
    }    
    jQuery.ajax({
        'dataType':'json', 
        'type': 'post',
        'url': '" . Yii::app()->createUrl('iwarehouse/getTowarehouseLocation') . "',
        'data': {'from_id':from_id, 'type':'issue'},
        'cache': false,
        'success': function(data) {            
            $('#to_ware_house_data').html(data.towarehouse);
        }
    });
}", CClientScript::POS_HEAD);
$cs->registerScript("checkVal", "function checkVal(field_id,qty) {
    var arr_fields= field_id.split('_');
    var model_name   = arr_fields[0];
    var row_field  = arr_fields[1];   
    var max_qty = parseFloat($('#InventoryDirectTransferItem_'+row_field+'_available_qty').val());
    if(parseFloat(qty) > max_qty){
        $('#InventoryDirectTransferItem_'+row_field+'_transfer_qty').val('');
    }        
    var current_product_id = parseInt($('#InventoryDirectTransferItem_'+row_field+'_item_id').val());
    var table_length = $('#transfer_item_table').find('tr:gt(0)').length; 
    if(table_length>0){
        var prd_qty=0;
        for(i=0;i<table_length;i++){
            var product_id = $('#InventoryDirectTransferItem_'+i+'_item_id').val();
            var product_qty = parseInt($('#InventoryDirectTransferItem_'+i+'_transfer_qty').val());
            if(current_product_id==product_id){
                prd_qty+=product_qty;
            }
        }
    }
    if(parseInt(prd_qty) > max_qty){
        $('#InventoryDirectTransferItem_'+row_field+'_transfer_qty').val('');
        t8.error('Quatity not available for this product','');
    }
}", CClientScript::POS_HEAD);
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id,frm) {
    var from_warehouse_id   = $('#InventoryDirectTransfer_from_warehouse_id').val();
    var to_warehouse_id     = $('#InventoryDirectTransfer_to_warehouse_id').val();
    var lead_owner_id     = $('#InventoryDirectTransfer_lead_owner_id').val();
    var customer_name     = $('#InventoryDirectTransfer_customer_name').val();
    var outlet_id     = $('#InventoryDirectTransfer_outlet_id').val();
    var file_id     = $('#InventoryDirectTransfer_file_id').val();
    if(from_warehouse_id=='' || to_warehouse_id ==''){
        t8.error('Please select warehouse'); 
        $('#'+field_id).val('');
        return false;
    } else if (lead_owner_id == '') {
        t8.error('Please select technician'); 
        $('#'+field_id).val('');
        return false;
    } else if (customer_name == '') {
        t8.error('Please select customer'); 
        $('#'+field_id).val('');
        return false;
    } else if (outlet_id == '') {
        t8.error('Please select outlet'); 
        $('#'+field_id).val('');
        return false;
    } else if (file_id == '') {
        t8.error('Please select order'); 
        $('#'+field_id).val('');
        return false;
    } else {
        var url = '" . Yii::app()->createUrl('iwarehouse/GetAllProducts') . "'+'&frm='+frm+'&from_warehouse_id='+from_warehouse_id+'&to_warehouse_id='+to_warehouse_id+'&type=issue';
        $('#'+field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id   =   $(event.target).attr('id');
                var product_id=ui.item.value;
                var id=ui.item.value;
                var desc=ui.item.description;
                var quantity=ui.item.total_q;
                if(quantity == null){
                    quantity=0;
                }
                var unit_id=ui.item.unit_id;
                var unit_name=ui.item.unit_name;
                var arr_fields= field_id.split('_');
                var model_name   = arr_fields[0];
                var row_field  = arr_fields[1];
                var part_number=ui.item.part_number;
                var bar_code= ui.item.bar_code;      
                var available_qty= ui.item.other;
                $('#InventoryDirectTransferItem_'+row_field+'_item_name').val(part_number);
                $('#InventoryDirectTransferItem_'+row_field+'_item_description').val(desc);
                $('#InventoryDirectTransferItem_'+row_field+'_unit_id').val(unit_id); //for showing hidden field
                $('#InventoryDirectTransferItem_'+row_field+'_unit').val(unit_name); //FOR SHOWING UNIT NAME
                $('#InventoryDirectTransferItem_'+row_field+'_product_id').val(product_id);
                $('#InventoryDirectTransferItem_'+row_field+'_item_id').val(id);
                $('#InventoryDirectTransferItem_'+row_field+'_available_qty').val(available_qty);
                $('#InventoryDirectTransferItem_'+row_field+'_bar_code').val(bar_code);      
                if(product_id > 0){
                    jQuery.ajax({
                        'type': 'post',
                        'dataType': 'json',
                        'url': '" . Yii::app()->createUrl('iwarehouse/GetProductOtherDetails') . "',
                        'data': {'row_field' : row_field, 'product_id' : product_id,'from_warehouse_id':from_warehouse_id,'type' : 'direct'},
                        'cache': false,
                        'success': function(data) {
                            var total_allocated_qty         =   data.total_allocated_qty;
                            var total_available_qty         =   data.total_available_qty;
                            var warehouse_available_qty     =   data.warehouse_available_qty;
                            //var free_qty                    =   warehouse_available_qty-allocated_qty;                         
                            //$('#InventoryDirectTransferItem_'+row_field+'_allocated_qty').val(allocated_qty);
                            $('#InventoryDirectTransferItem_'+row_field+'_available_qty').val(warehouse_available_qty);
                            $('#unit_'+row_field).html(data.unitdrop);
                            return false;
                        }
                    });
                }   
            }
        })
    }
}
function autoCompleteMachineCustomer(field_id, frm) {
    var from_warehouse_id   = $('#InventoryDirectTransfer_from_warehouse_id').val();
    var to_warehouse_id     = $('#InventoryDirectTransfer_to_warehouse_id').val();
    var lead_owner_id     = $('#InventoryDirectTransfer_lead_owner_id').val();
    if(from_warehouse_id=='' || to_warehouse_id ==''){
        t8.error('Please select warehouse'); 
        $('#'+field_id).val('');
        return false;
    } else if (lead_owner_id == '') {
        t8.error('Please select technician'); 
        $('#'+field_id).val('');
        return false;
    } else {
        var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "' + '&frm=' + frm;
        $('#' + field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
            select: function (event, ui) {
                event.preventDefault();
                var arr_fields= field_id.split('_');
                var model_name   = arr_fields[0];
                var row_field  = arr_fields[1];
                var customer_id = ui.item.value;
                $('#InventoryDirectTransfer_customer_id').val(customer_id);
                $('#customer_name').val(ui.item.label);
                // Loop through each row in the table and update Outlet dropdowns
                $('#transfer_item_table tbody tr').each(function (index, tr) {
                    var arr_fields= field_id.split('_');
                    var model_name   = arr_fields[0];
                    var row_field  = arr_fields[1];
                    var row = $(tr);
                    var rowIndex = row.data('index') || index;
                    $.ajax({
                        type: 'POST',
                        dataType: 'json',
                        url: '" . Yii::app()->createUrl('iwarehouse/getCustomerShippingdetails') . "',
                        data: { id: customer_id, row_index: rowIndex, type: 'issue', row: row_field },
                        success: function (data) {
                            $('#div_customershippimg').html(data.dtship);
                            //getOutletLocationDetails();
                        }
                    });
                    leadownerMachines(customer_id);
                    leadownerMachinesInvoice(field_id);
                });
            }
        });
    }
}
", CClientScript::POS_HEAD);
$cs->registerScript("leadownerMachines", "function leadownerMachines(customer_id) {
    var outlet_id = $('#InventoryDirectTransfer_outlet_id').val();
    var customer_id = $('#InventoryDirectTransfer_customer_id').val();
    if ( customer_id=='') {
        t8.error('Please choose a Customer');
        $('#serial_no').val('');
        return false;
    } else {
        jQuery.ajax({
            data: { id: customer_id,outlet_id:outlet_id },
            type: 'post',
            url: '" . Yii::app()->createUrl('sales/schedule/Getmachinedetails') . "',
            success: function (data) {
                $('#tbl_repair_request').html(data);
            }
        });
        return true;
    }
}
", CClientScript::POS_HEAD);

$cs->registerScript("leadownerMachinesInvoice", "function leadownerMachinesInvoice(field_id, frm) {
    var lead_owner_id = $('#InventoryDirectTransfer_lead_owner_id').val();
    var customer_id = $('#InventoryDirectTransfer_customer_id').val();
    var arr_fields= field_id.split('_');
    var model_name   = arr_fields[0];
    var row_field  = arr_fields[1];
    if ( customer_id=='') {
        t8.error('Please choose a Customer');
        $('#serial_no').val('');
        return false;
    } else {
        jQuery.ajax({
            data: { 'lead_owner_id': lead_owner_id, 'customer_id': customer_id, 'columnWidth': 4, type: 'issue', row : row_field },
            dataType: 'json',
            type: 'get',
            url: '" . Yii::app()->createUrl('iwarehouse/GetInvoiceDropdown') . "',
            success: function(data) {
                $('#div_InvoiceFileList').html(data.dropdown);
                window.salesGroupMap = data.sales_groups || {};
                window.assignedUser = data.assigned_users || {};
            }
        });
        return true;
    }
}
", CClientScript::POS_HEAD);
$cs->registerScript("FetchData", "function FetchData(Qty,field_id,event) {
    if (event.keyCode == 13) {
        event.preventDefault();
        var arr_fields   = field_id.split('_');
        var model_name   = arr_fields[0];
        var row_field    = arr_fields[1];    
        var from_warehouse = $('#InventoryDirectTransfer_from_warehouse_id').val();
        var to_warehouse = $('#InventoryDirectTransfer_to_warehouse_id').val();
        var product_id = $('#InventoryDirectTransferItem_'+row_field+'_item_id').val();
        var rows = $('#table-stock-details').find('tr:gt(0)').length;    
        if(rows>0){
            var lastRowId = $('#table-stock-details').find('tr:last input:first').attr('id');
            var split_id  = lastRowId.match(/\d+/g);
            var rows   = Number(split_id);
            rows  = rows+1;
        }
        if(from_warehouse > 0 && to_warehouse > 0){
            if(from_warehouse === to_warehouse){
                t8.error('Choose Distinct Warehouses!');
                return false;
            }else{
                var i=0;
                var products = [];
                for (i=0; i<= rows; i++){
                    try{
                        if($('#Data_'+i+'_product_id').val() > 0 && products.includes($('#Data_'+i+'_product_id').val()) === false)
                            products.push($('#Data_'+i+'_product_id').val());
                    }catch(e){}
                }     
                var sum_qty  = 0;
                $('#table-stock-details').find('tr.transfer_pro_'+product_id).remove();
                if(products.includes(product_id)){                        
                    for (j=0; j<= rows; j++){        
                        if($('#InventoryDirectTransferItem_'+j+'_item_id').val() == product_id & $('#InventoryDirectTransferItem_'+j+'_transfer_qty').val() >0){
                            sum_qty+=parseInt($('#InventoryDirectTransferItem_'+j+'_transfer_qty').val());    
                        }
                    }
                    Qty  = sum_qty;
                }    
                //if(products.includes(product_id))
                    //return false;
                //else{       
                    if(product_id > 0 && Qty > 0){            
                        jQuery.ajax({
                            'type': 'post',
                            'url': '" . Yii::app()->createUrl('iwarehouse/getStockDetails') . "',
                            'data': {'product_id' : product_id, 'Qty' : Qty, 'length' : rows, 'from_warehouse' : from_warehouse, 'to_warehouse' : to_warehouse},
                            'cache': false,
                            'success': function(data) {
                                $('#div_stock').show();
                                if(data != '')
                                    $('.no-data-tr').remove(); 
                                $('#stock_details_table').append(data);
                                return false;
                            }
                        });
                    }
                    return false;
                //}
            }
        }else{
            t8.error('Choose Warehouses!');
            return false;
        }
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("verifyQty", "function verifyQty(field_id,qty) {
    if(parseInt(qty) > 0){
        var arr_fields= field_id.split('_');
        var model_name   = arr_fields[0];
        var row_field  = arr_fields[1];       
        var max_qty = parseInt($('#Data_'+row_field+'_qty_available').val());   
        if(parseInt(qty) > max_qty){
            $('#Data_'+row_field+'_available_qty').val('');
        } 
    }    
}", CClientScript::POS_HEAD);
$cs->registerScript("rmRow ", "function rmRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var rows = $('#table-stock-details').find('tr:gt(0)').length;
    var pro_id = $('#InventoryDirectTransferItem_'+row_field+'_item_id').val();
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        $(evt).parents('tr').remove();
        for (i=0; i<= rows; i++){
            try{
                if($('#Data_'+i+'_product_id').val()  === pro_id){
                        $('.pro'+pro_id).remove();
                }
            }catch(e){}
        } 
        autoarrange();
    }else{
        alert('Atleast one item needed here','Alert');
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("autoarrange", "function autoarrange(){                                
    var i=0;
    $('#table-stock-details').find('tr:gt(0)').each(function() {       
        $(this).find('input,tr,select,textarea,.errorMessage').each(function() {                   
            old_id   =   $(this).attr('id');
            new_id   =   old_id.replace(/\d+/,i);
            $(this).attr('id',new_id);
            old_name =   $(this).attr('name');
            if(old_name!==undefined) {
                new_name =   old_name.replace(/\d+/,i);
                $(this).attr('name',new_name);
            } 
        });
        $(this).find('td:first label').html(++i); 
    });         
}", CClientScript::POS_HEAD);
$cs->registerScript("getFactor", "function getFactor(field_id,value) {
    var arr_fields= field_id.split('_');
    var model_name   = arr_fields[0];
    var row_field  = arr_fields[1];   
    jQuery.ajax({
        'type': 'post',
        'url': '" . Yii::app()->createUrl('iwarehouse/GetFactor') . "',
        'data': {'value' : value},
        'cache': false,
        'success': function(data) {
            $('#InventoryDirectTransferItem_'+row_field+'_factor').val(data);
            return false;
        }
    });    
}", CClientScript::POS_HEAD);
$cs->registerScript("clearTableInputs", "function clearTableInputs(frm_warehouse_id) { 
    $('#InventoryDirectTransfer_lead_owner_id').val('');
    if($('#InventoryDirectTransferItem_0_item_id').val() > 0){
        var r = confirm('Are you sure you want to change From Warehouse? If you change warehouse, the below table content will be lose');
	    if(r==true) {
	        $('#hid_from_warehouse_id').val(frm_warehouse_id);
            $('#transfer_item_table').find(':input').each(function() {         
                $(this).val('');           
            });
	    }else{
	        var old_from_warehouse_id = $('#hid_from_warehouse_id').val();
	        $('#InventoryDirectTransfer_from_warehouse_id').val(old_from_warehouse_id);        
	    }
    }else{
        $('#hid_from_warehouse_id').val(frm_warehouse_id);
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("addTransferTableRow", " function addTransferTableRow(jQtable) {
    var table_length=$('#transfer_item_table').find('tr:gt(0)').length;
    if(table_length<30){
        formId              =   jQtable.attr('id');
        formIdStarter       =   jQtable.attr('id').split(/_(.+)?/)[0];
        lastId = jQtable.find('tr:last input:first').attr('id');
        thenum = lastId.match(/\d+/g);
        newId = Number(thenum) + 1;
        newrow= jQtable.find('tr:last').clone();
        newrow.find('label:first').html(newId+1);
        newrow.attr('class',newId);
        newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a,span').each(function() {
            this.id= this.id.replace(/\d+/,newId);
            this.value  = '';
            (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   '';
        });
        jQtable.append(newrow);
        $('#InventoryIndirectTransferItem_'+newId+'_factor').val(1);
        $('#QuotesItem_'+newId+'_product_name').focus();
    }else{
        t8.error('Maximum number of rows exceeded');
    }
}", CClientScript::POS_HEAD); ?>
<?php
$script = "function handleKeyPress(event, field) {
    if (event.key === 'Enter') {
        event.preventDefault();
        var field_id = field.id;
        var barcode = field.value;
        var arr_fields = field_id.split('_');
        var model_name = arr_fields[0];
        var row_field = arr_fields[1];
        entertext(field_id, barcode);
    }
}
function entertext(field_id, barcode) {
    var arr_fields = field_id.split('_');
    var model_name = arr_fields[0];
    var row_field = arr_fields[1];
    var from_warehouse_id = $('#InventoryDirectTransfer_from_warehouse_id').val();
    var to_warehouse_id = $('#InventoryDirectTransfer_to_warehouse_id').val();
    if (from_warehouse_id == '') {
        t8.error('Please select from warehouse');
        $('#' + field_id).val('');
        return false;
    } else {
        $.ajax({
            url: '" . Yii::app()->createUrl('iwarehouse/GetProductsWithBarcode') . "',
            type: 'POST',
            dataType: 'json',
            data: {
                from_warehouse_id: from_warehouse_id,
                to_warehouse_id: to_warehouse_id,
                barcode: barcode
            },
            'cache': false,
            'success': function(data) { 
                if(data.msg=='success'){
                    var arr_fields = field_id.split('_');
                    var model_name = arr_fields[0];
                    var row_field = arr_fields[1];
                    var product_id = data.product_id;
                    $('#InventoryDirectTransferItem_' + row_field + '_item_description').val(data.description);
                    $('#InventoryDirectTransferItem_'+row_field+'_item_name').val(data.part_number);
                    $('#InventoryDirectTransferItem_'+row_field+'_unit_id').val(data.unit_id); 
                    $('#InventoryDirectTransferItem_'+row_field+'_unit').val(data.unit_name); 
                    $('#InventoryDirectTransferItem_'+row_field+'_item_id').val(product_id); 
                    if(product_id > 0){
                        jQuery.ajax({
                            'type': 'post',
                            'dataType': 'json',
                            'url': '" . Yii::app()->createUrl('iwarehouse/GetProductOtherDetails') . "',
                            'data': {'row_field' : row_field, 'product_id' : product_id,'from_warehouse_id':from_warehouse_id,'type' : 'direct'},
                            'cache': false,
                            'success': function(data) {
                                var total_allocated_qty         =   data.total_allocated_qty;
                                var total_available_qty         =   data.total_available_qty;
                                var warehouse_available_qty     =   data.warehouse_available_qty;
                                //var free_qty                  =   warehouse_available_qty-allocated_qty;
                                //$('#InventoryDirectTransferItem_'+row_field+'_allocated_qty').val(allocated_qty);
                                $('#InventoryDirectTransferItem_'+row_field+'_available_qty').val(warehouse_available_qty);
                                $('#unit_'+row_field).html(data.unitdrop);
                                return false;
                            }
                        });                
                    }
                }else{    
                    t8.error('This Barcode Not Exist');       
                    return false;
                }
            }
        });
    }
}";
Yii::app()->getClientScript()->registerScript('entertext', $script, CClientScript::POS_READY); ?>