<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'transfer-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-3 m-select">
        <?php
        $warehouse_array = array();
        $ModelUser = User::model()->findByPk((int) Yii::app()->user->id);
        if (!empty($ModelUser))
            // $warehouse_array = MasInventoryWarehouse::getUserAvailableWarehousees($ModelUser->available_warehouses);
            $warehouse_array = MasInventoryWarehouse::getWarehouses($ModelUser->available_warehouses);
        ?>
        <?php echo $form->dropDownList($model, 'to_warehouse_id', $warehouse_array, array('class' => '', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'empty' => '--Select--', 'onChange' => 'getReferenceIds(this.value);')); ?>
        <input type="hidden" id="hide_ref_if" value="<?php echo $model->id; ?>">

        <?php if ($type == 'convert') {
            $model->id = 0;
        }
        ?>
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php if ($frm == 'in') {
            $model->from_warehouse_id = MasInventoryWarehouse::getWarehouseIdByCode();
            echo $form->hiddenField($model, 'from_warehouse_id');
        } ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'customer_name', array('class' => 'tooltipster', 'value' => $customer_name, 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompleteCustomerList(this.id,"transfer");', 'readonly' => $con)); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
    </li>
    <div id="refenence_id_div">
        <li class="col-sm-3">
            <?php if (empty($model->id)) { ?>
                <?php echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'title' => 'Reference', 'data-label' => 'Reference')); ?>
            <?php } else { ?>
                <?php
                $referenceData = InventoryIndirectTransfer::getRefernceIds($model->from_warehouse_id);
                echo CHtml::activeDropDownList(
                    $model,
                    'reference',
                    $referenceData,
                    array(
                        'class' => 'tooltipster',
                        'multiple' => 'multiple',
                        'data-label' => 'Reference <span style="color:red;">*</span>',
                        'onChange' => 'getProductDetails()' // Note the brackets to call the function
                    )
                );
                ?>
            <?php } ?>
        </li>
    </div>

    <li class="col-sm-3">
        <?php echo $form->textField($model, 'transfer_date', array('class' => 'datepicker', 'title' => 'Transfer Date', 'data-label' => 'Transfer Date', 'value' => date('d/m/y'))); ?>
    </li>

    <li class="col-sm-8">
        <?php echo $form->textArea($model, 'indirect_transfer_description', array('class' => 'tooltipster', 'title' => 'Description', 'data-label' => 'Description')); ?>
    </li>


</ul>

<!--//'onKeyup' => 'js:autoCompleteProduct(this.id,"lead");-->
<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

?>

<div id="div_transfer_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="transfer_item_table">
            <tr>
                <th>No</th>
                <th>Item</th>
                <th>Item Description</th>
                <th>Total Quantity</th>
                <!-- <th>Allocated Qty</th> -->
                <!-- <th>Transferred Qty</th> -->
                <th>Received Qty</th>
                <th>Missing Qty</th>
                <th>Damaged Qty</th>
                <th>Unit</th>
                <!-- <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);"
                        onclick="addTableRow($('#transfer_item_table'));"><i class="fa fa-plus"></i></a>
                </th> -->

            </tr>

            <?php

            foreach ($model_items as $i => $modeltransfer) {
                //$allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'product_id="'.$modeltransfer->item_id.'" and file_id="'.$file_id.'"')); 
                $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '"'));
                $total_available_product = ProductLocation::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '"'));
                $free_quantity = $total_available_product->quantity - $total_allocated_product->quantity;
                $total_qty = $total_available_product->quantity;
                ?>

                <tr>
                    <td><label><?php echo ($i + 1); ?></label></td>

                    <td>
                        <?php echo $form->textField($modeltransfer, "[" . $i . "]item_name", array('class' => 'tooltipster go', 'placeholder' => 'Type & Select', 'onKeyup' => 'js:autoCompleteProduct(this.id,"transfer");', 'title' => 'Select product')); ?>

                        <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]id"); ?>
                        <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]item_id"); ?>
                        <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]indirect_transfer_id"); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]id"); ?>


                    </td>
                    <td>
                        <?php echo $form->textArea($modeltransfer, "[" . $i . "]item_description", array('class' => 'tooltipster desc go', 'title' => 'Add Description here')); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]item_description"); ?>

                    </td>
                    <td>
                        <?php
                        echo $form->textField($modeltransfer, "[" . $i . "]transfer_qty", array('class' => 'qty go cell-center text-right', 'onkeyup' => 'checkVal(this.id,this.value);', 'onkeypress' => 'return isPositiveNumber(event)')); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]transfer_qty"); ?>
                        <?php //echo CHtml::hiddenField("InventoryIndirectTransferItem[" . $i . "][transfer_qty]", '1'); ?>
                    </td>
                    <td>
                        <?php
                        echo $form->textField($modeltransfer, "[" . $i . "]transferred_qty", array('class' => 'qty go cell-center text-right', 'onkeyup' => 'checkVal(this.id,this.value);', 'onkeypress' => 'return isPositiveNumber(event)')); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]transferred_qty"); ?>
                        <?php //echo CHtml::hiddenField("InventoryIndirectTransferItem[" . $i . "][transferred_qty]", '1'); ?>
                    </td>
                    <td>
                        <?php
                        echo $form->textField($modeltransfer, "[" . $i . "]missing_qty", array('class' => 'qty go cell-center text-right', 'onkeyup' => 'checkVal(this.id,this.value);', 'onkeypress' => 'return isPositiveNumber(event)')); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]missing_qty"); ?>
                        <?php //echo CHtml::hiddenField("InventoryIndirectTransferItem[" . $i . "][missing_qty]", '1'); ?>
                    </td>
                    <td>
                        <?php
                        echo $form->textField($modeltransfer, "[" . $i . "]damaged_qty", array('class' => 'qty go cell-center text-right', 'onkeyup' => 'checkVal(this.id,this.value);', 'onkeypress' => 'return isPositiveNumber(event)')); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]damaged_qty"); ?>
                        <?php //echo CHtml::hiddenField("InventoryIndirectTransferItem[" . $i . "][damaged_qty]", '1'); ?>
                    </td>
                    <td id="unit_<?php echo $i; ?>">
                        <?php
                        ($modeltransfer->item_id > 0) ? $data = UnitOfMeasurement::getUnits($modeltransfer->item_id) : $data = array();
                        ?>
                        <?php echo $form->dropdownlist($modeltransfer, "[" . $i . "]unit", $data, array('class' => 'qty go')); ?>

                    </td>

                    <!-- <td class="text-center nw" width="1%">
                        <?php //echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeTable($(\'#transfer_item_table\'),this,this.id)', 'title' => 'Remove this item', 'id' => 'ProductLocation_' . $i)); ?>
                    </td> -->

                </tr>
            <?php } ?>

        </table>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="ind_close" data-dismiss="modal">Close</button>
        <?php
        if ($type != 'view') {
            $url = Yii::app()->createUrl('iwarehouse/SaveIndirectTransferIn');
            echo CHtml::ajaxSubmitButton('Transfer', $url, array(
                'dataType' => 'json',
                'type' => 'post',
                'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Saved Successfully!");
                                         $("#ind_close").click();
                                        //  location.reload();
                                         reloadTable("#tble_check_in");
                                         reloadTable("#tbl_InTransit_details");
                                         reloadTable("#tbl_directtransfer_in_details");
                                         
                                    } else {
                                        if (Array.isArray(data.errors)) {
                                            data.errors.forEach(function(errorMsg) {
                                                console.log("errorMsg"+errorMsg);
                                                t8.error(errorMsg);
                                            });
                                        }else{
                                            t8.error(data.errors);
                                        }
                                        $("#transfer-form .transfer-save-btn").prop("disabled", false);
                                        $("#transfer-form .transfer-save-btn").addClass("btn-theme").removeClass("btn_loding");

 
                                    } 
                                    }',


            ), array('id' => 'mybtn' . rand(), 'class' => 'transfer-save-btn btn btn-theme'));
        }
        ?>

    </div>
    <?php $this->endWidget(); ?>

    <?php
    $cs = Yii::app()->getClientScript();





    $cs = Yii::app()->getClientScript();
    $cs->registerScript("FetchData", "function FetchData(Qty,field_id,event)
    {
        if (event.keyCode == 13 || event.keyCode == 9) {

            event.preventDefault();
            var arr_fields   = field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field    = arr_fields[1];
            
            
            var from_warehouse = $('#InventoryIndirectTransfer_from_warehouse_id').val();
            var to_warehouse = 0;
            var product_id = $('#InventoryIndirectTransferItem_'+row_field+'_item_id').val();
            var rows = $('#table-stock-details').find('tr:gt(0)').length;
            
            if(rows>0){
                var lastRowId = $('#table-stock-details').find('tr:last input:first').attr('id');
                var split_id  = lastRowId.match(/\d+/g);
                var rows   = Number(split_id);
                rows  = rows+1;
           }
            
            

            if(from_warehouse > 0){
                //alert(from_warehouse);
                    var i=0;
                    var products = [];
        
                    for (i=0; i<= rows; i++){
                        try{
                           // alert($('#Data_'+i+'_product_id').val());
                            if($('#Data_'+i+'_product_id').val() > 0 && products.includes($('#Data_'+i+'_product_id').val()) === false)
                                products.push($('#Data_'+i+'_product_id').val());
                        }catch(e){}
                    } 
                    
                    var sum_qty  = 0;
                    $('#table-stock-details').find('tr.indirecttransfer_pro_'+product_id).remove();
                    if(products.includes(product_id)){
                        
                        for (j=0; j<= rows; j++){
                            
                            if($('#InventoryIndirectTransferItem_'+j+'_item_id').val() == product_id & $('#InventoryIndirectTransferItem_'+j+'_transfer_qty').val() >0){
                                sum_qty+=parseInt($('#InventoryIndirectTransferItem_'+j+'_transfer_qty').val());
                                
                            }
                        }
                        Qty  = sum_qty;
                    }
                    
                    //if(products.includes(product_id))
                        //return false;
                    //else{
                       
                            if(product_id > 0 && Qty > 0){
                                
                                jQuery.ajax({
                                    'type': 'post',
                                    'url': '" . Yii::app()->createUrl('iwarehouse/getStockDetails_indirectTrans') . "',
                                    'data': {'product_id' : product_id, 'Qty' : Qty, 'length' : rows, 'from_warehouse' : from_warehouse, 'to_warehouse' : to_warehouse},
                                    'cache': false,
                                    'success': function(data) {
                                        $('#div_stock').show();
                                        if(data != '')
                                            $('.no-data-tr').remove(); 
                                        $('#stock_details_table').append(data);
                                        return false;
                                    }
                                });
                            }
                        return false;
                    //}                
            }else{
                t8.error('Choose Warehouses!');
                return false;
            }
        }
    }", CClientScript::POS_HEAD);

    $cs->registerScript("verifyQty", "function verifyQty(field_id,qty)
    {
    
         if(parseInt(qty) > 0){
            var arr_fields= field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field  = arr_fields[1];   
            
            var max_qty = parseInt($('#Data_'+row_field+'_qty_available').val());
           
            if(parseInt(qty) > max_qty){
                $('#Data_'+row_field+'_picked_qty').val('');
            }

          

        }
        
    }", CClientScript::POS_HEAD);

    $cs->registerScript("getReferenceIds", " function getReferenceIds(from_id) {
    
        var from_id  = $('#InventoryIndirectTransfer_to_warehouse_id').val();
        var customer_id  = $('#InventoryIndirectTransfer_customer_id').val();
        var ref_id = $('#hide_ref_if').val();
        jQuery.ajax({
            'dataType':'json', 
            'type': 'post',
            'url': '" . Yii::app()->createUrl('iwarehouse/getReferenceIds') . "',
            'data': {'from_id':from_id,'customer_id':customer_id},
            'cache': false,
            'success': function(data) {            
                $('#refenence_id_div').html(data.dt);
                $('#InventoryIndirectTransfer_reference').val(ref_id);
                $('#InventoryIndirectTransfer_reference').multiselect('refresh');
            }
        });

    }", CClientScript::POS_HEAD);
    Yii::app()->getClientScript()->registerScript('entertext', $script, CClientScript::POS_READY);


    $cs->registerScript("autoarrange", "function autoarrange(){                                
                    var i=0;
                   $('#table-stock-details').find('tr:gt(0)').each(function() {       
                            $(this).find('input,tr,select,textarea,.errorMessage').each(function()
                            {                   
                                old_id   =   $(this).attr('id');
                                new_id   =   old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                               
                                old_name =   $(this).attr('name');
                                if(old_name!==undefined) {
                                    new_name =   old_name.replace(/\d+/,i);
                                    $(this).attr('name',new_name);
                                } 
                            });
                            $(this).find('td:first label').html(++i); 
                    });         
    }", CClientScript::POS_HEAD);
    $cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id,frm)
    {
        
            var url = '" . Yii::app()->createUrl('iwarehouse/GetProducts') . "'+'&frm='+frm;
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
                select          : function( event, ui ) {
                    event.preventDefault();
                    trigger_target_id   =   $(event.target).attr('id');
                    var product_id=ui.item.value;
                    var name=ui.item.part_number;
                    var id=ui.item.value;
                    var desc=ui.item.description;
                    var unit_id=ui.item.unit_id;
                    var unit_name=ui.item.unit_name;
                    var quantity=ui.item.total_q;
                    var allocated_qty=ui.item.allocated_qty;
                    var total_qty=ui.item.total_qty;
                    var free_qty=  total_qty-allocated_qty;        
                    if(quantity == null){
                        quantity=0;
                    }
                    var arr_fields= field_id.split('_');
                    var model_name   = arr_fields[0];
                    var row_field  = arr_fields[1];
                    $('#InventoryIndirectTransferItem_'+row_field+'_item_description').val(desc);
                    $('#InventoryIndirectTransferItem_'+row_field+'_unit_id').val(unit_id); //for showing hidden field
                    $('#InventoryIndirectTransferItem_'+row_field+'_unit').val(unit_name); //FOR SHOWING UNIT NAME
                    $('#InventoryIndirectTransferItem_'+row_field+'_product_id').val(product_id);
                    $('#InventoryIndirectTransferItem_'+row_field+'_available_qty').val(quantity);
                    $('#InventoryIndirectTransferItem_'+row_field+'_item_id').val(id);
                    $('#InventoryIndirectTransferItem_'+row_field+'_item_name').val(name);
                 $('#InventoryIndirectTransferItem_'+row_field+'_allocated_qty').attr( 'readonly', true );
                 $('#InventoryIndirectTransferItem_'+row_field+'_total_qty').attr( 'readonly', true );                      
                 $('#InventoryIndirectTransferItem_'+row_field+'_allocated_qty').val(allocated_qty);
                 $('#InventoryIndirectTransferItem_'+row_field+'_total_qty').val(total_qty);    
                 $('#InventoryIndirectTransferItem_'+row_field+'_pickable_quantity').val(free_qty);
                 $('#InventoryIndirectTransferItem_'+row_field+'_transfer_qty').val('');
                    if(product_id > 0){
                        jQuery.ajax({
                           'type': 'post',
                           'dataType': 'json',
                           'url': '" . Yii::app()->createUrl('iwarehouse/getunitdrop') . "',
                           'data': {'row_field' : row_field, 'product_id' : product_id,'type' : 'indirect'},
                           'cache': false,
                           'success': function(data) {
                               $('#unit_'+row_field).html(data.drop);
                               return false;
                           }
                       });
                    }
                }
            });
        

    }", CClientScript::POS_HEAD);
    $cs->registerScript("removeTable ", "function removeTable(jQtable,evt,field_id) {
        var arr_fields= field_id.split('_');
        
        var row_field=arr_fields[1];
        var id=$('#ProductLocation_'+row_field+'_id').val();
           formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
                var num_rows    =   jQtable.find('tr:gt(0)').length;
                if(num_rows>1){
                    var tr  =   $(evt).parent().parent();
                    if(isRowEmpty(tr)) { 
                        if(id!=''){
                                jQuery.ajax({

                                        'type': 'post',
                                        'dataType': 'json',
                                        'url': '" . Yii::app()->createUrl('requisition/DeleteRequisitionItem') . "',
                                        'data': {'id':id}  ,
                                        'cache': false,
                                        'success': function(data) {
                                            if(data.status=='success'){
                                                $(evt).parents('tr').remove();
                                                var i=0;
                                                jQtable.find('tr:gt(0)').each(function() { $(this).find('input,textarea,.errorMessage').each(function()
                                                {
                                                old_id   =   $(this).attr('id');
                                                new_id   =   old_id.replace(/\d+/,i);
                                                $(this).attr('id',new_id);
                                                old_name =   $(this).attr('name');
                                                if(old_name!==undefined) {
                                                new_name =   old_name.replace(/\d+/,i);
                                                $(this).attr('name',new_name);} });
                                                $(this).find('td:first label').html(++i); }); 
                                                 t8.success('Item Deleted','success');
                                                 $.pnotify_remove_all();
                                            }else{
                                              t8.error('Deletion Not Possible, History Exist','error');
                                              
                                            }                         
                                        }
                                });
                                var rows = $('#table-stock-details').find('tr:gt(0)').length;
                                var pro_id = $('#InventoryIndirectTransferItem_'+row_field+'_item_id').val();
                                var num_rows    =   $('#transfer_item_table').find('tr:gt(0)').length;
                                if(num_rows>1){
                                    
                                    for (i=0; i<= rows; i++){
                                        try{
                                            if($('#Data_'+i+'_product_id').val()  === pro_id){
                                                    $('.TR-'+i).remove();
                                            }
                    
                                        }catch(e){}
                                    } 
                                }
                            }else{
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() { $(this).find('input,textarea,.errorMessage').each(function()
                                {
                                old_id   =   $(this).attr('id');
                                new_id   =   old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                                old_name =   $(this).attr('name');
                                if(old_name!==undefined) {
                                new_name =   old_name.replace(/\d+/,i);
                                $(this).attr('name',new_name);} });
                                $(this).find('td:first label').html(++i); }); 
                            }
                            

                    }else {
                        alert('Atleast one item needed here','Alert');
                    }
            }     
    };", CClientScript::POS_HEAD);
    $cs->registerScript("getFactor", "function getFactor(field_id,value)
    {
        var arr_fields= field_id.split('_');
        var model_name   = arr_fields[0];
        var row_field  = arr_fields[1];   
        jQuery.ajax({
            'type': 'post',
            'url': '" . Yii::app()->createUrl('iwarehouse/GetFactor') . "',
            'data': {'value' : value},
            'cache': false,
            'success': function(data) {
                $('#InventoryIndirectTransferItem_'+row_field+'_factor').val(data);
                return false;
            }
        });
        
    }", CClientScript::POS_HEAD);
    $cs->registerScript("checkVal", "function checkVal(field_id,qty)
    {
            var arr_fields= field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field  = arr_fields[1];   
            var max_qty = parseInt($('#InventoryIndirectTransferItem_'+row_field+'_pickable_quantity').val());
            if(parseInt(qty) > max_qty){
                $('#InventoryIndirectTransferItem_'+row_field+'_transfer_qty').val('');
            }
            
            
            var current_product_id = parseInt($('#InventoryIndirectTransferItem_'+row_field+'_item_id').val());
            var table_length = $('#transfer_item_table').find('tr:gt(0)').length; 
            if(table_length>0){
                var prd_qty=0;
                for(i=0;i<table_length;i++){
                    var product_id = $('#InventoryIndirectTransferItem_'+i+'_item_id').val();
                    var product_qty = parseInt($('#InventoryIndirectTransferItem_'+i+'_transfer_qty').val());
                    if(current_product_id==product_id){
                        prd_qty+=product_qty;
                    }
                    
                }
                
            }
            
            if(parseInt(prd_qty) > max_qty){
                $('#InventoryIndirectTransferItem_'+row_field+'_transfer_qty').val('');
                t8.error('Quatity not available for this product','');
            }
    }", CClientScript::POS_HEAD);
    $cs->registerScript("getDestinationwareHouse", "
    function getDestinationwareHouse(to_id) {
        if (to_id > 0) {
            $('#stock_details_table').html('');
        }
        var frm = $('#frm').val();
        console.log(frm);
        var from_id = $('#InventoryIndirectTransfer_from_warehouse_id').val();
        var dest_id = $('#hid_dest_warehouse_id').val();

        jQuery.ajax({
            dataType: 'json',
            type: 'post',
            url: '" . Yii::app()->createUrl('iwarehouse/getDestinationwarehouseLocation') . "',
            data: { to_id: to_id, from_id: from_id, dest_id: dest_id },
            cache: false,
            success: function(data) {
                $('#destination_ware_house_data').html(data.towarehouse);
            }
        });

    }

    // On page load
    jQuery(function() {
        var to_id = $('#InventoryDirectTransfer_to_warehouse_id').val();
        if (to_id) {
            getDestinationwareHouse(to_id);
        }

        // Change event for to_warehouse
        $('#InventoryDirectTransfer_to_warehouse_id').on('change', function() {
            var to_id = $(this).val();
            getDestinationwareHouse(to_id);
        });

        var frm = $('#frm').val();
        if (frm === 'out') {
            var from_id = $('#InventoryDirectTransfer_from_warehouse_id').val();
            if (from_id) {
                getTowareHouse(from_id);
            }

            // Optionally bind change event if you want it dynamic too
            $('#InventoryDirectTransfer_from_warehouse_id').on('change', function() {
                var from_id = $(this).val();
                if (from_id) {
                    getTowareHouse(from_id);
                }
            });
        }
    });
", CClientScript::POS_HEAD);
    ?>

    <script>
        $(document).on('change', '#InventoryIndirectTransfer_reference', function () {
            getProductDetails();
        });
        function getProductDetails() {
            console.log("Dropdown changed");

            var selectedRefs = $("#InventoryIndirectTransfer_reference").val(); // get selected reference IDs (multi-select)
            var customer_id = $('#InventoryIndirectTransfer_customer_id').val();
            if (selectedRefs.length === 0) {
                $('#transfer_item_table').find("tr:gt(0)").remove(); // remove all rows except header
                return;
            }

            $.ajax({
                type: "POST",
                url: "<?php echo Yii::app()->createUrl('iwarehouse/getItemDetails'); ?>", // FIXED: added quotes and semicolon
                data: { reference_ids: selectedRefs },
                success: function (response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        $("#transfer_item_table").find("tr:gt(0)").remove(); // clear existing rows except header
                        $("#transfer_item_table").append(data.html); // append new rows
                        // $("#InventoryIndirectTransfer_customer_name").val(data.customerNamesStr); // append new rows
                        // $("#InventoryIndirectTransfer_customer_name").addClass('filled'); // append new rows
                        // $("#InventoryIndirectTransfer_customer_name").prop('readonly', true);


                    } else {
                        alert("No data found.");
                    }
                },
                error: function () {
                    alert("Error retrieving data.");
                }
            });
        }
    </script>
    <script>
        $(document).ready(function () {
            var warehouseId = $('#InventoryIndirectTransfer_from_warehouse_id').val();

            if (parseInt(warehouseId) > 0) {
                getReferenceIds(warehouseId);
            }
        });
    </script>
    <script>
        function autoCompleteCustomerList(fieldId, frmValue) {
            $("#" + fieldId).autocomplete({
                minLength: 2, // start searching after typing 2 chars
                delay: 300,
                source: function (request, response) {
                    $.ajax({
                        url: "<?php echo Yii::app()->createUrl('customer/GetCustomerDetails'); ?>",
                        dataType: "json",
                        data: {
                            frm: frmValue,
                            term: request.term
                        },
                        success: function (data) {

                            response($.map(data, function (item) {
                                return {
                                    label: item.label,
                                    value: item.customername,
                                    id: item.value
                                };
                            }));

                        }
                    });
                },
                select: function (event, ui) {
                    // Set the hidden customer_id and visible customer_name
                    $("#InventoryIndirectTransfer_customer_id").val(ui.item.id);
                    $("#" + fieldId).val(ui.item.value);
                    getReferenceIds();
                    return false;
                }
            });
        }
    </script>