<script type="text/javascript">
$(document).ready(function () {
    var table_id = "#tbl_directtransfer_details";
    var table = $(table_id).DataTable({
        scrollY: "380px",
        pageLength: 50,
        processing: true,
        "columnDefs": [
            {
                "targets": [5],
                "visible": false,
            },
        ],
        ajax: {
            url: "<?php echo Yii::app()->createUrl('iwarehouse/Getlistmeterial'); ?>",
            type: "POST",
            cache: false,
        },
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            $("#tbl_directtransfer_details tbody").mousedown(function (e) {
                $(this).contextMenu({
                    selector: ".context-menu",
                    callback: function (key, options) {
                        var action_id = key;
                        var data = table.row(this).data();
                        var id = data[0];
                        var part_number = data[2];
                        var status = data[6];
                        if (action_id == "convert") {
                            loadPopupModal("iwarehouse/convertmeterial&id=" + id + "&status=" + status, "Return Oil - " + id, "xl");
                        /*} else if (action_id == "edit") {
                            loadPopupModal("iwarehouse/createmeterial&id=" + id + "&status=" + status, "Edit Issual - " + id, "xl");*/
                        }
                    },
                    items: {
                        <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_convert']) || Yii::app()->user->authorised_user == 1) { ?>
                            "convert": { name: "Return Oil", icon: "fa-retweet" },
                        <?php }?>
                        <?php /*if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_edit"])) { ?>
                            "edit": { name: "Edit", icon: "fa-edit" },
                        <?php }*/ ?>
                    }
                });
            });
        }
    });
    $(".dataTables_scrollFoot").hide();
});
</script>

        
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix panel-theame">Oil Issual
                <div class="pull-right">
                    <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_add']) || Yii::app()->user->authorised_user == 1) { ?>
                        <a class="ad-btn" onclick="loadPopupModal('iwarehouse/createmeterial','Add Oil Issual','xl')" title="Add Oil Issual"><svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                            <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        </svg></a>
                    <?php } ?>
                </div>
            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_directtransfer_details" style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>Transfer No</th>
                                <th>Transfer Date</th>
                                <th>From Warehouse</th>
                                <th>To Warehouse</th>
                                <th>Assigned User</th>
                                <th>Description</th>
                                <th>Reference</th>
                                <?php  //if (isset(Yii::app()->user->havePermissionOn['direct_transfer_print']) || isset(Yii::app()->user->havePermissionOn['direct_transfer_excel']) || Yii::app()->user->authorised_user == 1) { ?>
                                    <!-- <th>Actions</th> -->
                                <?php //} ?>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
