<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'transfer-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
$erpsettings = MasCompany::getCurrentUserERPSetting();
if ($erpsettings == 'E') {
    $warehouseArray = MasInventoryWarehouse::getWarehouses();
}
if ($erpsettings == 'C') {
    $warehouseArray = MasInventoryWarehouse::getWarehousesCRM();
} ?>
<ul class="clearfix form-ul material">
    <li class="col-sm-2 m-select">
        <?php $model->from_warehouse_name = $warehouseArray[$model->from_warehouse_id];
        echo $form->textField($model, 'from_warehouse_name', array('class' => 'tooltipster', 'title' => 'From Warehouse', 'data-label' => 'From Warehouse <span style="color:red">*</span>', 'readonly' => true)); ?>
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->hiddenField($model, "from_warehouse_id"); ?>
    </li>
    <div id="div_towarehouse">
        <li class="col-sm-2" id="to_ware_house_data">
            <?php $model->to_warehouse_name = $warehouseArray[$model->to_warehouse_id];
            echo $form->textField($model, 'to_warehouse_name', array('class' => 'tooltipster', 'title' => 'To Warehouse', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'readonly' => true)); ?>
            <?php echo $form->hiddenField($model, "to_warehouse_id"); ?>
        </li>
    </div>
    <li class="col-sm-2" id="div_lead_owner_id">
        <?php $userArray = User::getUser();
        $model->lead_owner_name = $userArray[$model->lead_owner_id];
        echo $form->textField($model, 'lead_owner_name', array('class' => 'tooltipster', 'title' => 'Technician', 'data-label' => 'Technician <span style="color:red">*</span>', 'readonly' => true)); ?>
        <?php echo $form->hiddenField($model, "lead_owner_id"); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'title' => 'Reference', 'data-label' => 'Reference <span style="color:red">*</span>', 'readonly' => true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'transfer_date', array('class' => 'datepicker', 'title' => 'Transfer Date', 'data-label' => 'Transfer Date  <span style="color:red">*</span>', 'value' => date('d/m/y'), 'readonly' => true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textArea($model, 'direct_transfer_description', array('class' => 'tooltipster', 'title' => 'Description', 'data-label' => 'Description', 'readonly' => true)); ?>
    </li>
</ul>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl; ?>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="transfer_item_table">
        <tr>
            <th>No</th>
            <th>Customer</th>
            <th>Outlet</th>
            <th>Order</th>
            <th>Item</th>
            <th>Item Description</th>
            <th>Transfer Qty</th>
            <th>Balance Qty</th>
            <th>Unit</th>
        </tr>
        <?php
        foreach ($model_items as $i => $modeltransfer) {
            if ((int) $model->id > 0) {
                $modeltransfer->available_qty = (float) ProductLocation::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '" AND warehouse_id=' . $model->from_warehouse_id))->quantity;
            } ?>
            <tr>
                <td><label><?php echo ($i + 1); ?></label></td>
                <td>
                    <?php $modeltransfer->customer_name = ($modeltransfer->customer_id > 0) ? $modeltransfer->customer->customer_name : ''; ?>
                    <?php echo $form->textField($modeltransfer, "[" . $i . "]customer_name", [
                        'class' => 'tooltipster go',
                        'title' => 'Please choose a customer',
                        'data-label' => 'Customer <span style="color:red">*</span>',
                        'readonly' => true
                    ]); ?>
                    <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]customer_id"); ?>
                </td>
                <td id="div_customershippimg_<?= $i; ?>">
                    <?php
                    $modeltransfer->balance_qty = 0;
                    $modeltransfer->outlet_name = CustomerOutletLocation::getShippingLocationById($modeltransfer->outlet_id)[$modeltransfer->outlet_id];
                    echo $form->textField($modeltransfer, "[" . $i . "]outlet_name", array('class' => 'tooltipster go', 'placeholder' => '', 'title' => 'Order', 'readonly' => true)); ?>
                    <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]outlet_id"); ?>
                </td>
                <td id="div_InvoiceFileList_<?= $i; ?>">
                    <?php
                    echo $form->textField($modeltransfer, "[" . $i . "]file_id", array('class' => 'tooltipster go', 'placeholder' => '', 'title' => 'Order', 'readonly' => true));
                    echo $form->hiddenField($modeltransfer, "[" . $i . "]production_order_id");?>
                </td>
                <td>
                    <?php echo $form->textField($modeltransfer, "[" . $i . "]item_name", array('class' => 'tooltipster go', 'placeholder' => 'Type & Select', 'title' => 'Select product', 'readonly' => true)); ?>
                    <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]id"); ?>
                    <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]item_id"); ?>
                    <?php echo $form->error($modeltransfer, "[" . $i . "]id"); ?>
                </td>
                <td>
                    <?php echo $form->textArea($modeltransfer, "[" . $i . "]item_description", array('class' => 'tooltipster desc go', 'title' => 'Add Description here', 'readonly' => true)); ?>
                    <?php echo $form->error($modeltransfer, "[" . $i . "]item_description"); ?>
                </td>
                <td>
                    <?php echo $form->textField($modeltransfer, "[" . $i . "]transfer_qty", array('class' => 'qty go cell-center text-right', 'readonly' => true)); ?>
                    <?php echo $form->error($modeltransfer, "[" . $i . "]transfer_qty"); ?>
                </td>
                <?php if ((int) $model->id > 0) { ?>
                <td>
                    <?php echo $form->textField($modeltransfer, "[" . $i . "]balance_qty", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeyup' => 'checkVal(this.id,this.value);', )); ?>
                    <?php echo $form->error($modeltransfer, "[" . $i . "]balance_qty"); ?>
                </td>
                <?php } ?>
                <td id="unit_<?php echo $i; ?>">
                    <?php
                    ($modeltransfer->item_id > 0) ? $data = UnitOfMeasurement::getUnits($modeltransfer->item_id) : $data = array();
                    echo $form->dropdownlist($modeltransfer, "[" . $i . "]unit", $data, array('class' => 'qty go')); ?>
                </td>
            </tr>
        <?php } ?>
    </table>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
    <?php
    $submitLabel = "Return Oil";
    $url = Yii::app()->createUrl('iwarehouse/SaveTransferIssue');
    echo CHtml::ajaxSubmitButton($submitLabel, $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                t8.success("Tansfer No. "+data.id+" Saved Successfully!");
                $(".x.close").click();
                $("#loader").hide();
                $("#pk_li").click();
                reloadTable("#tbl_directtransfer_details");
            } else { 
                $("#loader").hide();
                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){                                        
            $(".toast8-error").hide();
            $("#loader").show();                                                         
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'transfer-save-btn btn btn-theme')); ?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("checkVal", "function checkVal(field_id,qty) {
    var arr_fields= field_id.split('_');
    var model_name   = arr_fields[0];
    var row_field  = arr_fields[1];   
    var max_qty = parseFloat($('#InventoryDirectTransferItem_'+row_field+'_available_qty').val());
    if(parseFloat(qty) > max_qty){
        $('#InventoryDirectTransferItem_'+row_field+'_transfer_qty').val('');
    }        
    var current_product_id = parseInt($('#InventoryDirectTransferItem_'+row_field+'_item_id').val());
    var table_length = $('#transfer_item_table').find('tr:gt(0)').length; 
    if(table_length>0){
        var prd_qty=0;
        for(i=0;i<table_length;i++){
            var product_id = $('#InventoryDirectTransferItem_'+i+'_item_id').val();
            var product_qty = parseInt($('#InventoryDirectTransferItem_'+i+'_transfer_qty').val());
            if(current_product_id==product_id){
                prd_qty+=product_qty;
            }
        }
    }
    if(parseInt(prd_qty) > max_qty){
        $('#InventoryDirectTransferItem_'+row_field+'_transfer_qty').val('');
        t8.error('Quatity not available for this product','');
    }
}", CClientScript::POS_HEAD); ?>