<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("issueposted", "function creditnoteposted(issue_id) {
    jConfirm('Confirm Posting  of Issue No -'+issue_id+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':issue_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/Posting/PostIssue') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Issue Posted!');
                            reloadTable('#tbl_issues_details');
                        }else{
                            $.each(data, function(key, val) {
                                t8.error(val);
                            });
                        }
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
                });
            }
        });
};", CClientScript::POS_HEAD);
?>

<script>
    $(document).ready(function() {
        loadIssueList();
    });

    function loadIssueList() {
        var table_id = "#tbl_issues_details";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.warehouse_id = $("#warehouse_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            /*columns: [
    { className: "nw sl col-max-1" }, // ID
    { className: "nw sl col-max-1" }, // PRD.no
    { className: "nw sl col-max-2" }, // Issue Date
    { className: "nw sl col-max-3" }, // Customer
    { className: "nw sl col-max-3" }, // Reference
    { className: "nw sl col-max-2" }  // Status
],*/
            "columnDefs": [{
                  "targets": [7],
                 "visible": false, 
            }, ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('issues/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            }
        });
        $('#tbl_issues_details tbody').on('mouseover', 'tr', function() {
            $.contextMenu('destroy');
        });
        $('#tbl_issues_details tbody').on('click', 'tr', function() {
            var data = table.row(this).data();
            var posted = data[7].posted;
            var ticket = data[7].ticket;
            $.contextMenu({
                selector: '.context-menu',
                callback: function(key, options) {
                    var action_id = key;
                    var id = data[0];

                    if (action_id == "print") {
                        window.open($('#liveSite').val() + "/index.php?r=issues/PrintPDF&id=" + id, "_blank")
                    }
                },
                items: {

                    <?php // if (isset(Yii::app()->user->havePermissionOn['mov_issue_view']) || Yii::app()->user->authorised_user == 1) { ?>
                        // "view": {name: "View", icon: "fa-eye"},
                    <?php // } ?>
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_mov_issue_print"])) { ?> "print": {
                            name: "Print",
                            icon: "fa-print"
                        },
                    <?php } ?>


                    <?php /*if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_issues_post_to_finance"])) { ?> "post": {
                            name: "Post to Accounts",
                            icon: "fa-arrow-right",
                            accesskey: "d",
                            callback: function() {
                                creditnoteposted(data[0]);
                                // posted(aData[10]);
                            },
                            disabled: function(key, opt) {
                             //"If the issue has a ticket,  it should be taken from the invoice.
                                if (posted == 'Y') {
                                    //    if (posted == 'Y' || ticket == 'Y') {
                                    return !this.data('postDisabled');
                                }
                            }
                        },
                    <?php }*/ ?>

                }
            });
        });
    }
</script>

   <header class="panel-heading clearfix panel-theame">
                <!-- <i class="fa fa-area-chart"></i>--> Goods Issues
        <div class="pull-right">
            <?php /*if (isset(Yii::app()->user->havePermissionOn['inv_mov_issue_add']) || Yii::app()->user->authorised_user == 1) { ?>
               <a class="ad-btn" onclick="loadPopupModal('issues/create', 'Issue', 'xl')" title="Add">  <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
        xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
          <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
          <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
          <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
        </svg></a>
            <?php }*/ ?>
        </div>
    </header>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="li_issue_index_1" onclick="reloadTable('#tbl_packing_list');" class="active"><a href="#issue_index_1" data-toggle="tab"> <i class="fa fa-area-chart"></i> Packaging</a></li>
    <li id="li_issue_index_2" onclick="reloadTable('#tbl_issues_details');"><a href="#issue_index_2" data-toggle="tab"><i class="fa fa-area-chart"></i> Issues</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="issue_index_1">
        <section class="panel" style="background-color:#F6F3EE;">
         
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_packing_list" style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>Issue No</th>
                                <th>Prd.No</th>
                                <th>Issue Date</th>
                                <th>Customer</th>
                                <th>File#</th>
                                <th>Order#</th>
                                <th></th>
                                <th></th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <div class="tab-pane" id="issue_index_2">
        <section class="panel" style="background-color:#F6F3EE;">

            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_issues_details" style="font-size:13px;">
                        <thead>
                          <tr>
                                <th>Issue No</th>
                                <th>Prd.No</th>
                                <th>Issue Date</th>
                                <th>Customer</th>
                                <th>File#</th>
                                <th>Order#</th>
                                
                                <th>Reference</th>
                            </tr>
                        </thead>
                       
                    </table>
                </div>
            </div>
        </section>
    </div>


</div>

<script>
    $(document).ready(function() {
        loadPackageList();
    });

    function loadPackageList() {
        var table_id = "#tbl_packing_list";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            // data.warehouse_id = $("#warehouse_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            /*columns: [{
                    className: "nw sl col-max-1"
                },
                {
                    className: "nw sl col-max-3"
                },
                {
                    className: "nw sl col-max-3"
                },
                {
                    className: "nw sl col-max-3"
                },
                {
                    className: "nw sl col-max-0"
                },
                {
                    className: "nw sl col-max-0"
                },
                {
                    className: "nw sl col-max-2"
                },
            ],*/
            "columnDefs": [{
                "targets": [6,7],
                "visible": false,
            }, ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('packaging/GetList&frm=GI') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            }
        });
        $('#tbl_packing_list tbody').on('mouseover', 'tr', function() {
            $.contextMenu('destroy');
        });
        $('#tbl_packing_list tbody').on('click', 'tr', function() {
            var data = table.row(this).data();
            var type = data[7];
            $.contextMenu({
                selector: '.context-menu',
                callback: function(key, options) {
                    var action_id = key;
                    var data = table.row(this).data();
                    var id = data[0];
                    var status = data[6];
                    var type = data[7];
                    if (action_id == "convert") {
                        loadPopupModal("packaging/create&id=" + id + "&status=" + status, "Convert - " + id, "lg");
                    } else if (action_id == "print" && status == "GI") {
                        window.open($('#liveSite').val() + "/index.php?r=issues/PrintPDF&id=" + id, "_blank")
                    } else if (action_id == "edit" && status == "GI") {
                        loadPopupModal("issues/create&id=" + id + "&status=" + status, "Edit - " + id, "xl");
                    }
                },
                items: {
                    <?php /*if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_mov_issue_convert"])) { ?> 
                        "convert": {
                            name: "Convert",
                            icon: "fa-retweet"
                        },
                    <?php }*/ ?>
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_mov_issue_print"])) { ?> 
                        "print": {
                            name: "Print",
                            icon: "fa-print"
                        },
                    <?php } ?>
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_mov_issue_edit"])) { ?> "edit": {
                            name: "Edit",
                            icon: "fa-edit",
                            accesskey: "d",
                            disabled: function(key, opt) {
                                if (type == 'S') {
                                    return !this.data('editDisabled');
                                }
                            }
                        },
                    <?php } ?>

                }
            });
        });
    }
</script>