<?php

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'upload-inventory-list-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="row">
    <ul class="clearfix form-ul material">
        <input type="hidden" id="inventory_item_type" value="<?php echo $inventory_item_type; ?>">

        <li class="col-sm-2">
            <?php
            $allowedExtensions = array("csv");
            $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                'id' => 'inventory_list_0_upload_csv', //rand(),//'inventory_list_0_upload_csv',
                'config' => array(
                    'action' => Yii::app()->createUrl('inventory/Uploadinv', array('folder' => 'upload/inventoryuploadlist_csv')),
                    'multiple' => false,
                    'allowedExtensions' => $allowedExtensions,
                    'sizeLimit' => 1 * 1024 * 1024,
                    'onStart' => "js:function(){}",
                    'class' => 'pull-right',
                    'onComplete' => "js:function(id, fileName, responseJSON){
                                $('#inventory_list_file_name').val(responseJSON.filename);
                                InventoryListUpload1(responseJSON.filename)
                            }",
                )
            ));
            ?>
        </li>
        <li class="col-sm-2">
            <div id="csv_msg">
            </div>
        </li>

        <li class="col-sm-4">
            <?= CHtml::link('Download template', array('inventoryupload/downloadinventorylistformat1'), array('target' => '_blank')); ?>
        </li>
        <!-- <li>
                            <a title="Download Existing File" class="btn btn-primary btn-xs" onclick="downloadExistFile();"><i class="fa fa-download"></i> &nbsp;Download</a>
                        </li> -->
        <!-- Download Existing File -->
        <?php  //if ($existing_pricing_group_file_name!=''){
        //   echo '<a href ="'.Yii::app()->createUrl("/inventory/DownloadInventoryList") .'" class="btn btn-primary btn-xs">
        // <i class="fa fa-download" title="Download Existing File"></i></a> ';
        //echo $existing_pricing_group_file_name;
        ?>

        <?php  //}
        ?>

    </ul>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="btn_inventory_upload_close">Close</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();

$cs->registerScript("InventoryListUpload1", "function InventoryListUpload1(filename)
{
var inventory_item_type= $('#inventory_item_type').val();	

if(filename != ''){
  jQuery.ajax({
    'type': 'post',
    'dataType': 'json',
    'data': {
             filename: filename, inventory_item_type: inventory_item_type
            },
    'url'  : '" . Yii::app()->createUrl('inventoryupload/SaveUploadInventoryList') . "',
    'cache': false,
    'success': function (data) {
      if (data.status == 'success') {
        $('#loader').hide();
        console.log(data.error_url);
        console.log(data.link);
         if(data.error!=''){
           $('#csv_msg').html(data.link);
		   
		       $.each(data.error, function(key, val) {
                           t8.error(''+val+''); 
                   }); 
        }else{
			
		t8.success('Details Uploaded Successfully');	
		$('#btn_inventory_upload_close').click();	
		}
      }
      else{
         $('#loader').hide();
        console.log(data.error_url);
        console.log(data.link);
         if(data.error_url!=''){
           $('#csv_msg').html(data.link);
		   
		       $.each(data.error, function(key, val) {
                           t8.error(''+val+''); 
                   }); 
        } 
      }
    },
    'beforeSend':function(){
            $('#loader').show();
    },
    'complete':function(){
        $('#loader').hide();
    }
  });
}else{
	t8.error('File not found');
	
}
}", CClientScript::POS_HEAD);

?>
<script>
    function uploadStockData() {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl('inventoryupload/UploadStockWithSerialNo'); ?>',
            dataType: 'json',
            beforeSend: function() {
                $('#loader').show();
            },
            success: function(response) {
                $('#loader').show();
                if (response.status === 'success') {
                    $('#loader').hide();
                    // Check for remaining items and update the link if provided
                    if (response.remaining > 0 && response.link) {
                        // $('#upload-stock-container').html(response.link);
                        $('#btn_inventory_upload_close').css('display', 'none');

                        $('#remaining_count_msg').html('Remaining items to upload Stock: ' + response.remaining).css('color', 'red');

                        //  t8.error('There are ' + response.remaining + ' items remaining to upload Stock.');
                        loadPopupModal("Inventoryupload/index&id=" + data.invoice_id, "Upload Inventory List", "lg");

                    } else {
                        t8.success(response.message);
                        $('#btn_inventory_upload_close').click();
                        //  $('#upload-stock-container').html('');
                    }


                } else {
                    t8.error(response.message);
                }
            },
            error: function() {
                t8.error('There was an error with the request.');
            }
        });
    }
</script>

