<style>
    .the-legend {
        border-style: none;
        border-width: 0;
        font-size: 15px;
        line-height: 20px;
        margin-bottom: 0;
        width: auto;
        padding: 6px 17px;
        border: 1px solid #e0e0e0;
        background: #1f67b2;
        color: white;
        font-weight: 500;
        border-radius: 18px 2%;
    }

    .the-fieldset {
        border: 1px solid #e0e0e0;
        padding: 10px;
        background: #d2e8ffa3;
        border-radius: 5px;

    }
</style>
<script>
    function uploadStockData() {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl('inventoryupload/uploadStock'); ?>',
            dataType: 'json',
            beforeSend: function() {
                $('#loader').show();
            },
            success: function(response) {
                $('#loader').show();
                if (response.status === 'success') {
                    $('#loader').hide();
                    // Check for remaining items and update the link if provided
                    if (response.remaining > 0 && response.link) {
                        // $('#upload-stock-container').html(response.link);
                        $('#btn_inventory_upload_close').css('display', 'none');

                        $('#remaining_count_msg').html('Remaining items to upload Stock: ' + response.remaining).css('color', 'red');

                        //  t8.error('There are ' + response.remaining + ' items remaining to upload Stock.');
                        loadPopupModal("Inventoryupload/index&id=" + data.invoice_id, "Upload Inventory List", "lg");

                    } else {
                        t8.success(response.message);
                        $('#btn_inventory_upload_close').click();
                        //  $('#upload-stock-container').html('');
                    }


                } else {
                    t8.error(response.message);
                }
            },
            error: function() {
                t8.error('There was an error with the request.');
            }
        });
    }
</script>


<?php

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'upload-inventory-list-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>

<ul class="clearfix form-ul material">
<input type="hidden" id="inventory_item_type" value="<?php echo $inventory_item_type; ?>">
    <fieldset class="the-fieldset">

        <li class="col-sm-4">
            <?php
            $allowedExtensions = array("csv");
            $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                'id' => 'inventory_list_0_upload_csv', //rand(),//'inventory_list_0_upload_csv',
                'config' => array(
                    'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/upload', array('folder' => 'upload/inventoryuploadlist_csv')),
                    'multiple' => false,
                    'allowedExtensions' => $allowedExtensions,
                    'sizeLimit' => 1 * 1024 * 1024,
                    'onStart' => "js:function(){}",
                    'class' => 'pull-right',
                    'onComplete' => "js:function(id, fileName, responseJSON){
                                $('#inventory_list_file_name').val(responseJSON.filename);
                                InventoryListUpload1(responseJSON.filename)
                            }",
                )
            ));
            ?>

        </li>
        <li class="col-sm-4">
            <div id="csv_msg">
            </div>
        </li>

        <li class="col-sm-4">
            <?= CHtml::link(
                'Download Template',
                array('inventoryupload/downloadinventorylistformat'),
                array('class' => 'btn btn-primary btn-s', 'target' => '_blank')
            ); ?>
            <br><br>
            <label id="total_count_msg"></label>
            <label id="remaining_count_msg"></label>

        </li>

    </fieldset>
</ul>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="btn_inventory_upload_close">Close</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();

$cs->registerScript("InventoryListUpload1", "function InventoryListUpload1(filename)
{
var inventory_item_type= $('#inventory_item_type').val();	
    if (filename != '') {
        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'data': {
                filename: filename, inventory_item_type: inventory_item_type
            },
            'url': '" . Yii::app()->createUrl('inventoryupload/SaveUploadInventoryList') . "',
            'cache': false,
            'success': function (data) {
                $('#loader').hide();
                if (data.status == 'success') {
                    console.log(data.error_url);
                    console.log(data.link);
                    console.log(data.upload_count);

                    if (data.error && data.error.length > 0) {


                        $('#csv_msg').html(data.link);

                        $.each(data.error, function (key, val) {
                            t8.error('' + val + '');
                        });
                    } else {
                        t8.success('Details Uploaded Successfully');
                        $('#btn_inventory_upload_close').click();
                    }
                } else {
                    console.log(data.error_url);
                    console.log(data.link);
                    console.log(data.upload_count);

                    if (data.error_url && data.error_url !== '') {
                                            $('#btn_inventory_upload_close').css('display', 'none');

                        $('#total_count_msg').html('Total items to upload Stock: ' + data.upload_count).css('color', 'green');

                        $('#csv_msg').html(data.link);
                        $.each(data.error, function (key, val) {
                            t8.error('' + val + '');
                        });
                    }
                }
            },
            'beforeSend': function () {
                $('#loader').show();
            },
            'complete': function () {
                $('#loader').hide();
            }
        });
    } else {
        t8.error('File not found');
    }
}", CClientScript::POS_HEAD);


?>