<div class="card p-3">
    <div class="row mb-3" style="margin-bottom: 12px;">
        <div class="col-md-4" style="float: right;">
            <input type="text" id="product_search" class="form-control" placeholder="Search Product by Name / Part No">
            <input type="hidden" id="product_id">
        </div>
    </div>

    <div class="table-responsive" style="max-height:400px; overflow-y:auto; border:1px solid #dee2e6;">
        <table id="serial_list_table" class="table table-striped table-bordered mb-0" width="100%">
            <thead class="table-light" style="position: sticky; top: 0; z-index: 2;">
                <tr>
                    <th style="width:25%">Product (Part No)</th>
                    <th style="width:35%">Description</th>
                    <th style="width:20%">Serial Number</th>
                    <th style="width:20%">Changed Serial Number</th>
                </tr>
            </thead>
            <tbody id="serial_list_body">
                <tr>
                    <td colspan="4" class="text-center">No serial numbers found</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="modal-footer">
        <div class="text-end mt-3" style="float: right;">
            <button id="save_serials" class="btn btn-primary">Save Changes</button>
        </div>
    </div>
</div>

<?php
$fetchUrl = Yii::app()->createUrl('inventory/getSerialList');
$saveUrl = Yii::app()->createUrl('inventory/saveChangedSerials');
$productListUrl = Yii::app()->createUrl('inventory/autoCompleteProduct');
$storeId = Yii::app()->session['store_id'] ?? 1;

$cs = Yii::app()->clientScript;
$cs->registerScript('serialAutoCompleteScript', "
$(document).ready(function() {

    // --- Autocomplete for product search ---
    $('#product_search').autocomplete({
        minLength: 2,
        source: function(request, response) {
            $.ajax({
                url: '{$productListUrl}',
                dataType: 'json',
                data: { term: request.term },
                success: function(data) {
                    response($.map(data, function(item) {
                        return {
                            label: item.part_number + ' - ' + item.description,
                            value: item.part_number,
                            id: item.id
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            $('#product_id').val(ui.item.id);
            loadSerialList(ui.item.id);
        }
    });

    // --- Load serial list ---
    function loadSerialList(productId) {
        if (!productId) return;
        $('#serial_list_body').html('<tr><td colspan=\"4\" class=\"text-center\">Loading...</td></tr>');

        $.ajax({
            url: '{$fetchUrl}',
            type: 'GET',
            dataType: 'json',
            data: { product_id: productId, store_id: '{$storeId}' },
            success: function(res) {
                if (res.status === 'success' && res.count > 0) {
                    var rows = '';
                    $.each(res.data, function(i, item) {
                        rows += '<tr>' +
                                    '<td>' + (item.product_name || '') + '</td>' +
                                    '<td>' + (item.description || '') + '</td>' +
                                    '<td>' + (item.serial_no || '') + '</td>' +
                                    '<td><input type=\"text\" class=\"form-control changed-serial\" data-index=\"' + i + '\" data-original=\"' + item.serial_no + '\" value=\"\"></td>' +
                                '</tr>';
                    });
                    $('#serial_list_body').html(rows);
                } else {
                    $('#serial_list_body').html('<tr><td colspan=\"4\" class=\"text-center\">No serial numbers found</td></tr>');
                }
            },
            error: function() {
                $('#serial_list_body').html('<tr><td colspan=\"4\" class=\"text-center text-danger\">Error fetching data</td></tr>');
            }
        });
    }

    // --- Manual entry only ---
    $(document).on('input', '.changed-serial', function() {});

    // --- Save changed serials ---
    $('#save_serials').click(function() {
        var productId = $('#product_id').val();
        if (!productId) {
            t8.error('Please select a product first.');
            return;
        }

        var data = [];
        var allOldSerials = [];
        var allNewSerials = [];

        $('.changed-serial').each(function() {
            var oldSerial = $(this).data('original');
            var newSerial = $(this).val().trim();

            allOldSerials.push(oldSerial);
            if (newSerial !== '') allNewSerials.push(newSerial);

            data.push({
                old_serial: oldSerial,
                new_serial: newSerial
            });
        });

        // --- Check for duplicates ---
        var combinedSerials = allOldSerials.concat(allNewSerials);
        var duplicates = combinedSerials.filter((item, index) => combinedSerials.indexOf(item) !== index && item !== '');

        if (duplicates.length > 0) {
            t8.error('Duplicate serial number found: ' + duplicates.join(', '));
            return;
        }

        if (data.length === 0) {
            t8.error('No serial numbers to save.');
            return;
        }

        $.ajax({
            url: '{$saveUrl}',
            type: 'POST',
            dataType: 'json',
            data: { product_id: productId, serials: data },
            success: function(res) {
                if (res.status === 'success') {
                    t8.success('Serial numbers updated successfully!');
                    loadSerialList(productId);
                } else {
                    t8.error(res.message || 'Failed to update serial numbers.');
                }
            },
            error: function() {
                t8.error('Error while saving serial numbers.');
            }
        });
    });

});
");
?>
