 
   <script>
$(document).ready(function() {

    var table_id ="#tbl_inventory_memo_details";
    var table = $(table_id).DataTable({
        scrollY         : "645px",
        pageLength      : 50,
		processing: true,
        ajax: {
            url: "<?php echo Yii::app()->createUrl('inventory/GetMemoList')?>",
            type: "POST",
            cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
		processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
            
            $("#tbl_inventory_memo_details tbody").mousedown(function (e) {   
                $(this).contextMenu({
                    selector: ".context-menu",
                   callback: function(key, options) {
                	var action_id = key;
   					var data = table.row( this ).data();
   					var id=data[3];
   					var part_number = data[1];
   					if(action_id == "edit"){
   						loadPopupModal("inventory/create&view=memo_create&id="+id,"Memo - "+part_number ,"lg");
   					}

   					
            },
                    items: {
                   	 <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stock_edit"]))){?>
                        		"edit": {name: "Edit", icon: "edit"},
                        <?php } ?>
                    }
                }
                );
            });     
        }
    } );
} );
</script> 
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-money"></i> Memo
            <div class="pull-right">
                 <?php  if ((isset(Yii::app()->user->havePermissionOn['stock_add']) ||  Yii::app()->user->authorised_user == 1)) {?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('inventory/create&view=memo_create','Add Memo','lg')"> <i class="fa fa-plus"></i> ADD</button>
            <?php } ?> 
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_inventory_memo_details" style="font-size:13px;">
                    <thead>
                        <tr>
                           <th>No</th>
                           <th>Memo</th>
                           <th>Description</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
