<?php
$modelStore = Store::model()->findByPK($product_id);
$productLocation = ProductLocation::model()->findAll(array('condition' => 'product_id="' . $product_id . '"', 'group' => 'bin_id,rack_id,warehouse_id'));
$sale_sql = 'SELECT SUM(quantity) AS quantity 
            FROM erp_order_item OI 
            LEFT JOIN erp_order O
                ON OI.order_id=O.id
            LEFT JOIN 	erp_master_file F
                ON O.file_id=F.id 
            WHERE OI.product_id=' . $product_id . ' AND F.current_process_status="O"';
$so_qty = Yii::app()->db->createCommand($sale_sql)->queryScalar();
$purchaseOrder = PurchasingOrderStockItem::model()->findAll(array('condition' => 'stock_item_id = ' . $product_id));
$bal = 0;
if (!empty($purchaseOrder)) {
    foreach ($purchaseOrder as $i => $each) {
        $state = $each->purchaseorder->file->current_process_status;
        if ($each->purchaseorder->file->is_approved == "Y" && ($state == 'P_O' || $state == 'M_R' || $state == 'Q_C' || ($state == 'P_I' && $each->purchaseorder->convert_status == "Y"))) {
            ($state == 'M_R') ? $mr_qty = Yii::app()->db->createCommand('SELECT SUM(received_quantity) FROM  erp_purchasing_material_receipt_item WHERE order_item_id=' . $each->id)->queryScalar() : $mr_qty = 0;
            ($state == 'Q_C') ? $qc_qty = Yii::app()->db->createCommand('SELECT SUM(qc_checked_quantity) FROM  erp_purchasing_material_receipt_item WHERE order_item_id=' . $each->id)->queryScalar() : $qc_qty = 0;
            if ($state == 'P_O') $bal += $each->stock_item_quantity; else if ($state == 'M_R') $bal += $each->stock_item_quantity - $mr_qty; else if ($state == 'Q_C') $bal += $each->stock_item_quantity - $qc_qty;
            else if ($state == 'P_I' && $each->purchaseorder->convert_status == "Y") {
                $_qty = Yii::app()->db->createCommand('SELECT SUM(II.quantity) FROM  erp_purchasinginvoice_item II LEFT JOIN erp_purchasinginvoice I ON I.id = II.purchasing_invoice_id WHERE II.product_id=' . $each->stock_item_id . ' AND I.po_id =' . $each->purchasing_order_id)->queryScalar();
                $bal += $each->stock_item_quantity - $_qty;
            }
        }
    }
}
$po_qty = $bal;

$indirect_model = new InventoryIndirectTransferItem();
$transfer_qty = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(transfer_qty-damaged_qty-transferred_qty)) * unitdetails.factor AS available_qty', 'condition' => 'parent.is_complete!="Y" AND t.item_id="' . $product_id . '"', 'group' => 't.item_id'))->available_qty;
$damaged_qty1 = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(t.damaged_qty)) * unitdetails.factor AS damaged_qty', 'condition' => 't.item_id="' . $product_id . '" AND t.damaged_qty !="0"', 'group' => 't.item_id'))->damaged_qty;
$damaged_model = new DamagedStoreDetails();
$damaged_qty3 = $damaged_model->with('unitdetails')->find(array('select' => '(SUM(t.quantity)) * unitdetails.factor AS quantity', 'condition' => 't.product_id="' . $product_id . '"', 'group' => 't.product_id'))->quantity;
$creditnote_model = new CreditnoteItem();
$damaged_qty2 = $creditnote_model->with('parent', 'orderunit')->find(array('select' => '(SUM(t.returned_quantity)) * orderunit.factor AS returned_quantity', 'condition' => 'parent.sales_return="DA" AND t.product_id="' . $product_id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;
$damaged_qty = $damaged_qty1 + $damaged_qty2 + $damaged_qty3;
$quantity = $modelStore->totalQuantity + $damaged_qty + $transfer_qty;
$arr_units = UnitOfMeasurement::model()->findAll(array('condition' => 'product_id = ' . (int)$modelStore->id, 'order' => 'id asc'));
$unit_span = (int)count($arr_units);
$colspan = $unit_span + 3;

$modelMasInventoryWarehouse = new MasInventoryWarehouse();

$damage_warehouse_id = $modelMasInventoryWarehouse->find(array('condition' => 'warehouse_code="DAM"'))->id;

$SQL = "SELECT SUM(quantity) AS damage_quantity FROM erp_stock_ledger WHERE product_id=" . (int)$product_id . ' AND warehouse_id=' . $damage_warehouse_id;
//echo $SQL;
$total_damage_qty = (float)Yii::app()->db->createCommand($SQL)->queryScalar();


?>
<table class="table table-stripped table-bordered table-primary">
    <thead>

    <tr>
        <th colspan="<?php echo $colspan; ?>"><strong>ITEM (<?php echo $modelStore->part_number; ?>)</strong></th>
    </tr>
    <tr>
        <th colspan="2"><strong><?php echo nl2br($modelStore->description); ?></strong>

        </th>
        <td colspan="<?php echo($unit_span + 1); ?>">
            <?php if ($modelStore->item_image != '') { ?>
                <img src="<?php echo Yii::app()->baseUrl; ?>/uploads/inventoryimages/<?php echo $modelStore->item_image; ?>"
                     width='100' height='100'/>
            <?php } ?>
        </td>
    </tr>
    </thead>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Current Stock</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($quantity)), 2); ?></td>
    </tr>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Free Stock</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($modelStore->totalQuantity - $modelStore->total_allocated_quantity)), 2); ?></td>
    </tr>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Total SO Qty</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($so_qty)), 2); ?></td>
    </tr>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Total PO Qty</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($po_qty)), 2); ?></td>
    </tr>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Allocated Qty</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($modelStore->total_allocated_quantity)), 2) ?></td>
    </tr>
    <!-- <tr>
        <td class="cell-left" style="width:120px;">Total Saleable Stock</td>
        <td style="width:60px;"><?php //echo  preg_replace('/\s\d+\.00/', '', floatval($modelStore->totalQuantity));?></td>
    </tr> -->
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Net Stock</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>" class="text-right"><?php
            $net_stck = $modelStore->totalQuantity + $po_qty - $so_qty;
            echo number_format(preg_replace('/\s\d+\.00/', '', floatval($net_stck)), 2); ?></td>
    </tr>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Damaged Qty</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($total_damage_qty)), 2) ?></td>
    </tr>
    <tr>
        <td class="cell-left" style="width:120px;" colspan="3">Transfer Qty</td>
        <td style="width:60px;" colspan="<?php echo($unit_span); ?>"
            class="text-right"><?php echo number_format(preg_replace('/\s\d+\.00/', '', floatval($transfer_qty)), 2) ?></td>
    </tr>
    <!--tr>
        <td class="cell-left" colspan="3">Cost Rate  </td>
        <td class="cell-right"><?php //echo  Yii::app()->numberFormatter->formatCurrency($modelStore->rate, "");?></td>
    </tr>
    <tr>
        <td class="cell-left" colspan="3">Stock Value  </td>
        <td class="cell-right"><?php //echo Yii::app()->numberFormatter->formatCurrency($modelStore->rate * $modelStore->totalQuantity, "") ;?></td>
    </tr-->
    <tr>
        <td class="cell-left" colspan="3"><strong>Locations<strong></td>
        <?php if (!empty($arr_units)) {
            foreach ($arr_units as $eachunit) {
                ?>
                <td style="width:10%"><?php echo $eachunit->name; ?> </td>
            <?php }
        } else { ?>
            <td style="width:10%">Base Qty</td>
        <?php } ?>
    </tr>
    <?php
     $quantity = 0;
    foreach ($productLocation as $key => $each) {
        $system_stock_qty = ProductLocation::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'quantity>0 and product_id="' . $each->product_id . '" and rack_id="' . $each->rack_id . '" and bin_id="' . $each->bin_id . '" and warehouse_id="' . $each->warehouse_id . '" '))->quantity;
        if ($system_stock_qty > 0) {
            ?>
            <tr>
                <td class="cell-left"><?php echo $each->warehouse_name; ?></td>
                <td class="cell-left"><?php echo $each->rack; ?></td>
                <td class="cell-left"><?php echo $each->bin; ?></td>
                <?php
                if (!empty($arr_units)) {
                    foreach ($arr_units as $eachunit) {
                        ?>
                        <td class="text-right"><?php echo number_format(($each['quantity'] / $eachunit->factor), 2); ?> </td>

                    <?php }
                } else { ?>
                    <td><?php echo number_format($each['quantity'], 2); ?></td>
                <?php } ?>
            </tr>

         
            


            <?php
        }
        $quantity += $each->quantity;
    } ?>

    <tr>
        <td class="cell-left"></td>
        <td class="cell-left"></td>
        <td class="cell-left">Cost</td>
        <?php


        if (!empty($arr_units)) {
           
            foreach ($arr_units as $eachunit) {
                ?>


                <?php if ($modelStore->rate > 0 && $eachunit->factor > 0) { ?>
                    <td class="text-right"><?php echo number_format(($modelStore->rate * $eachunit->factor), 2); ?> </td>
                <?php } else { ?>
                    <td class="text-right"><?php echo ''; ?> </td>
                <?php } ?>
            <?php }
        } else { ?>
            <td></td>
            <?php

        } ?>
    </tr>


    <tr>
        <td class="cell-left"></td>
        <td class="cell-left"></td>
        <td class="cell-left">Total</td>
        <?php
        if (!empty($arr_units)) {
            foreach ($arr_units as $eachunit) {
                ?>

                <?php
                 if ($modelStore->rate > 0 && $eachunit->factor > 0 && $quantity > 0) {
                    $quantity_factor = $quantity / $eachunit->factor;
                    $rate_factor = $modelStore->rate * $eachunit->factor;
                    ?>

                    <td class="text-right"><?php echo number_format(($quantity_factor * $rate_factor), 2); ?> </td>

                <?php } else { ?>
                    <td class="text-right"><?php echo ''; ?> </td>
                <?php } ?>


            <?php }
        } else { ?>
            <td></td>
        <?php } ?>
    </tr>


</table>