<div class="row">
    <div class="col-sm-12 text-right" style="margin-bottom:10px;">
        <?php
        echo CHtml::dropDownList(
            'serial_status_filter',
            'stock',
            array(
                '' => 'All',
                'stock' => 'Stock',
                'transit' => 'In Transit',
                'customer' => 'With Customer',
                'sold' => 'Sold',
                'return' => 'Sales Return',
            ),
            array(
                'class' => 'form-control',
                'style' => 'width:200px; display:inline-block;',
                'id' => 'serialStatusFilter'
            )
        );
        ?>
    </div>
</div>

<table class="table table-bordered personal-task" id="serial_no_item_table">
    <tr class="bg-blue">
        <th>SI.No</th>
        <th>Date</th>
        <th>Transaction#</th>
        <th>Location</th>
        <th>Serial No</th>
    </tr>

    <?php
    $SQL = "SELECT
    esl.id,
    esl.header_id,
    esl.reference_id,
    esl.serial_no,
    esl.customer_vendor_id,
    esl.customer_vendor_name,
    esl.transaction_date,
    esl.location_id,
    esl.warehouse_name,
    esl.lead_owner_id,
    esl.transaction_from,
    CONCAT(U.first_name,' ',U.last_name) AS lead_owner_name,
    CL.location_name AS customer_location_name
FROM erp_stock_ledger esl
LEFT JOIN " . MasCompany::MainDB . ".erp_user AS U ON esl.lead_owner_id=U.id
LEFT JOIN erp_service_customer_location AS CL ON esl.location_id=CL.id
INNER JOIN (
    SELECT serial_no, MAX(id) AS max_id
    FROM erp_stock_ledger
    WHERE product_id='" . $model->id . "' AND stock_updated='Y'
    GROUP BY serial_no
) latest ON esl.id = latest.max_id
ORDER BY esl.id DESC, esl.serial_no ASC";

    $arr_serial_no_details = Yii::app()->db->createCommand($SQL)->queryAll();

    if (!empty($arr_serial_no_details)) {
        foreach ($arr_serial_no_details as $i => $each) {

            $location = $each['warehouse_name'];
            $tr_style = '';
            $statusClass = 'stock';

            if ($each['transaction_from'] == 'DELIVERY_NOTE') {
                $statusClass = 'sold';
                $location = $each['customer_vendor_name'];
                $tr_style = 'style="background:#c27cda"';
            }

            if ($each['transaction_from'] == 'GOODS_ISSUE' || $each['transaction_from'] == 'MACHINE_ISSUE') {
                if ($each['customer_vendor_id'] > 0) {
                    $statusClass = 'customer';
                    $location = $each['customer_vendor_name'] . ' / ' . $each['customer_location_name'];
                    $tr_style = 'style="background:#ffcccb"';
                } else {
                    $statusClass = 'transit';
                    $location = $each['lead_owner_name'];
                    $tr_style = 'style="background:#5D8AA8"';
                }
            }

            if ($each['transaction_from'] == 'MACHINE_RETURN') {
                $statusClass = 'return';
                $location = $each['warehouse_name'] . ' / ' . $each['lead_owner_name'];
                $tr_style = 'style="background:#90EE90"';
            }
            $transaction_from = $each['transaction_from'];
            if($each['transaction_from'] == 'QUALITY_CHECK'){
                $transaction_from = 'Purchased';
            }
            if($each['transaction_from'] == 'DIRECT_TRANSFER_IN'){
                $transaction_from = 'Transferred';
            }
            if($each['transaction_from'] == 'MACHINE_ISSUE'){
                $transaction_from = 'Machine Issued';
            }
            if($each['transaction_from'] == 'DELIVERY_NOTE'){
                $transaction_from = 'Delivered';
            }
            if($each['transaction_from'] == 'MACHINE_RETURN'){
                $transaction_from = 'Machine Returned';
            }
            $tr_date = (!empty($each['transaction_date']) && $each['transaction_date'] != '0000-00-00')
                ? date('d/m/Y', strtotime($each['transaction_date']))
                : '';

            $label = $each['header_id'] . ' | ' . $each['reference_id'] . ' | ' .
                $transaction_from . ' | ' . $each['customer_vendor_name'];
            ?>

            <tr class="serial-row <?php echo $statusClass; ?>" <?php echo $tr_style; ?>>
                <td><?php echo ($i + 1); ?></td>
                <td><?php echo $tr_date; ?></td>
                <td><?php echo $label; ?></td>
                <td><?php echo $location; ?></td>
                <td><?php echo $each['serial_no']; ?></td>
            </tr>

            <?php
        }
    } else {
        echo "<tr><td colspan='5' class='text-center'>No Data</td></tr>";
    }
    ?>
</table>
<script>
    $(document).ready(function () {

        function filterRows(val) {
            if (val === '') {
                $('.serial-row').show();
            } else {
                $('.serial-row').hide();
                $('.serial-row.' + val).show();
            }
        }

        // ✅ Apply default filter on load
        filterRows($('#serialStatusFilter').val());

        // On change
        $('#serialStatusFilter').on('change', function () {
            filterRows($(this).val());
        });

    });
</script>

<div class="color-indicator">
    <span
        style="display: inline-block;width:30px;height:30px;background:#FFFF; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span
        class="verti"> Stock</span>
    <span
        style="display: inline-block;width:30px;height:30px;background:#5D8AA8; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span
        class="verti"> In Transit</span>
    <span
        style="display: inline-block;width:30px;height:30px;background:#ffcccb; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span
        class="verti"> With Customer</span>
    <span
        style="display: inline-block;width:30px;height:30px;background:#c27cda; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span
        class="verti"> Sold Out</span>
    <span
        style="display: inline-block;width:30px;height:30px;background:#90EE90; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span
        class="verti"> Sales Return</span>
</div>