<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadTransfers", '
        $(document).ready(function() {    
        
            /*$("#tbl_hiring_transfer_details").DataTable({
                scrollY         : "645px",
                pageLength      : 50,
                processing: true,
                ajax: {
                    url: "' . Yii::app()->createUrl('hiringtransfer/Getlist') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                aaSorting : [[ 0, "desc" ]],
                fixedColumns:   true,
                processing: true,

            });*/
    });', CClientScript::POS_HEAD);
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="tr_li" onclick="reloadTable('#tbl_hiring_transfer_details');" class="active"><a href="#tab1" data-toggle="tab"><i class="fa fa-globe"></i> Transfer</a></li>
    <li id="pk_li" onclick="reloadTable('#tbl_serialized_list');"><a href="#tab2" data-toggle="tab"><i class="fa fa-truck"></i> Serialized List</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="tab1">
        <section class="panel">
            <header class="panel-heading clearfix panel-theame">
                <div class="pull-right">
                    <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_add']) || Yii::app()->user->authorised_user == 1) { ?>
                        <button class="btn btn-xs btn-theme" onclick="loadPopupModal('hiringtransfer/create', 'New Hiring Transfer', 'xl')"><i class="fa fa-plus"></i> ADD</button>
                    <?php } ?>
                </div>
            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_hiring_transfer_details">
                        <thead>
                            <tr>
                                <th>Transfer No</th>
                                <th>Transfer Date</th>
                                <th>Warehouse</th>
                                <th>Description</th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <div class="tab-pane" id="tab2">
        <section class="panel">
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_serialized_list">
                        <thead>
                            <tr>
                                <th>Transfer No</th>
                                <th>Completed Date</th>
                                <th>Warehouse</th>
                                <th>Description</th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>
<script>

    var table_id = "#tbl_hiring_transfer_details";
    var tableTR = $(table_id).DataTable({
        scrollY: "645px",
        pageLength: 100,
        processing: true,
        /*"columnDefs": [
         {
         "targets": [5],
         "visible": false,
         },
         ],*/

        ajax: {
            url: "<?php echo Yii::app()->createUrl("hiringtransfer/Getlist"); ?>",
            type: "POST",
            cache: false,
        },
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

            $("#tbl_hiring_transfer_details tbody").mousedown(function (e) {
                $(this).contextMenu({
                    selector: ".context-menu",
                    callback: function (key, options) {
                        var action_id = key;
                        var data = tableTR.row(this).data();
                        var id = data[0];

                        if (action_id == "convert") {
                            loadPopupModal("hiringtransfer/convert&id=" + id, "Convert - " + id, "xl");
                        } else if (action_id == "print") {
                            window.open($("#liveSite").val() + "/index.php?r=hiringtransfer/PrintPDF&id=" + id, "_blank")
                        } else if (action_id == "view") {
                            loadPopupModal("hiringtransfer/create&id=" + id + "&type=view", "View - " + id, "xl");
                        } else if (action_id == "edit") {
                            loadPopupModal("hiringtransfer/create&id=" + id, "Edit - " + id, "xl");
                        }
                    },
                    items: {
                        "edit": {name: "Edit", icon: "fa-pencil"},
                        "convert": {name: "Convert", icon: "fa-retweet"},
                        "view": {name: "View", icon: "fa-eye"},
                        "print": {name: "Print", icon: "fa-print"},
                    }
                }
                );
            });
        }
    });



    var table_id = "#tbl_serialized_list";
    var table = $(table_id).DataTable({
        scrollY: "645px",
        pageLength: 100,
        processing: true,
        /*"columnDefs": [
         {
         "targets": [5],
         "visible": false,
         },
         ],*/

        ajax: {
            url: "<?php echo Yii::app()->createUrl('hiringtransfer/GetSerializedList'); ?>",
            type: "POST",
            cache: false,
        },
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

            $("#tbl_serialized_list tbody").mousedown(function (e) {
                $(this).contextMenu({
                    selector: ".context-menu",
                    callback: function (key, options) {
                        var action_id = key;
                        var data = table.row( this ).data();
                        var id=data[0];
                        
                        if (action_id == "print1"){
                            window.open($("#liveSite").val() + "/index.php?r=hiringtransfer/PrintSerializedPDF&id="+ id, "_blank")
                        }

                    },
                    items: {
                        "print1": {name: "Print", icon: "fa-print"},
                    }
                }
                );
            });
            
        }
    });


</script>