<style>
    .popover{
    max-width: 400px; /* Max Width of the popover (depending on the container!) */
    z-index: 999999999999 !important;
    }
    
</style>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_hire_machine_list";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('hiringtransfer/GetHiringMachineList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            columns: [
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-3"},
                {className:"nw sl col-max-2"},
                {className:"nw sl col-max-4"},
                {className:"nw sl col-max-5"},
                {className:"nw sl col-max-2"},
                {className:"nw sl col-max-3"},
                {className:""},
                {className:"nw sl col-max-1"},
                {className:""},
                {className:""},
                {className:"nw sl col-max-1"},
                
            ],
            "columnDefs": [
                {
                   "targets": [7,9,10],
                   "visible": false,
                },
            ],	
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) { 
                if (aData[9]=="E" ){
                    $("td", nRow).css("background-color", "#87CEFA");
                }else if (aData[9]=="D" ){
                    $("td", nRow).css("background-color", "#F08080");
                }else if (aData[9]=="S" ){
                    $("td", nRow).css("background-color", "#E6E6FA");
                }else{
                    if (aData[5]>0){
                        $("td", nRow).css("background-color", "#D6FCDA");
                    }else{
                        $("td", nRow).css("background-color", "#FFFACD");
                    }
                }
                AddContextMenu(nRow, aData);
            }
        });
         $('#tbl_hire_machine_list tbody').on('mouseover', 'tr', function () {
            $('.machine_location_over').popover({
                title: '<b>Product Location Details</b>',
                html: true,
                placement: 'right',
                trigger: 'hover',
                content:popoverContent
            });
        });
    });
    function AddContextMenu(row, datas) {
        
        $(row).contextMenu({
            selector: 'td',

            items: {
                "print": {
                    
                     <?php  if(isset(Yii::app()->user->havePermissionOn['admin_users_edit']) ||  Yii::app()->user->authorised_user == 1)
                {
                 ?>
                    
                    name: "Profile",
                    icon: "fa-print",
                    accesskey: "p", 
                    callback: function () {
                        window.open($('#liveSite').val()+"/index.php?r=machineprofile/printsnapshot&id="+datas[10]+"&serialno="+datas[6],"_blank")
                    }
                <?php } ?> 
                },
            }
        });
    }
function popoverContent() {
        var content = '';
        var element = $(this);
        var id = element.attr("id");
        content ="";
         var arr_fields= id.split('_');
        var row_field=arr_fields[1];
        var product_id=arr_fields[2];
        var serial_no=arr_fields[3];
        jQuery.ajax({
            'type': 'post',
            'url': "<?php  echo Yii::app()->createUrl('hiringtransfer/GetLocationDetails') ?>",
            'data': {'id':product_id,'serial_no':serial_no}  ,
            'cache': false,
            'async': false,
            'success': function(retdata) {
                   content=retdata;
            }
        });
   return content;  


}
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-book"></i> Hiring Machine Inventory
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_hire_machine_list">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part No</th>
                        <th>Machine/Purchasing Part#</th>
                        <th>Brand</th>
                        <th>Description</th>
                        <th>Qty</th>
                        <th>Serial No</th>
                        <th>Expiry Date</th>
                        <th>Unit</th>
                        <th></th><th></th>
                        <th>YOM</th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="color-indicator">
            <span style="display: inline-block;width:30px;height:30px;background:#D6FCDA; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Available</span>
            <span style="display: inline-block;width:30px;height:30px;background:#FFFACD; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Hire</span>
            <span style="display: inline-block;width:30px;height:30px;background:#F08080; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Damage</span>
            <span style="display: inline-block;width:30px;height:30px;background:#E6E6FA; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Sold</span>
            <span style="display: inline-block;width:30px;height:30px;background:#87CEFA; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> External Transfer</span>
        </div>
    </div>
</section>
