<?php
$cs = Yii::app()->getClientScript();


  ?>
  
  <script>
     $(document).ready(function() {
		loadCreditNoteList();
		loadCheckinList();
     });


	function loadCreditNoteList(){
		var table_id ="#tble_tble_credit";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY         : "450px",
            pageLength      : 50,
            processing: true,
            columns:[
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-4"},
                {className:"nw sl col-max-5"},
                {className:"nw sl col-max-3"},
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-4"},
                {className:"nw sl col-max-5 text-right"},
                {className:"nw sl col-max-3 text-right"},
                {className:"nw sl col-max-1 text-right"},
            ],
            ajax: {
                url: "<?php  echo Yii::app()->createUrl('creditnote/GetCreditNoteList') ?>",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
		 	"fnCreatedRow"  : function( nRow, aData, iDataIndex ){
        		$(nRow).addClass("context-menu");
    		},
    		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
        
        	$("#tble_tble_credit tbody").mousedown(function (e) {   
            $(this).contextMenu({
                selector: ".context-menu",
               callback: function(key, options) {
            	var action_id = key;
					var data = table.row( this ).data();
					var id=data[0];
					var file_id = data[1];
					if(action_id == "print"){
						window.open($('#liveSite').val()+"/index.php?r=creditnote/printfile&file="+file_id+"&id="+id,"_blank")
					}
        },
                items: {
               	 <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["rawmaterial_edit"])){ ?>
                    		"print": {name: "Print", icon: "fa-print"},
                    <?php } ?>
                }
            }
            );
        });     
    }
    });
	}


	
        </script>
  
  
  
  <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
        <li  id="li_sales_credit_note_index_1" class="active"><a href="#sales_credit_note_index_1" data-toggle="tab"><i class="fa fa-money"></i> Credit Note</a></li>
        <li  onclick="reloadTable('#tble_tble_check_in');" id="li_sales_credit_note_index_2"><a href="#sales_credit_note_index_2" data-toggle="tab"> <i class="fa fa fa-area-chart"></i> Checking</a></li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="sales_credit_note_index_1">
            <section class="panel">
                <header class="panel-heading clearfix panel-theame">
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_add"])) { ?> 
                        <div class="pull-right">
                            <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('creditnote/create','Add New Credit Note','xl')"><i class="fa fa-plus"></i> ADD</button>
                        </div>
                        <div class="pull-right">
                            <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('hiringreturn/create','Add Hiring Return','xl')"><i class="fa fa-plus"></i> Hiring Return</button>
                        </div>
                    <?php } ?>
                </header>   
                <div class="panel-body">
                    <div class="custom-data-table">
                        <table class="table table-hover table-bordered personal-task" id="tble_tble_credit">
                            <thead>
                                <tr>
                                  <th>Credit Note #</th>
		                            <th>File#</th>
		                            <th>Invoice No</th>
		                            <th>Customer</th>
		                            <th>Credit Date</th>
		                            <th>Currency</th>
		                            <th>Invoice Amount</th>
		                            <th>VAT</th>
		                            <th>Credit Amount</th>
                                </tr>
                            </thead>
                        </table>
                        
                    </div>
                </div>
            </section>
        </div>
        <div class="tab-pane" id="sales_credit_note_index_2">
           <?php $this->renderPartial("//checkin/index",array('frm'=>'CN'));?>
        </div>
    </div>
  