<ul class="clearfix form-ul material"> 
    <li class="col-sm-4">  
        <?php
        if ($model->customer_id > 0) {
            $customer = $model->customer->customer_name;
        } else {
            $customer = $model->customer->customer_name;
        }
        ?>    
        <?php echo $form->textField($model, 'customer_name', array('class' => 'text-bold', 'data-label' => 'Customer <span style="color:red;">*</span>','onKeyup' => 'js:autoCompleteCustomers(this.id,"sales_hiring_return");','value'=>$customer));
        ?>   
        <input type="hidden" name="customer_id" id="customer_id" value="<?php echo $model->customer_id; ?>">
    </li>    
    <li class="col-sm-4" id="li_file_order_id">    
        <?php echo CHtml::dropdownList('tax_invoice_id', '', array(),array('class' => 'tooltipster','data-label' => 'File No/Order No <span style="color:red;">*</span>', 'onchange' => 'gethiringreturndetails(this.value);')); ?>            
    </li>         
    <li class="col-sm-4">      
        <?php echo $form->hiddenField($model, 'order_id'); ?>   
        <?php echo $form->hiddenField($model, 'invoice_id'); ?>   
        <?php echo $form->error($model, 'invoice_id'); ?>  
        <?php $model->credited_date = !$model->isNewRecord ? date('d/m/Y', strtotime($model->credited_date)) : date('d/m/Y') ?>
<?php echo $form->textField($model, 'credited_date', array('class' => 'datepicker', 'data-label' => 'Return Date')); ?>   
    </li>  
</ul>   
<ul class="clearfix form-ul material">  




    <li class="col-sm-3">      
        <?php $currency = $model->currency; ?>   
        <?php echo $form->dropDownList($model, 'currency', MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency'));
        ?>    
    </li>  
    <li class="col-sm-3">     
        <?php echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'readonly' => 'readonly', 'data-label' => 'Exchange Rate',
            'value' => $model->exchange_rate));
        ?>   
        <?php echo $form->error($model, 'exchange_rate'); ?>   
    </li>   
     <li class="col-sm-3">
    <?php echo $form->dropDownList($model, 'responsible_user', User::getLeadOwners(), array('class' => 'tooltipster ', 'data-label' => "Responsible Person", 'empty' => '--Select--', 'title' => 'Please select responsible person', 'options' => array($model->responsible_user ? $model->responsible_user : Yii::app()->user->id => array('selected' => true)))); ?>
        <?php echo $form->error($model, 'responsible_user'); ?> 
    </li>
    <li class="col-sm-3">               
        <?php
        $default_invc_model = MasCompanySettings::model()->find();
        $default_invc = $default_invc_model->sales_return;
        ?>
        <?php echo $form->dropDownList($model, 'sales_return', array('ST' => 'Stock', 'DA' => 'Damage'), array('data-label' => 'Consider Quantity Return to', 'options' => array($default_invc => array('selected' => true)))); ?>

        <?php echo $form->error($model, 'sales_return'); ?>
    </li>
    <li class="col-sm-12">   
<?php echo $form->textArea($model, 'reason', array('data-label' => 'Reason', 'value' => $model->reason, 'class' => 'en-text-area')); ?>      
<?php echo $form->error($model, 'reference'); ?>   
    </li>                      

</ul>   
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getDetails", " function getDetails(order_id){
    jQuery.ajax({
        'type': 'post',
        'dataType':'json',
        'data': { 'id':order_id }  ,
        'url': '" . Yii::app()->createUrl('hiringreturn/getOrderDescription') . "',
        'success': function(data) { 
            $('#Creditnote_customer_id').val(data.customer_name);  
            $('#credit_item_table').html(data.tbl);  
        }
    });
} ", CClientScript::POS_HEAD);
?>
<?php 
$cs->registerScript("autoCompleteCustomers", "function autoCompleteCustomers(field_id,frm){
        var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "'+'&frm='+frm;
        $('#'+field_id).autocomplete({
        minLength   : 1,
        source      : function (request, response) { autoCompleteSource(request, response,url) },
        focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
        select          : function( event, ui ) {
        event.preventDefault();
        trigger_target_id  	=   $(event.target).attr('id');
            var customer_id=ui.item.value; 	
            $('#customer_name').val(ui.item.customername);
            $('#customer_id').val(customer_id);
                jQuery.ajax({
                   'data' :{'customer_id':customer_id},
                   'dataType' : 'json',
                   'type':'post',
                   'url': '" . Yii::app()->createUrl('hiringreturn/getorderdetails') . "',
                   'success': function(data) {
                     $('#li_file_order_id').html(data.details);
                   }
               });
            }
        })
}", CClientScript::POS_HEAD); 
$cs->registerScript("gethiringreturndetails", "function gethiringreturndetails(order_id){
        jQuery.ajax({
            'type': 'post',
            'dataType' :'json',
            'data' : {
                'order_id':order_id
            },
            'url': '" . Yii::app()->createUrl('hiringreturn/gethiringreturndetails') . "',
            'cache': false,
            'success': function(data)
            {
                $('#Creditnote_order_id').val(order_id); 
                $('#Creditnote_currency').multiselect('select', data.currency_id);  
                 $('#Creditnote_currency').attr( 'readonly', true );
                $('#Creditnote_exchange_rate').val(data.exchangerate);   
                $('#Creditnote_exchange_rate').addClass('filled'); 
                $('#Creditnote_exchange_rate').attr( 'readonly', true );                                
                $('.forInvoiceSearch').show(); 
                return getDetails(order_id);
            },
            'beforeSend':function(){
                $('#loader').show(); 
            },
            'complete':function(){
                  $('#loader').hide();   
            }

        });
}", CClientScript::POS_HEAD);

$cs->registerScript("checkquantity", "function checkquantity(field_id,quantity) {
        var arr_fields= field_id.split('_');
        var row_field=arr_fields[1]; 
            var total_quantity=$('#CreditnoteItem_'+row_field+'_total_remaining').val(); 
            if(Number(quantity)>Number(total_quantity)){
                t8.error('Returning Quantity cannot be greater than '+total_quantity); 
                $('#CreditnoteItem_'+row_field+'_returned_quantity').val('');
            }
        
              
    };", CClientScript::POS_HEAD);
$cs->registerScript("checkdamagequantity", "function checkdamagequantity(field_id,damage_quantity) {
        var arr_fields= field_id.split('_');
        var row_field=arr_fields[1]; 
            var total_damage_quantity=$('#CreditnoteItem_'+row_field+'_total_damage').val(); 
            if(Number(damage_quantity)>Number(total_damage_quantity)){
                t8.error('Returning Damage Quantity cannot be greater than '+total_damage_quantity); 
                $('#CreditnoteItem_'+row_field+'_damage_quantity').val('');
            }
        
              
    };", CClientScript::POS_HEAD);
?>