<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("loadInventory", '', CClientScript::POS_HEAD);
        $cs->registerScript("showstockdetails", "function showstockdetails(stock_id) {
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('inventory/StockHelper') . "',
                'data': {'id': stock_id}  ,
                'cache': false,
                'success': function(data) {             
                    $('#stockhelper').show();
                    $('#stockhelper').html(data);                
                }
            });
        };", CClientScript::POS_HEAD);
    ?>
     <script>
     $(document).ready(function() {
         var table_id ="#tbl_hiring_details";
         var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
             data.display_type = $("#display_type").val();
             data.brand_id = $("#brand_id").val();
             data.generic_id = $("#generic_id").val();
             return data;
         }).DataTable({
             scrollY         : "645px",
             pageLength      : 50,
             processing: true,
             columns:[
                 {className:"nw sl col-max-1"},
                 {className:"nw sl col-max-4"},
                 {className:"nw sl col-max-5"},
                 {className:"nw sl col-max-3"},
                 {className:"nw sl col-max-1 text-right"},
                 {className:"nw sl col-max-1"},
             ],
             ajax: {
                 url: "<?php  echo Yii::app()->createUrl('hiring/GetList') ?>",
                 type: "POST",
                 cache : false,
             },
             serverSide:     true,
             fixedColumns:   true,
             processing: true,
		 	"fnCreatedRow"  : function( nRow, aData, iDataIndex ){
         		$(nRow).addClass("context-menu");
     		},
     		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
         
         	$("#tbl_hiring_details tbody").mousedown(function (e) {   
             $(this).contextMenu({
                 selector: ".context-menu",
                callback: function(key, options) {
             	var action_id = key;
					var data = table.row( this ).data();
					var id=data[0];
					var part_number = data[1];
					if(action_id == "edit"){
						loadPopupModal("hiring/create&id="+id,"Hiring - "+part_number ,"xl");
					}
					else if(action_id == "copy"){
						loadPopupModal("hiring/create&id="+id+"&action=copy","Hiring - "+part_number ,"xl");
					}

					
         },
                 items: {
                	 <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stock_edit"])){ ?>
                     		"edit": {name: "Edit", icon: "edit"},
                     <?php } ?>
                     <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stock_add"])){ ?>
                     		"copy": {name: "Copy", icon: "copy"},
                     <?php } ?>
                 }
             }
             );
         });     
     }
     });
		
		
     });
        </script>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-tags"></i> Hiring Master
            <div class="top_controls_select col-sm-8 pull-right">                
                <div class="col-sm-1 pull-right">
                    <?php  if (isset(Yii::app()->user->havePermissionOn['stock_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                        <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hiring/create','Add New','xl')"> <i class="fa fa-plus"></i> ADD</button>
                    <?php } ?>
                </div>
            </div>
            
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <div id="stockhelper" style='display:none;' ></div>
                <table class="table table-hover table-bordered personal-task" id="tbl_hiring_details">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Part No</th>
                            <th>Description</th>
                            <th>Qty</th>
                            <th>Unit</th>
                            <th>Application</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>