  <style>
    .the-legend {
      border-style: none;
      border-width: 0;
      font-size: 15px;
      line-height: 20px;
      margin-bottom: 0;
      width: auto;
      padding: 6px 17px;
      border: 1px solid #e0e0e0;
      background: #1f67b2;
      color: white;
      font-weight: 500;
      border-radius: 18px 2%;
    }

    .the-fieldset {
      /* border: 1px solid #e0e0e0; */
      padding: 10px;
      /* background: #d2e8ffa3; */
      border-radius: 5px;

    }
  </style>
  <script>
    function uploadStockData() {
      $.ajax({
        type: 'POST',
        url: '<?php echo Yii::app()->createUrl('generic/UploadCategoryCsv'); ?>',
        dataType: 'json',
        beforeSend: function () {
          $('#loader').show();
        },
        success: function (response) {

          $('#loader').show();
          if (response.status === 'success') {
            reloadTable('#tbl_isoStandard_details');

            $('#loader').hide();
            // Check for remaining items and update the link if provided
            if (response.remaining > 0 && response.link) {
              // $('#upload-stock-container').html(response.link);
              $('#btn_category_upload_close').css('display', 'none');

              // $('#remaining_count_msg').html('Remaining items to upload Stock: ' + response.remaining).css('color', 'red');

              //  t8.error('There are ' + response.remaining + ' items remaining to upload Stock.');
              loadPopupModal("generic/index&id=" + data.invoice_id, "Upload Category List", "lg");

            } else {
              t8.success(response.message);
              reloadTable('#tbl_isoStandard_details');
              $('#btn_category_upload_close').click();
              //  $('#upload-stock-container').html('');
            }


          } else {
            t8.error(response.message);
          }
        },
        error: function () {
          t8.error('There was an error with the request.');
        }
      });
    }
  </script>


  <?php

  $cs = Yii::app()->getClientScript();

  $baseUrl = Yii::app()->baseUrl;

  $form = $this->beginWidget('CActiveForm', array(
    'id' => 'upload-audit-type-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
  ));
  ?>

  <ul class="clearfix form-ul material">
    <fieldset class="the-fieldset">
      <li lass="col-sm-3" style="float: right;">
        <span style="float:left;color:red">* All fields in the excel are Mandatory *<br>
          * Category Name should be unique *<br>
          * Upload files in .csv format *<br>
        </span><br><br><br>
      </li>

      <li class="col-sm-3" id="div_upload">
        <?php
        $allowedExtensions = array("csv");
        $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
          'id' => 'isoStandard_list_0_upload_csv', //rand(),//'isoStandard_list_0_upload_csv',
          'config' => array(
            'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/UploadCategoryCsv', array('folder' => 'uploads/generic_csv')),
            'multiple' => false,
            'allowedExtensions' => $allowedExtensions,
            'sizeLimit' => 1 * 1024 * 1024,
            'onStart' => "js:function(){}",
            'class' => 'pull-right',
            'onComplete' => "js:function(id, fileName, responseJSON){
                                  $('#isoStandard_list_file_name').val(responseJSON.filename);
                                  isoStandardUpload(responseJSON.filename)
                              }",
          )
        ));
        ?>

      </li>
      <li class="col-sm-3">
        <div id="csv_msg">
        </div> 
      </li>

      <li class="col-sm-3" id="div_template">
        <?= CHtml::link(
          'Download Template',
          array('generic/DownloadSampleCsv'),
          array('style' => 'color: blue; text-decoration: underline;', 'target' => '_blank')        ); ?>
        <br><br>

        <label id="remaining_count_msg"></label>

      </li>
      <li class="col-sm-3" id="total_count_msg">

      </li>
      <li class="col-sm-12" id="upload-log" style="display: none;">
        <div class="panel-body">
          <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_upload_details">
              <thead>
                <tr>
                  <!-- <th>Sl.No</th> -->
                  <th>New Records</th>
                  <th>Existing Records</th>
                  <th>Error</th>
                </tr>
              </thead>
              <tbody id="tbl_upload_details_body">

              </tbody>
            </table>
          </div>
        </div>
      </li>

    </fieldset>
  </ul>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="btn_category_upload_close">Close</button>
  </div>
  <?php
  $this->endWidget();
  $cs = Yii::app()->getClientScript();

  $cs->registerScript("isoStandardUpload", "function isoStandardUpload(filename)
  {

      if (filename != '') {
          jQuery.ajax({
              'type': 'post',
              'dataType': 'json',
              'data': {
                  filename: filename
              },
              'url': '" . Yii::app()->createUrl('generic/SaveCategoryUploadCsv') . "',
              'cache': false,
              'success': function (data) {
                  $('#loader').hide();
                  console.log(data);
                  if (data.status == 'success') {
                      
                      var total_records = (data.total_records || 0);
                      var success_count = data.success_count;
                      var error_count = (data.error_count || 0);
                      var existing_count = (data.existing_count || 0);
                      $('#total_count_msg').html('Total Record: '+total_records);

                      updateUploadDetailsTable(success_count, existing_count, error_count);

                      $('#upload-log').show();

                      if (data.error && data.error.length > 0) {


                          $('#csv_msg').html(data.link);
                          $('#div_template').hide();


                          $.each(data.error, function (key, val) {
                              t8.error('' + val + '');
                          });
                      } 
                      else if(data.flag === 'continue'){
                          $('#csv_msg').html(data.next_button);
                          $('#div_upload').hide();
                          $('#div_template').hide();
                      }      
                      else {

                          t8.success('Details Uploaded Successfully');
                         $('#total_count_msg').html('<span style=\'color:#5cb85c;\'><b>Total Record: ' + total_records + '</b></span>');

                        
                      }
                  } else {

                      if (data.error_url && data.error_url !== '') {
                                              $('#btn_category_upload_close').css('display', 'none');

                          $('#csv_msg').html(data.link);
                          $.each(data.error, function (key, val) {
                              t8.error('' + val + '');
                          });
                      }
                  }
              },
              'beforeSend': function () {
                  $('#loader').show();
              },
              'complete': function () {
                  $('#loader').hide();
              }
          });
      } else {
          t8.error('File not found');
      }
  }", CClientScript::POS_HEAD);


  ?>

  <script>
    $(document).on('click', '#next-batch-btn', function () {
      const url = $(this).data('url'); // Get the URL for the next batch
      $('#csv_msg').html(`
              <div class="spinner-border text-primary" role="status">
                  <span class="visually-hidden">Loading...</span>
              </div>
          `);
      $.ajax({
        type: 'post',
        url: url,
        dataType: 'json',
        success: function (response) {
          if (response.status === 'success') {
            $('#csv_msg').html(response.message); // Display success message
            var total_records = (response.total_records || 0);
            var success_count = response.success_count;
            var error_count = (response.error_count || 0);
            var existing_count = (response.existing_count || 0);
            $('#total_count_msg').html('Total Record: '+total_records);
            updateUploadDetailsTable(success_count, existing_count, error_count);
            if (response.flag === 'continue') {
              // Replace the Next button with the new one
              $('#csv_msg').append(response.next_button);
            } else {
              t8.success('Details Uploaded Successfully.');
              $('#total_count_msg').html("<span style='color:#5cb85c'><b>Total Record: " + total_records + "</b></span>");

            }
          } else {
            $('#csv_msg').html(response.link);

            t8.error('Error occurred while processing the batch.');
          }
        },
        error: function () {
          t8.error('Failed to process the request.');
        }
      });
    });

  </script>
<script>
    function updateUploadDetailsTable(newRecord, existingCount, errorCount) {
        var $row = $('#tbl_upload_details_body tr').first();

        if ($row.length === 0) {
            // If no row exists, insert the first row
            var row_html = '<tr>' +
                '<td class="new-record">' + newRecord + '</td>' +
                '<td class="existing-count">' + existingCount + '</td>' +
                '<td class="error-count">' + errorCount + '</td>' +
                '</tr>';
            $('#tbl_upload_details_body').html(row_html);
        } else {
            // Increment existing values
            var currentNew = parseInt($row.find('.new-record').text() || 0);
            var currentExisting = parseInt($row.find('.existing-count').text() || 0);
            var currentError = parseInt($row.find('.error-count').text() || 0);

            $row.find('.new-record').text(currentNew + newRecord);
            $row.find('.existing-count').text(currentExisting + existingCount);
            $row.find('.error-count').text(currentError + errorCount);
        }
    }
</script>