<?php
if (!$model->isNewRecord) {
    $model->starting_date = date('d/m/Y', strtotime($model->starting_date));
} else {
    $model->current_installment = 0;
}
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <?php echo $form->hiddenField($model, 'id'); ?>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'name', array('data-label' => 'Name <span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'name'); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'amount', array('class' => ' text-right', 'data-label' => 'Amount <span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'amount'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'Num_of_installment', array('class' => ' text-right', 'data-label' => 'No. of Installment <span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'Num_of_installment'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropDownList($model, 'type_id', FinanceEmiType::getType(), array('data-label' => 'Type<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'type_id'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropDownList($model, 'category', EmiCategory::getActiveCategory(), array('data-label' => 'Category<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'type_id'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'reference', array('data-label' => 'Reference<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'reference'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'starting_date', array('class' => 'datepicker', 'data-label' => 'Starting Date<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'starting_date'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'current_installment', array('class' => ' text-right', 'data-label' => 'Current Installment<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'current_installment'); ?>
            </li>
        </ul>
    </div>
</div>
